/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.security.ssl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum SSLMode {
    DISABLE("disable"),
    ALLOW("allow"),
    PREFER("prefer"),
    REQUIRE("require"),
    VERIFY_CA("verify-ca"),
    VERIFY_FULL("verify-full");

    private final String value;
    private static final Map<String, SSLMode> CONSTANTS;

    private SSLMode(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static SSLMode fromValue(String value) {
        SSLMode constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, SSLMode>();
        for (SSLMode c : SSLMode.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

