/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.security.ssl;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.openmetadata.annotations.PasswordField;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"caCertificate", "sslCertificate", "sslKey"})
public class ValidateSSLClientConfig {
    @JsonProperty(value="caCertificate")
    @JsonPropertyDescription(value="The CA certificate used for SSL validation.")
    @PasswordField
    private String caCertificate;
    @JsonProperty(value="sslCertificate")
    @JsonPropertyDescription(value="The SSL certificate used for client authentication.")
    @PasswordField
    private String sslCertificate;
    @JsonProperty(value="sslKey")
    @JsonPropertyDescription(value="The private key associated with the SSL certificate.")
    @PasswordField
    private String sslKey;

    @JsonProperty(value="caCertificate")
    @PasswordField
    public String getCaCertificate() {
        return this.caCertificate;
    }

    @JsonProperty(value="caCertificate")
    @PasswordField
    public void setCaCertificate(String caCertificate) {
        this.caCertificate = caCertificate;
    }

    public ValidateSSLClientConfig withCaCertificate(String caCertificate) {
        this.caCertificate = caCertificate;
        return this;
    }

    @JsonProperty(value="sslCertificate")
    @PasswordField
    public String getSslCertificate() {
        return this.sslCertificate;
    }

    @JsonProperty(value="sslCertificate")
    @PasswordField
    public void setSslCertificate(String sslCertificate) {
        this.sslCertificate = sslCertificate;
    }

    public ValidateSSLClientConfig withSslCertificate(String sslCertificate) {
        this.sslCertificate = sslCertificate;
        return this;
    }

    @JsonProperty(value="sslKey")
    @PasswordField
    public String getSslKey() {
        return this.sslKey;
    }

    @JsonProperty(value="sslKey")
    @PasswordField
    public void setSslKey(String sslKey) {
        this.sslKey = sslKey;
    }

    public ValidateSSLClientConfig withSslKey(String sslKey) {
        this.sslKey = sslKey;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ValidateSSLClientConfig.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("caCertificate");
        sb.append('=');
        sb.append(this.caCertificate == null ? "<null>" : this.caCertificate);
        sb.append(',');
        sb.append("sslCertificate");
        sb.append('=');
        sb.append(this.sslCertificate == null ? "<null>" : this.sslCertificate);
        sb.append(',');
        sb.append("sslKey");
        sb.append('=');
        sb.append(this.sslKey == null ? "<null>" : this.sslKey);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.sslCertificate == null ? 0 : this.sslCertificate.hashCode());
        result = result * 31 + (this.caCertificate == null ? 0 : this.caCertificate.hashCode());
        result = result * 31 + (this.sslKey == null ? 0 : this.sslKey.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ValidateSSLClientConfig)) {
            return false;
        }
        ValidateSSLClientConfig rhs = (ValidateSSLClientConfig)other;
        return (this.sslCertificate == rhs.sslCertificate || this.sslCertificate != null && this.sslCertificate.equals(rhs.sslCertificate)) && (this.caCertificate == rhs.caCertificate || this.caCertificate != null && this.caCertificate.equals(rhs.caCertificate)) && (this.sslKey == rhs.sslKey || this.sslKey != null && this.sslKey.equals(rhs.sslKey));
    }
}

