/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.service.configuration.slackApp;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.constraints.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"clientId", "clientSecret", "signingSecret", "scopes", "callbackUrl", "callbackRedirectURL"})
public class SlackAppConfiguration {
    @JsonProperty(value="clientId")
    @JsonPropertyDescription(value="Client Id of the Application")
    @NotNull
    private String clientId;
    @JsonProperty(value="clientSecret")
    @JsonPropertyDescription(value="Client Secret of the Application.")
    @NotNull
    private String clientSecret;
    @JsonProperty(value="signingSecret")
    @JsonPropertyDescription(value="Signing Secret of the Application. Confirm that each request comes from Slack by verifying its unique signature.")
    @NotNull
    private String signingSecret;
    @JsonProperty(value="scopes")
    @JsonPropertyDescription(value="Scopes to Request in OAuth")
    @NotNull
    private String scopes;
    @JsonProperty(value="callbackUrl")
    @JsonPropertyDescription(value="The callback URL where temporary authorization code is exchanged for access tokens")
    @NotNull
    private String callbackUrl;
    @JsonProperty(value="callbackRedirectURL")
    @JsonPropertyDescription(value="The URL where the application redirects after handling the OAuth callback")
    @NotNull
    private String callbackRedirectURL;

    @JsonProperty(value="clientId")
    public String getClientId() {
        return this.clientId;
    }

    @JsonProperty(value="clientId")
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public SlackAppConfiguration withClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @JsonProperty(value="clientSecret")
    public String getClientSecret() {
        return this.clientSecret;
    }

    @JsonProperty(value="clientSecret")
    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public SlackAppConfiguration withClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    @JsonProperty(value="signingSecret")
    public String getSigningSecret() {
        return this.signingSecret;
    }

    @JsonProperty(value="signingSecret")
    public void setSigningSecret(String signingSecret) {
        this.signingSecret = signingSecret;
    }

    public SlackAppConfiguration withSigningSecret(String signingSecret) {
        this.signingSecret = signingSecret;
        return this;
    }

    @JsonProperty(value="scopes")
    public String getScopes() {
        return this.scopes;
    }

    @JsonProperty(value="scopes")
    public void setScopes(String scopes) {
        this.scopes = scopes;
    }

    public SlackAppConfiguration withScopes(String scopes) {
        this.scopes = scopes;
        return this;
    }

    @JsonProperty(value="callbackUrl")
    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    @JsonProperty(value="callbackUrl")
    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public SlackAppConfiguration withCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    @JsonProperty(value="callbackRedirectURL")
    public String getCallbackRedirectURL() {
        return this.callbackRedirectURL;
    }

    @JsonProperty(value="callbackRedirectURL")
    public void setCallbackRedirectURL(String callbackRedirectURL) {
        this.callbackRedirectURL = callbackRedirectURL;
    }

    public SlackAppConfiguration withCallbackRedirectURL(String callbackRedirectURL) {
        this.callbackRedirectURL = callbackRedirectURL;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(SlackAppConfiguration.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("clientId");
        sb.append('=');
        sb.append(this.clientId == null ? "<null>" : this.clientId);
        sb.append(',');
        sb.append("clientSecret");
        sb.append('=');
        sb.append(this.clientSecret == null ? "<null>" : this.clientSecret);
        sb.append(',');
        sb.append("signingSecret");
        sb.append('=');
        sb.append(this.signingSecret == null ? "<null>" : this.signingSecret);
        sb.append(',');
        sb.append("scopes");
        sb.append('=');
        sb.append(this.scopes == null ? "<null>" : this.scopes);
        sb.append(',');
        sb.append("callbackUrl");
        sb.append('=');
        sb.append(this.callbackUrl == null ? "<null>" : this.callbackUrl);
        sb.append(',');
        sb.append("callbackRedirectURL");
        sb.append('=');
        sb.append(this.callbackRedirectURL == null ? "<null>" : this.callbackRedirectURL);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.callbackRedirectURL == null ? 0 : this.callbackRedirectURL.hashCode());
        result = result * 31 + (this.clientId == null ? 0 : this.clientId.hashCode());
        result = result * 31 + (this.signingSecret == null ? 0 : this.signingSecret.hashCode());
        result = result * 31 + (this.clientSecret == null ? 0 : this.clientSecret.hashCode());
        result = result * 31 + (this.callbackUrl == null ? 0 : this.callbackUrl.hashCode());
        result = result * 31 + (this.scopes == null ? 0 : this.scopes.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SlackAppConfiguration)) {
            return false;
        }
        SlackAppConfiguration rhs = (SlackAppConfiguration)other;
        return (this.callbackRedirectURL == rhs.callbackRedirectURL || this.callbackRedirectURL != null && this.callbackRedirectURL.equals(rhs.callbackRedirectURL)) && (this.clientId == rhs.clientId || this.clientId != null && this.clientId.equals(rhs.clientId)) && (this.signingSecret == rhs.signingSecret || this.signingSecret != null && this.signingSecret.equals(rhs.signingSecret)) && (this.clientSecret == rhs.clientSecret || this.clientSecret != null && this.clientSecret.equals(rhs.clientSecret)) && (this.callbackUrl == rhs.callbackUrl || this.callbackUrl != null && this.callbackUrl.equals(rhs.callbackUrl)) && (this.scopes == rhs.scopes || this.scopes != null && this.scopes.equals(rhs.scopes));
    }
}

