/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.services.connections.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.openmetadata.annotations.ExposedField;
import org.openmetadata.annotations.PasswordField;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "openAPISchemaURL", "token"})
public class RESTConnection {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="REST API type")
    private RESTAPIType type = RESTAPIType.fromValue("REST");
    @JsonProperty(value="openAPISchemaURL")
    @JsonPropertyDescription(value="Open API Schema URL.")
    @ExposedField
    @NotNull
    private URI openAPISchemaURL;
    @JsonProperty(value="token")
    @JsonPropertyDescription(value="Generated Token to connect to OpenAPI Schema.")
    @PasswordField
    private String token;

    @JsonProperty(value="type")
    public RESTAPIType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(RESTAPIType type) {
        this.type = type;
    }

    public RESTConnection withType(RESTAPIType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="openAPISchemaURL")
    @ExposedField
    public URI getOpenAPISchemaURL() {
        return this.openAPISchemaURL;
    }

    @JsonProperty(value="openAPISchemaURL")
    @ExposedField
    public void setOpenAPISchemaURL(URI openAPISchemaURL) {
        this.openAPISchemaURL = openAPISchemaURL;
    }

    public RESTConnection withOpenAPISchemaURL(URI openAPISchemaURL) {
        this.openAPISchemaURL = openAPISchemaURL;
        return this;
    }

    @JsonProperty(value="token")
    @PasswordField
    public String getToken() {
        return this.token;
    }

    @JsonProperty(value="token")
    @PasswordField
    public void setToken(String token) {
        this.token = token;
    }

    public RESTConnection withToken(String token) {
        this.token = token;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(RESTConnection.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("openAPISchemaURL");
        sb.append('=');
        sb.append(this.openAPISchemaURL == null ? "<null>" : this.openAPISchemaURL);
        sb.append(',');
        sb.append("token");
        sb.append('=');
        sb.append(this.token == null ? "<null>" : this.token);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.openAPISchemaURL == null ? 0 : this.openAPISchemaURL.hashCode());
        result = result * 31 + (this.token == null ? 0 : this.token.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof RESTConnection)) {
            return false;
        }
        RESTConnection rhs = (RESTConnection)other;
        return (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.openAPISchemaURL == rhs.openAPISchemaURL || this.openAPISchemaURL != null && this.openAPISchemaURL.equals(rhs.openAPISchemaURL)) && (this.token == rhs.token || this.token != null && this.token.equals(rhs.token));
    }

    public static enum RESTAPIType {
        REST("REST");

        private final String value;
        private static final Map<String, RESTAPIType> CONSTANTS;

        private RESTAPIType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static RESTAPIType fromValue(String value) {
            RESTAPIType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, RESTAPIType>();
            for (RESTAPIType c : RESTAPIType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

