/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.services.connections.dashboard;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.openmetadata.annotations.ExposedField;
import org.openmetadata.annotations.PasswordField;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "clientId", "secretToken", "accessToken", "apiHost", "instanceDomain", "supportsMetadataExtraction"})
public class DomoDashboardConnection {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value=" service type")
    private DomoDashboardType type = DomoDashboardType.fromValue("DomoDashboard");
    @JsonProperty(value="clientId")
    @JsonPropertyDescription(value="Client ID for DOMO")
    @NotNull
    private String clientId;
    @JsonProperty(value="secretToken")
    @JsonPropertyDescription(value="Secret Token to connect DOMO")
    @PasswordField
    @NotNull
    private String secretToken;
    @JsonProperty(value="accessToken")
    @JsonPropertyDescription(value="Access token to connect to DOMO")
    private String accessToken;
    @JsonProperty(value="apiHost")
    @JsonPropertyDescription(value="API Host to connect to DOMO instance")
    @ExposedField
    private String apiHost = "api.domo.com";
    @JsonProperty(value="instanceDomain")
    @JsonPropertyDescription(value="URL of your Domo instance, e.g., https://openmetadata.domo.com")
    @NotNull
    private URI instanceDomain;
    @JsonProperty(value="supportsMetadataExtraction")
    @JsonPropertyDescription(value="Supports Metadata Extraction.")
    private Boolean supportsMetadataExtraction = true;

    @JsonProperty(value="type")
    public DomoDashboardType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(DomoDashboardType type) {
        this.type = type;
    }

    public DomoDashboardConnection withType(DomoDashboardType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="clientId")
    public String getClientId() {
        return this.clientId;
    }

    @JsonProperty(value="clientId")
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public DomoDashboardConnection withClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @JsonProperty(value="secretToken")
    @PasswordField
    public String getSecretToken() {
        return this.secretToken;
    }

    @JsonProperty(value="secretToken")
    @PasswordField
    public void setSecretToken(String secretToken) {
        this.secretToken = secretToken;
    }

    public DomoDashboardConnection withSecretToken(String secretToken) {
        this.secretToken = secretToken;
        return this;
    }

    @JsonProperty(value="accessToken")
    public String getAccessToken() {
        return this.accessToken;
    }

    @JsonProperty(value="accessToken")
    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public DomoDashboardConnection withAccessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    @JsonProperty(value="apiHost")
    @ExposedField
    public String getApiHost() {
        return this.apiHost;
    }

    @JsonProperty(value="apiHost")
    @ExposedField
    public void setApiHost(String apiHost) {
        this.apiHost = apiHost;
    }

    public DomoDashboardConnection withApiHost(String apiHost) {
        this.apiHost = apiHost;
        return this;
    }

    @JsonProperty(value="instanceDomain")
    public URI getInstanceDomain() {
        return this.instanceDomain;
    }

    @JsonProperty(value="instanceDomain")
    public void setInstanceDomain(URI instanceDomain) {
        this.instanceDomain = instanceDomain;
    }

    public DomoDashboardConnection withInstanceDomain(URI instanceDomain) {
        this.instanceDomain = instanceDomain;
        return this;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public Boolean getSupportsMetadataExtraction() {
        return this.supportsMetadataExtraction;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public void setSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
    }

    public DomoDashboardConnection withSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DomoDashboardConnection.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("clientId");
        sb.append('=');
        sb.append(this.clientId == null ? "<null>" : this.clientId);
        sb.append(',');
        sb.append("secretToken");
        sb.append('=');
        sb.append(this.secretToken == null ? "<null>" : this.secretToken);
        sb.append(',');
        sb.append("accessToken");
        sb.append('=');
        sb.append(this.accessToken == null ? "<null>" : this.accessToken);
        sb.append(',');
        sb.append("apiHost");
        sb.append('=');
        sb.append(this.apiHost == null ? "<null>" : this.apiHost);
        sb.append(',');
        sb.append("instanceDomain");
        sb.append('=');
        sb.append(this.instanceDomain == null ? "<null>" : this.instanceDomain);
        sb.append(',');
        sb.append("supportsMetadataExtraction");
        sb.append('=');
        sb.append(this.supportsMetadataExtraction == null ? "<null>" : this.supportsMetadataExtraction);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.supportsMetadataExtraction == null ? 0 : this.supportsMetadataExtraction.hashCode());
        result = result * 31 + (this.clientId == null ? 0 : this.clientId.hashCode());
        result = result * 31 + (this.secretToken == null ? 0 : this.secretToken.hashCode());
        result = result * 31 + (this.apiHost == null ? 0 : this.apiHost.hashCode());
        result = result * 31 + (this.instanceDomain == null ? 0 : this.instanceDomain.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.accessToken == null ? 0 : this.accessToken.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof DomoDashboardConnection)) {
            return false;
        }
        DomoDashboardConnection rhs = (DomoDashboardConnection)other;
        return (this.supportsMetadataExtraction == rhs.supportsMetadataExtraction || this.supportsMetadataExtraction != null && this.supportsMetadataExtraction.equals(rhs.supportsMetadataExtraction)) && (this.clientId == rhs.clientId || this.clientId != null && this.clientId.equals(rhs.clientId)) && (this.secretToken == rhs.secretToken || this.secretToken != null && this.secretToken.equals(rhs.secretToken)) && (this.apiHost == rhs.apiHost || this.apiHost != null && this.apiHost.equals(rhs.apiHost)) && (this.instanceDomain == rhs.instanceDomain || this.instanceDomain != null && this.instanceDomain.equals(rhs.instanceDomain)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.accessToken == rhs.accessToken || this.accessToken != null && this.accessToken.equals(rhs.accessToken));
    }

    public static enum DomoDashboardType {
        DOMO_DASHBOARD("DomoDashboard");

        private final String value;
        private static final Map<String, DomoDashboardType> CONSTANTS;

        private DomoDashboardType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static DomoDashboardType fromValue(String value) {
            DomoDashboardType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, DomoDashboardType>();
            for (DomoDashboardType c : DomoDashboardType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

