/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.services.connections.dashboard;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.openmetadata.annotations.ExposedField;
import org.openmetadata.annotations.PasswordField;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "hostPort", "apiKey", "projectUUID", "spaceUUID", "proxyAuthentication", "supportsMetadataExtraction"})
public class LightdashConnection {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Lightdash service type")
    private LightdashType type = LightdashType.fromValue("Lightdash");
    @JsonProperty(value="hostPort")
    @JsonPropertyDescription(value="Address for your running Lightdash instance")
    @ExposedField
    @NotNull
    private URI hostPort = URI.create("http://localhost:5000");
    @JsonProperty(value="apiKey")
    @JsonPropertyDescription(value="The personal access token you can generate in the Lightdash app under the user settings")
    @PasswordField
    @NotNull
    private String apiKey;
    @JsonProperty(value="projectUUID")
    @JsonPropertyDescription(value="The Project UUID for your Lightdash instance")
    @NotNull
    private String projectUUID;
    @JsonProperty(value="spaceUUID")
    @JsonPropertyDescription(value="The Space UUID for your Lightdash instance")
    @NotNull
    private String spaceUUID;
    @JsonProperty(value="proxyAuthentication")
    @JsonPropertyDescription(value="Use if your Lightdash instance is behind a proxy like (Cloud IAP)")
    @PasswordField
    private String proxyAuthentication;
    @JsonProperty(value="supportsMetadataExtraction")
    @JsonPropertyDescription(value="Supports Metadata Extraction.")
    private Boolean supportsMetadataExtraction = true;

    @JsonProperty(value="type")
    public LightdashType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(LightdashType type) {
        this.type = type;
    }

    public LightdashConnection withType(LightdashType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="hostPort")
    @ExposedField
    public URI getHostPort() {
        return this.hostPort;
    }

    @JsonProperty(value="hostPort")
    @ExposedField
    public void setHostPort(URI hostPort) {
        this.hostPort = hostPort;
    }

    public LightdashConnection withHostPort(URI hostPort) {
        this.hostPort = hostPort;
        return this;
    }

    @JsonProperty(value="apiKey")
    @PasswordField
    public String getApiKey() {
        return this.apiKey;
    }

    @JsonProperty(value="apiKey")
    @PasswordField
    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public LightdashConnection withApiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    @JsonProperty(value="projectUUID")
    public String getProjectUUID() {
        return this.projectUUID;
    }

    @JsonProperty(value="projectUUID")
    public void setProjectUUID(String projectUUID) {
        this.projectUUID = projectUUID;
    }

    public LightdashConnection withProjectUUID(String projectUUID) {
        this.projectUUID = projectUUID;
        return this;
    }

    @JsonProperty(value="spaceUUID")
    public String getSpaceUUID() {
        return this.spaceUUID;
    }

    @JsonProperty(value="spaceUUID")
    public void setSpaceUUID(String spaceUUID) {
        this.spaceUUID = spaceUUID;
    }

    public LightdashConnection withSpaceUUID(String spaceUUID) {
        this.spaceUUID = spaceUUID;
        return this;
    }

    @JsonProperty(value="proxyAuthentication")
    @PasswordField
    public String getProxyAuthentication() {
        return this.proxyAuthentication;
    }

    @JsonProperty(value="proxyAuthentication")
    @PasswordField
    public void setProxyAuthentication(String proxyAuthentication) {
        this.proxyAuthentication = proxyAuthentication;
    }

    public LightdashConnection withProxyAuthentication(String proxyAuthentication) {
        this.proxyAuthentication = proxyAuthentication;
        return this;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public Boolean getSupportsMetadataExtraction() {
        return this.supportsMetadataExtraction;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public void setSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
    }

    public LightdashConnection withSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(LightdashConnection.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("hostPort");
        sb.append('=');
        sb.append(this.hostPort == null ? "<null>" : this.hostPort);
        sb.append(',');
        sb.append("apiKey");
        sb.append('=');
        sb.append(this.apiKey == null ? "<null>" : this.apiKey);
        sb.append(',');
        sb.append("projectUUID");
        sb.append('=');
        sb.append(this.projectUUID == null ? "<null>" : this.projectUUID);
        sb.append(',');
        sb.append("spaceUUID");
        sb.append('=');
        sb.append(this.spaceUUID == null ? "<null>" : this.spaceUUID);
        sb.append(',');
        sb.append("proxyAuthentication");
        sb.append('=');
        sb.append(this.proxyAuthentication == null ? "<null>" : this.proxyAuthentication);
        sb.append(',');
        sb.append("supportsMetadataExtraction");
        sb.append('=');
        sb.append(this.supportsMetadataExtraction == null ? "<null>" : this.supportsMetadataExtraction);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.supportsMetadataExtraction == null ? 0 : this.supportsMetadataExtraction.hashCode());
        result = result * 31 + (this.apiKey == null ? 0 : this.apiKey.hashCode());
        result = result * 31 + (this.spaceUUID == null ? 0 : this.spaceUUID.hashCode());
        result = result * 31 + (this.hostPort == null ? 0 : this.hostPort.hashCode());
        result = result * 31 + (this.proxyAuthentication == null ? 0 : this.proxyAuthentication.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.projectUUID == null ? 0 : this.projectUUID.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof LightdashConnection)) {
            return false;
        }
        LightdashConnection rhs = (LightdashConnection)other;
        return (this.supportsMetadataExtraction == rhs.supportsMetadataExtraction || this.supportsMetadataExtraction != null && this.supportsMetadataExtraction.equals(rhs.supportsMetadataExtraction)) && (this.apiKey == rhs.apiKey || this.apiKey != null && this.apiKey.equals(rhs.apiKey)) && (this.spaceUUID == rhs.spaceUUID || this.spaceUUID != null && this.spaceUUID.equals(rhs.spaceUUID)) && (this.hostPort == rhs.hostPort || this.hostPort != null && this.hostPort.equals(rhs.hostPort)) && (this.proxyAuthentication == rhs.proxyAuthentication || this.proxyAuthentication != null && this.proxyAuthentication.equals(rhs.proxyAuthentication)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.projectUUID == rhs.projectUUID || this.projectUUID != null && this.projectUUID.equals(rhs.projectUUID));
    }

    public static enum LightdashType {
        LIGHTDASH("Lightdash");

        private final String value;
        private static final Map<String, LightdashType> CONSTANTS;

        private LightdashType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static LightdashType fromValue(String value) {
            LightdashType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, LightdashType>();
            for (LightdashType c : LightdashType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

