/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.services.connections.dashboard;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.openmetadata.annotations.ExposedField;
import org.openmetadata.annotations.PasswordField;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "clientId", "clientSecret", "hostPort", "gitCredentials", "supportsMetadataExtraction"})
public class LookerConnection {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Looker service type")
    private LookerType type = LookerType.fromValue("Looker");
    @JsonProperty(value="clientId")
    @JsonPropertyDescription(value="User's Client ID. This user should have privileges to read all the metadata in Looker.")
    @NotNull
    private String clientId;
    @JsonProperty(value="clientSecret")
    @JsonPropertyDescription(value="User's Client Secret.")
    @PasswordField
    @NotNull
    private String clientSecret;
    @JsonProperty(value="hostPort")
    @JsonPropertyDescription(value="URL to the Looker instance.")
    @ExposedField
    @NotNull
    private URI hostPort;
    @JsonProperty(value="gitCredentials")
    @JsonPropertyDescription(value="Credentials to extract the .lkml files from a repository. This is required to get all the lineage and definitions.")
    private Object gitCredentials;
    @JsonProperty(value="supportsMetadataExtraction")
    @JsonPropertyDescription(value="Supports Metadata Extraction.")
    private Boolean supportsMetadataExtraction = true;

    @JsonProperty(value="type")
    public LookerType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(LookerType type) {
        this.type = type;
    }

    public LookerConnection withType(LookerType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="clientId")
    public String getClientId() {
        return this.clientId;
    }

    @JsonProperty(value="clientId")
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public LookerConnection withClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @JsonProperty(value="clientSecret")
    @PasswordField
    public String getClientSecret() {
        return this.clientSecret;
    }

    @JsonProperty(value="clientSecret")
    @PasswordField
    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public LookerConnection withClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    @JsonProperty(value="hostPort")
    @ExposedField
    public URI getHostPort() {
        return this.hostPort;
    }

    @JsonProperty(value="hostPort")
    @ExposedField
    public void setHostPort(URI hostPort) {
        this.hostPort = hostPort;
    }

    public LookerConnection withHostPort(URI hostPort) {
        this.hostPort = hostPort;
        return this;
    }

    @JsonProperty(value="gitCredentials")
    public Object getGitCredentials() {
        return this.gitCredentials;
    }

    @JsonProperty(value="gitCredentials")
    public void setGitCredentials(Object gitCredentials) {
        this.gitCredentials = gitCredentials;
    }

    public LookerConnection withGitCredentials(Object gitCredentials) {
        this.gitCredentials = gitCredentials;
        return this;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public Boolean getSupportsMetadataExtraction() {
        return this.supportsMetadataExtraction;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public void setSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
    }

    public LookerConnection withSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(LookerConnection.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("clientId");
        sb.append('=');
        sb.append(this.clientId == null ? "<null>" : this.clientId);
        sb.append(',');
        sb.append("clientSecret");
        sb.append('=');
        sb.append(this.clientSecret == null ? "<null>" : this.clientSecret);
        sb.append(',');
        sb.append("hostPort");
        sb.append('=');
        sb.append(this.hostPort == null ? "<null>" : this.hostPort);
        sb.append(',');
        sb.append("gitCredentials");
        sb.append('=');
        sb.append(this.gitCredentials == null ? "<null>" : this.gitCredentials);
        sb.append(',');
        sb.append("supportsMetadataExtraction");
        sb.append('=');
        sb.append(this.supportsMetadataExtraction == null ? "<null>" : this.supportsMetadataExtraction);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.gitCredentials == null ? 0 : this.gitCredentials.hashCode());
        result = result * 31 + (this.supportsMetadataExtraction == null ? 0 : this.supportsMetadataExtraction.hashCode());
        result = result * 31 + (this.clientId == null ? 0 : this.clientId.hashCode());
        result = result * 31 + (this.clientSecret == null ? 0 : this.clientSecret.hashCode());
        result = result * 31 + (this.hostPort == null ? 0 : this.hostPort.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof LookerConnection)) {
            return false;
        }
        LookerConnection rhs = (LookerConnection)other;
        return (this.gitCredentials == rhs.gitCredentials || this.gitCredentials != null && this.gitCredentials.equals(rhs.gitCredentials)) && (this.supportsMetadataExtraction == rhs.supportsMetadataExtraction || this.supportsMetadataExtraction != null && this.supportsMetadataExtraction.equals(rhs.supportsMetadataExtraction)) && (this.clientId == rhs.clientId || this.clientId != null && this.clientId.equals(rhs.clientId)) && (this.clientSecret == rhs.clientSecret || this.clientSecret != null && this.clientSecret.equals(rhs.clientSecret)) && (this.hostPort == rhs.hostPort || this.hostPort != null && this.hostPort.equals(rhs.hostPort)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type));
    }

    public static enum LookerType {
        LOOKER("Looker");

        private final String value;
        private static final Map<String, LookerType> CONSTANTS;

        private LookerType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static LookerType fromValue(String value) {
            LookerType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, LookerType>();
            for (LookerType c : LookerType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

