/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.services.connections.dashboard;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.annotations.ExposedField;
import org.openmetadata.annotations.PasswordField;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "clientId", "clientSecret", "tenantId", "authorityURI", "hostPort", "scope", "pagination_entity_per_page", "useAdminApis", "pbitFilesSource", "supportsMetadataExtraction"})
public class PowerBIConnection {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="PowerBI service type")
    private PowerBiType type = PowerBiType.fromValue("PowerBI");
    @JsonProperty(value="clientId")
    @JsonPropertyDescription(value="client_id for PowerBI.")
    @NotNull
    private String clientId;
    @JsonProperty(value="clientSecret")
    @JsonPropertyDescription(value="clientSecret for PowerBI.")
    @PasswordField
    @NotNull
    private String clientSecret;
    @JsonProperty(value="tenantId")
    @JsonPropertyDescription(value="Tenant ID for PowerBI.")
    @NotNull
    private String tenantId;
    @JsonProperty(value="authorityURI")
    @JsonPropertyDescription(value="Authority URI for the PowerBI service.")
    private String authorityURI = "https://login.microsoftonline.com/";
    @JsonProperty(value="hostPort")
    @JsonPropertyDescription(value="Dashboard URL for PowerBI service.")
    @ExposedField
    private URI hostPort = URI.create("https://app.powerbi.com");
    @JsonProperty(value="scope")
    @JsonPropertyDescription(value="PowerBI secrets.")
    @Valid
    private List<String> scope = new ArrayList<String>(Arrays.asList("https://analysis.windows.net/powerbi/api/.default"));
    @JsonProperty(value="pagination_entity_per_page")
    @JsonPropertyDescription(value="Entity Limit set here will be used to paginate the PowerBi APIs")
    private Integer paginationEntityPerPage = 100;
    @JsonProperty(value="useAdminApis")
    @JsonPropertyDescription(value="Fetch the PowerBI metadata using admin APIs")
    private Boolean useAdminApis = true;
    @JsonProperty(value="pbitFilesSource")
    @JsonPropertyDescription(value="Source to get the .pbit files to extract lineage information")
    private Object pbitFilesSource;
    @JsonProperty(value="supportsMetadataExtraction")
    @JsonPropertyDescription(value="Supports Metadata Extraction.")
    private Boolean supportsMetadataExtraction = true;

    @JsonProperty(value="type")
    public PowerBiType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(PowerBiType type) {
        this.type = type;
    }

    public PowerBIConnection withType(PowerBiType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="clientId")
    public String getClientId() {
        return this.clientId;
    }

    @JsonProperty(value="clientId")
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public PowerBIConnection withClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @JsonProperty(value="clientSecret")
    @PasswordField
    public String getClientSecret() {
        return this.clientSecret;
    }

    @JsonProperty(value="clientSecret")
    @PasswordField
    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public PowerBIConnection withClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    @JsonProperty(value="tenantId")
    public String getTenantId() {
        return this.tenantId;
    }

    @JsonProperty(value="tenantId")
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public PowerBIConnection withTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @JsonProperty(value="authorityURI")
    public String getAuthorityURI() {
        return this.authorityURI;
    }

    @JsonProperty(value="authorityURI")
    public void setAuthorityURI(String authorityURI) {
        this.authorityURI = authorityURI;
    }

    public PowerBIConnection withAuthorityURI(String authorityURI) {
        this.authorityURI = authorityURI;
        return this;
    }

    @JsonProperty(value="hostPort")
    @ExposedField
    public URI getHostPort() {
        return this.hostPort;
    }

    @JsonProperty(value="hostPort")
    @ExposedField
    public void setHostPort(URI hostPort) {
        this.hostPort = hostPort;
    }

    public PowerBIConnection withHostPort(URI hostPort) {
        this.hostPort = hostPort;
        return this;
    }

    @JsonProperty(value="scope")
    public List<String> getScope() {
        return this.scope;
    }

    @JsonProperty(value="scope")
    public void setScope(List<String> scope) {
        this.scope = scope;
    }

    public PowerBIConnection withScope(List<String> scope) {
        this.scope = scope;
        return this;
    }

    @JsonProperty(value="pagination_entity_per_page")
    public Integer getPaginationEntityPerPage() {
        return this.paginationEntityPerPage;
    }

    @JsonProperty(value="pagination_entity_per_page")
    public void setPaginationEntityPerPage(Integer paginationEntityPerPage) {
        this.paginationEntityPerPage = paginationEntityPerPage;
    }

    public PowerBIConnection withPaginationEntityPerPage(Integer paginationEntityPerPage) {
        this.paginationEntityPerPage = paginationEntityPerPage;
        return this;
    }

    @JsonProperty(value="useAdminApis")
    public Boolean getUseAdminApis() {
        return this.useAdminApis;
    }

    @JsonProperty(value="useAdminApis")
    public void setUseAdminApis(Boolean useAdminApis) {
        this.useAdminApis = useAdminApis;
    }

    public PowerBIConnection withUseAdminApis(Boolean useAdminApis) {
        this.useAdminApis = useAdminApis;
        return this;
    }

    @JsonProperty(value="pbitFilesSource")
    public Object getPbitFilesSource() {
        return this.pbitFilesSource;
    }

    @JsonProperty(value="pbitFilesSource")
    public void setPbitFilesSource(Object pbitFilesSource) {
        this.pbitFilesSource = pbitFilesSource;
    }

    public PowerBIConnection withPbitFilesSource(Object pbitFilesSource) {
        this.pbitFilesSource = pbitFilesSource;
        return this;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public Boolean getSupportsMetadataExtraction() {
        return this.supportsMetadataExtraction;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public void setSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
    }

    public PowerBIConnection withSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(PowerBIConnection.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("clientId");
        sb.append('=');
        sb.append(this.clientId == null ? "<null>" : this.clientId);
        sb.append(',');
        sb.append("clientSecret");
        sb.append('=');
        sb.append(this.clientSecret == null ? "<null>" : this.clientSecret);
        sb.append(',');
        sb.append("tenantId");
        sb.append('=');
        sb.append(this.tenantId == null ? "<null>" : this.tenantId);
        sb.append(',');
        sb.append("authorityURI");
        sb.append('=');
        sb.append(this.authorityURI == null ? "<null>" : this.authorityURI);
        sb.append(',');
        sb.append("hostPort");
        sb.append('=');
        sb.append(this.hostPort == null ? "<null>" : this.hostPort);
        sb.append(',');
        sb.append("scope");
        sb.append('=');
        sb.append(this.scope == null ? "<null>" : this.scope);
        sb.append(',');
        sb.append("paginationEntityPerPage");
        sb.append('=');
        sb.append(this.paginationEntityPerPage == null ? "<null>" : this.paginationEntityPerPage);
        sb.append(',');
        sb.append("useAdminApis");
        sb.append('=');
        sb.append(this.useAdminApis == null ? "<null>" : this.useAdminApis);
        sb.append(',');
        sb.append("pbitFilesSource");
        sb.append('=');
        sb.append(this.pbitFilesSource == null ? "<null>" : this.pbitFilesSource);
        sb.append(',');
        sb.append("supportsMetadataExtraction");
        sb.append('=');
        sb.append(this.supportsMetadataExtraction == null ? "<null>" : this.supportsMetadataExtraction);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.supportsMetadataExtraction == null ? 0 : this.supportsMetadataExtraction.hashCode());
        result = result * 31 + (this.clientId == null ? 0 : this.clientId.hashCode());
        result = result * 31 + (this.authorityURI == null ? 0 : this.authorityURI.hashCode());
        result = result * 31 + (this.scope == null ? 0 : this.scope.hashCode());
        result = result * 31 + (this.pbitFilesSource == null ? 0 : this.pbitFilesSource.hashCode());
        result = result * 31 + (this.tenantId == null ? 0 : this.tenantId.hashCode());
        result = result * 31 + (this.clientSecret == null ? 0 : this.clientSecret.hashCode());
        result = result * 31 + (this.hostPort == null ? 0 : this.hostPort.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.useAdminApis == null ? 0 : this.useAdminApis.hashCode());
        result = result * 31 + (this.paginationEntityPerPage == null ? 0 : this.paginationEntityPerPage.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof PowerBIConnection)) {
            return false;
        }
        PowerBIConnection rhs = (PowerBIConnection)other;
        return (this.supportsMetadataExtraction == rhs.supportsMetadataExtraction || this.supportsMetadataExtraction != null && this.supportsMetadataExtraction.equals(rhs.supportsMetadataExtraction)) && (this.clientId == rhs.clientId || this.clientId != null && this.clientId.equals(rhs.clientId)) && (this.authorityURI == rhs.authorityURI || this.authorityURI != null && this.authorityURI.equals(rhs.authorityURI)) && (this.scope == rhs.scope || this.scope != null && this.scope.equals(rhs.scope)) && (this.pbitFilesSource == rhs.pbitFilesSource || this.pbitFilesSource != null && this.pbitFilesSource.equals(rhs.pbitFilesSource)) && (this.tenantId == rhs.tenantId || this.tenantId != null && this.tenantId.equals(rhs.tenantId)) && (this.clientSecret == rhs.clientSecret || this.clientSecret != null && this.clientSecret.equals(rhs.clientSecret)) && (this.hostPort == rhs.hostPort || this.hostPort != null && this.hostPort.equals(rhs.hostPort)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.useAdminApis == rhs.useAdminApis || this.useAdminApis != null && this.useAdminApis.equals(rhs.useAdminApis)) && (this.paginationEntityPerPage == rhs.paginationEntityPerPage || this.paginationEntityPerPage != null && this.paginationEntityPerPage.equals(rhs.paginationEntityPerPage));
    }

    public static enum PowerBiType {
        POWER_BI("PowerBI");

        private final String value;
        private static final Map<String, PowerBiType> CONSTANTS;

        private PowerBiType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static PowerBiType fromValue(String value) {
            PowerBiType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, PowerBiType>();
            for (PowerBiType c : PowerBiType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

