/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.services.connections.dashboard;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.openmetadata.annotations.ExposedField;
import org.openmetadata.annotations.PasswordField;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "hostPort", "username", "password", "webPortalVirtualDirectory", "supportsMetadataExtraction"})
public class PowerBIReportServerConnection {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="PowerBIReportServer service type")
    private PowerBIReportServerType type = PowerBIReportServerType.fromValue("PowerBIReportServer");
    @JsonProperty(value="hostPort")
    @JsonPropertyDescription(value="Dashboard URL for PowerBI Report Server.")
    @ExposedField
    @NotNull
    private URI hostPort;
    @JsonProperty(value="username")
    @JsonPropertyDescription(value="Username to connect to PowerBI report server.")
    @NotNull
    private String username;
    @JsonProperty(value="password")
    @JsonPropertyDescription(value="Password to connect to PowerBI report server.")
    @PasswordField
    @NotNull
    private String password;
    @JsonProperty(value="webPortalVirtualDirectory")
    @JsonPropertyDescription(value="Web Portal Virtual Directory Name.")
    private String webPortalVirtualDirectory = "Reports";
    @JsonProperty(value="supportsMetadataExtraction")
    @JsonPropertyDescription(value="Supports Metadata Extraction.")
    private Boolean supportsMetadataExtraction = true;

    @JsonProperty(value="type")
    public PowerBIReportServerType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(PowerBIReportServerType type) {
        this.type = type;
    }

    public PowerBIReportServerConnection withType(PowerBIReportServerType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="hostPort")
    @ExposedField
    public URI getHostPort() {
        return this.hostPort;
    }

    @JsonProperty(value="hostPort")
    @ExposedField
    public void setHostPort(URI hostPort) {
        this.hostPort = hostPort;
    }

    public PowerBIReportServerConnection withHostPort(URI hostPort) {
        this.hostPort = hostPort;
        return this;
    }

    @JsonProperty(value="username")
    public String getUsername() {
        return this.username;
    }

    @JsonProperty(value="username")
    public void setUsername(String username) {
        this.username = username;
    }

    public PowerBIReportServerConnection withUsername(String username) {
        this.username = username;
        return this;
    }

    @JsonProperty(value="password")
    @PasswordField
    public String getPassword() {
        return this.password;
    }

    @JsonProperty(value="password")
    @PasswordField
    public void setPassword(String password) {
        this.password = password;
    }

    public PowerBIReportServerConnection withPassword(String password) {
        this.password = password;
        return this;
    }

    @JsonProperty(value="webPortalVirtualDirectory")
    public String getWebPortalVirtualDirectory() {
        return this.webPortalVirtualDirectory;
    }

    @JsonProperty(value="webPortalVirtualDirectory")
    public void setWebPortalVirtualDirectory(String webPortalVirtualDirectory) {
        this.webPortalVirtualDirectory = webPortalVirtualDirectory;
    }

    public PowerBIReportServerConnection withWebPortalVirtualDirectory(String webPortalVirtualDirectory) {
        this.webPortalVirtualDirectory = webPortalVirtualDirectory;
        return this;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public Boolean getSupportsMetadataExtraction() {
        return this.supportsMetadataExtraction;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public void setSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
    }

    public PowerBIReportServerConnection withSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(PowerBIReportServerConnection.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("hostPort");
        sb.append('=');
        sb.append(this.hostPort == null ? "<null>" : this.hostPort);
        sb.append(',');
        sb.append("username");
        sb.append('=');
        sb.append(this.username == null ? "<null>" : this.username);
        sb.append(',');
        sb.append("password");
        sb.append('=');
        sb.append(this.password == null ? "<null>" : this.password);
        sb.append(',');
        sb.append("webPortalVirtualDirectory");
        sb.append('=');
        sb.append(this.webPortalVirtualDirectory == null ? "<null>" : this.webPortalVirtualDirectory);
        sb.append(',');
        sb.append("supportsMetadataExtraction");
        sb.append('=');
        sb.append(this.supportsMetadataExtraction == null ? "<null>" : this.supportsMetadataExtraction);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.supportsMetadataExtraction == null ? 0 : this.supportsMetadataExtraction.hashCode());
        result = result * 31 + (this.password == null ? 0 : this.password.hashCode());
        result = result * 31 + (this.hostPort == null ? 0 : this.hostPort.hashCode());
        result = result * 31 + (this.webPortalVirtualDirectory == null ? 0 : this.webPortalVirtualDirectory.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.username == null ? 0 : this.username.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof PowerBIReportServerConnection)) {
            return false;
        }
        PowerBIReportServerConnection rhs = (PowerBIReportServerConnection)other;
        return (this.supportsMetadataExtraction == rhs.supportsMetadataExtraction || this.supportsMetadataExtraction != null && this.supportsMetadataExtraction.equals(rhs.supportsMetadataExtraction)) && (this.password == rhs.password || this.password != null && this.password.equals(rhs.password)) && (this.hostPort == rhs.hostPort || this.hostPort != null && this.hostPort.equals(rhs.hostPort)) && (this.webPortalVirtualDirectory == rhs.webPortalVirtualDirectory || this.webPortalVirtualDirectory != null && this.webPortalVirtualDirectory.equals(rhs.webPortalVirtualDirectory)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.username == rhs.username || this.username != null && this.username.equals(rhs.username));
    }

    public static enum PowerBIReportServerType {
        POWER_BI_REPORT_SERVER("PowerBIReportServer");

        private final String value;
        private static final Map<String, PowerBIReportServerType> CONSTANTS;

        private PowerBIReportServerType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static PowerBIReportServerType fromValue(String value) {
            PowerBIReportServerType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, PowerBIReportServerType>();
            for (PowerBIReportServerType c : PowerBIReportServerType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

