/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.services.connections.dashboard;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.openmetadata.annotations.ExposedField;
import org.openmetadata.annotations.PasswordField;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "token", "hostPort", "supportsMetadataExtraction"})
public class QlikCloudConnection {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Qlik Cloud service type")
    private QlikCloudType type = QlikCloudType.fromValue("QlikCloud");
    @JsonProperty(value="token")
    @JsonPropertyDescription(value="token to connect to Qlik Cloud.")
    @PasswordField
    @NotNull
    private String token;
    @JsonProperty(value="hostPort")
    @JsonPropertyDescription(value="Host and Port of the Qlik Cloud instance.")
    @ExposedField
    @NotNull
    private URI hostPort;
    @JsonProperty(value="supportsMetadataExtraction")
    @JsonPropertyDescription(value="Supports Metadata Extraction.")
    private Boolean supportsMetadataExtraction = true;

    @JsonProperty(value="type")
    public QlikCloudType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(QlikCloudType type) {
        this.type = type;
    }

    public QlikCloudConnection withType(QlikCloudType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="token")
    @PasswordField
    public String getToken() {
        return this.token;
    }

    @JsonProperty(value="token")
    @PasswordField
    public void setToken(String token) {
        this.token = token;
    }

    public QlikCloudConnection withToken(String token) {
        this.token = token;
        return this;
    }

    @JsonProperty(value="hostPort")
    @ExposedField
    public URI getHostPort() {
        return this.hostPort;
    }

    @JsonProperty(value="hostPort")
    @ExposedField
    public void setHostPort(URI hostPort) {
        this.hostPort = hostPort;
    }

    public QlikCloudConnection withHostPort(URI hostPort) {
        this.hostPort = hostPort;
        return this;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public Boolean getSupportsMetadataExtraction() {
        return this.supportsMetadataExtraction;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public void setSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
    }

    public QlikCloudConnection withSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(QlikCloudConnection.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("token");
        sb.append('=');
        sb.append(this.token == null ? "<null>" : this.token);
        sb.append(',');
        sb.append("hostPort");
        sb.append('=');
        sb.append(this.hostPort == null ? "<null>" : this.hostPort);
        sb.append(',');
        sb.append("supportsMetadataExtraction");
        sb.append('=');
        sb.append(this.supportsMetadataExtraction == null ? "<null>" : this.supportsMetadataExtraction);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.supportsMetadataExtraction == null ? 0 : this.supportsMetadataExtraction.hashCode());
        result = result * 31 + (this.hostPort == null ? 0 : this.hostPort.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.token == null ? 0 : this.token.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof QlikCloudConnection)) {
            return false;
        }
        QlikCloudConnection rhs = (QlikCloudConnection)other;
        return (this.supportsMetadataExtraction == rhs.supportsMetadataExtraction || this.supportsMetadataExtraction != null && this.supportsMetadataExtraction.equals(rhs.supportsMetadataExtraction)) && (this.hostPort == rhs.hostPort || this.hostPort != null && this.hostPort.equals(rhs.hostPort)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.token == rhs.token || this.token != null && this.token.equals(rhs.token));
    }

    public static enum QlikCloudType {
        QLIK_CLOUD("QlikCloud");

        private final String value;
        private static final Map<String, QlikCloudType> CONSTANTS;

        private QlikCloudType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static QlikCloudType fromValue(String value) {
            QlikCloudType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, QlikCloudType>();
            for (QlikCloudType c : QlikCloudType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

