/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.services.connections.dashboard;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.openmetadata.annotations.ExposedField;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "displayUrl", "hostPort", "certificates", "validateHostName", "userDirectory", "userId", "supportsMetadataExtraction"})
public class QlikSenseConnection {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Qlik sense service type")
    private QlikSenseType type = QlikSenseType.fromValue("QlikSense");
    @JsonProperty(value="displayUrl")
    @JsonPropertyDescription(value="Qlik Sense Base URL, used for genrating dashboard & chat url")
    @ExposedField
    private URI displayUrl;
    @JsonProperty(value="hostPort")
    @JsonPropertyDescription(value="URL for the Qlik instance.")
    @ExposedField
    @NotNull
    private URI hostPort;
    @JsonProperty(value="certificates")
    @NotNull
    private Object certificates;
    @JsonProperty(value="validateHostName")
    @JsonPropertyDescription(value="Validate Host Name")
    private Boolean validateHostName = false;
    @JsonProperty(value="userDirectory")
    @JsonPropertyDescription(value="User Directory.")
    private String userDirectory;
    @JsonProperty(value="userId")
    @JsonPropertyDescription(value="User ID.")
    private String userId;
    @JsonProperty(value="supportsMetadataExtraction")
    @JsonPropertyDescription(value="Supports Metadata Extraction.")
    private Boolean supportsMetadataExtraction = true;

    @JsonProperty(value="type")
    public QlikSenseType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(QlikSenseType type) {
        this.type = type;
    }

    public QlikSenseConnection withType(QlikSenseType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="displayUrl")
    @ExposedField
    public URI getDisplayUrl() {
        return this.displayUrl;
    }

    @JsonProperty(value="displayUrl")
    @ExposedField
    public void setDisplayUrl(URI displayUrl) {
        this.displayUrl = displayUrl;
    }

    public QlikSenseConnection withDisplayUrl(URI displayUrl) {
        this.displayUrl = displayUrl;
        return this;
    }

    @JsonProperty(value="hostPort")
    @ExposedField
    public URI getHostPort() {
        return this.hostPort;
    }

    @JsonProperty(value="hostPort")
    @ExposedField
    public void setHostPort(URI hostPort) {
        this.hostPort = hostPort;
    }

    public QlikSenseConnection withHostPort(URI hostPort) {
        this.hostPort = hostPort;
        return this;
    }

    @JsonProperty(value="certificates")
    public Object getCertificates() {
        return this.certificates;
    }

    @JsonProperty(value="certificates")
    public void setCertificates(Object certificates) {
        this.certificates = certificates;
    }

    public QlikSenseConnection withCertificates(Object certificates) {
        this.certificates = certificates;
        return this;
    }

    @JsonProperty(value="validateHostName")
    public Boolean getValidateHostName() {
        return this.validateHostName;
    }

    @JsonProperty(value="validateHostName")
    public void setValidateHostName(Boolean validateHostName) {
        this.validateHostName = validateHostName;
    }

    public QlikSenseConnection withValidateHostName(Boolean validateHostName) {
        this.validateHostName = validateHostName;
        return this;
    }

    @JsonProperty(value="userDirectory")
    public String getUserDirectory() {
        return this.userDirectory;
    }

    @JsonProperty(value="userDirectory")
    public void setUserDirectory(String userDirectory) {
        this.userDirectory = userDirectory;
    }

    public QlikSenseConnection withUserDirectory(String userDirectory) {
        this.userDirectory = userDirectory;
        return this;
    }

    @JsonProperty(value="userId")
    public String getUserId() {
        return this.userId;
    }

    @JsonProperty(value="userId")
    public void setUserId(String userId) {
        this.userId = userId;
    }

    public QlikSenseConnection withUserId(String userId) {
        this.userId = userId;
        return this;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public Boolean getSupportsMetadataExtraction() {
        return this.supportsMetadataExtraction;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public void setSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
    }

    public QlikSenseConnection withSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(QlikSenseConnection.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("displayUrl");
        sb.append('=');
        sb.append(this.displayUrl == null ? "<null>" : this.displayUrl);
        sb.append(',');
        sb.append("hostPort");
        sb.append('=');
        sb.append(this.hostPort == null ? "<null>" : this.hostPort);
        sb.append(',');
        sb.append("certificates");
        sb.append('=');
        sb.append(this.certificates == null ? "<null>" : this.certificates);
        sb.append(',');
        sb.append("validateHostName");
        sb.append('=');
        sb.append(this.validateHostName == null ? "<null>" : this.validateHostName);
        sb.append(',');
        sb.append("userDirectory");
        sb.append('=');
        sb.append(this.userDirectory == null ? "<null>" : this.userDirectory);
        sb.append(',');
        sb.append("userId");
        sb.append('=');
        sb.append(this.userId == null ? "<null>" : this.userId);
        sb.append(',');
        sb.append("supportsMetadataExtraction");
        sb.append('=');
        sb.append(this.supportsMetadataExtraction == null ? "<null>" : this.supportsMetadataExtraction);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.displayUrl == null ? 0 : this.displayUrl.hashCode());
        result = result * 31 + (this.supportsMetadataExtraction == null ? 0 : this.supportsMetadataExtraction.hashCode());
        result = result * 31 + (this.userDirectory == null ? 0 : this.userDirectory.hashCode());
        result = result * 31 + (this.certificates == null ? 0 : this.certificates.hashCode());
        result = result * 31 + (this.validateHostName == null ? 0 : this.validateHostName.hashCode());
        result = result * 31 + (this.hostPort == null ? 0 : this.hostPort.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.userId == null ? 0 : this.userId.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof QlikSenseConnection)) {
            return false;
        }
        QlikSenseConnection rhs = (QlikSenseConnection)other;
        return (this.displayUrl == rhs.displayUrl || this.displayUrl != null && this.displayUrl.equals(rhs.displayUrl)) && (this.supportsMetadataExtraction == rhs.supportsMetadataExtraction || this.supportsMetadataExtraction != null && this.supportsMetadataExtraction.equals(rhs.supportsMetadataExtraction)) && (this.userDirectory == rhs.userDirectory || this.userDirectory != null && this.userDirectory.equals(rhs.userDirectory)) && (this.certificates == rhs.certificates || this.certificates != null && this.certificates.equals(rhs.certificates)) && (this.validateHostName == rhs.validateHostName || this.validateHostName != null && this.validateHostName.equals(rhs.validateHostName)) && (this.hostPort == rhs.hostPort || this.hostPort != null && this.hostPort.equals(rhs.hostPort)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.userId == rhs.userId || this.userId != null && this.userId.equals(rhs.userId));
    }

    public static enum QlikSenseType {
        QLIK_SENSE("QlikSense");

        private final String value;
        private static final Map<String, QlikSenseType> CONSTANTS;

        private QlikSenseType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static QlikSenseType fromValue(String value) {
            QlikSenseType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, QlikSenseType>();
            for (QlikSenseType c : QlikSenseType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

