/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.services.connections.dashboard.powerbi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.security.credentials.AWSCredentials;
import org.openmetadata.schema.services.connections.dashboard.powerbi.bucketDetails;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"pbitFileConfigType", "securityConfig", "prefixConfig", "pbitFilesExtractDir"})
public class S3Config {
    @JsonProperty(value="pbitFileConfigType")
    @JsonPropertyDescription(value="pbit File Configuration type")
    private PbitFileConfigType pbitFileConfigType = PbitFileConfigType.fromValue("s3");
    @JsonProperty(value="securityConfig")
    @JsonPropertyDescription(value="AWS credentials configs.")
    @Valid
    @NotNull
    private AWSCredentials securityConfig;
    @JsonProperty(value="prefixConfig")
    @JsonPropertyDescription(value="Details of the bucket where the .pbit files are stored")
    @Valid
    private bucketDetails prefixConfig;
    @JsonProperty(value="pbitFilesExtractDir")
    @JsonPropertyDescription(value="Path of the folder where the .pbit files will be unzipped and datamodel schema will be extracted")
    private String pbitFilesExtractDir = "/tmp/pbitFiles";

    @JsonProperty(value="pbitFileConfigType")
    public PbitFileConfigType getPbitFileConfigType() {
        return this.pbitFileConfigType;
    }

    @JsonProperty(value="pbitFileConfigType")
    public void setPbitFileConfigType(PbitFileConfigType pbitFileConfigType) {
        this.pbitFileConfigType = pbitFileConfigType;
    }

    public S3Config withPbitFileConfigType(PbitFileConfigType pbitFileConfigType) {
        this.pbitFileConfigType = pbitFileConfigType;
        return this;
    }

    @JsonProperty(value="securityConfig")
    public AWSCredentials getSecurityConfig() {
        return this.securityConfig;
    }

    @JsonProperty(value="securityConfig")
    public void setSecurityConfig(AWSCredentials securityConfig) {
        this.securityConfig = securityConfig;
    }

    public S3Config withSecurityConfig(AWSCredentials securityConfig) {
        this.securityConfig = securityConfig;
        return this;
    }

    @JsonProperty(value="prefixConfig")
    public bucketDetails getPrefixConfig() {
        return this.prefixConfig;
    }

    @JsonProperty(value="prefixConfig")
    public void setPrefixConfig(bucketDetails prefixConfig) {
        this.prefixConfig = prefixConfig;
    }

    public S3Config withPrefixConfig(bucketDetails prefixConfig) {
        this.prefixConfig = prefixConfig;
        return this;
    }

    @JsonProperty(value="pbitFilesExtractDir")
    public String getPbitFilesExtractDir() {
        return this.pbitFilesExtractDir;
    }

    @JsonProperty(value="pbitFilesExtractDir")
    public void setPbitFilesExtractDir(String pbitFilesExtractDir) {
        this.pbitFilesExtractDir = pbitFilesExtractDir;
    }

    public S3Config withPbitFilesExtractDir(String pbitFilesExtractDir) {
        this.pbitFilesExtractDir = pbitFilesExtractDir;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(S3Config.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("pbitFileConfigType");
        sb.append('=');
        sb.append(this.pbitFileConfigType == null ? "<null>" : this.pbitFileConfigType);
        sb.append(',');
        sb.append("securityConfig");
        sb.append('=');
        sb.append(this.securityConfig == null ? "<null>" : this.securityConfig);
        sb.append(',');
        sb.append("prefixConfig");
        sb.append('=');
        sb.append(this.prefixConfig == null ? "<null>" : this.prefixConfig);
        sb.append(',');
        sb.append("pbitFilesExtractDir");
        sb.append('=');
        sb.append(this.pbitFilesExtractDir == null ? "<null>" : this.pbitFilesExtractDir);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.securityConfig == null ? 0 : this.securityConfig.hashCode());
        result = result * 31 + (this.pbitFilesExtractDir == null ? 0 : this.pbitFilesExtractDir.hashCode());
        result = result * 31 + (this.prefixConfig == null ? 0 : this.prefixConfig.hashCode());
        result = result * 31 + (this.pbitFileConfigType == null ? 0 : this.pbitFileConfigType.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof S3Config)) {
            return false;
        }
        S3Config rhs = (S3Config)other;
        return (this.securityConfig == rhs.securityConfig || this.securityConfig != null && this.securityConfig.equals(rhs.securityConfig)) && (this.pbitFilesExtractDir == rhs.pbitFilesExtractDir || this.pbitFilesExtractDir != null && this.pbitFilesExtractDir.equals(rhs.pbitFilesExtractDir)) && (this.prefixConfig == rhs.prefixConfig || this.prefixConfig != null && this.prefixConfig.equals(rhs.prefixConfig)) && (this.pbitFileConfigType == rhs.pbitFileConfigType || this.pbitFileConfigType != null && this.pbitFileConfigType.equals((Object)rhs.pbitFileConfigType));
    }

    public static enum PbitFileConfigType {
        S_3("s3");

        private final String value;
        private static final Map<String, PbitFileConfigType> CONSTANTS;

        private PbitFileConfigType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static PbitFileConfigType fromValue(String value) {
            PbitFileConfigType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, PbitFileConfigType>();
            for (PbitFileConfigType c : PbitFileConfigType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

