/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.services.connections.database;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.security.credentials.AWSCredentials;
import org.openmetadata.schema.services.connections.database.ConnectionArguments;
import org.openmetadata.schema.services.connections.database.ConnectionOptions;
import org.openmetadata.schema.services.connections.database.SampleDataStorageConfig;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "scheme", "awsConfig", "s3StagingDir", "workgroup", "databaseName", "connectionOptions", "connectionArguments", "supportsMetadataExtraction", "supportsDBTExtraction", "supportsProfiler", "supportsQueryComment", "supportsUsageExtraction", "supportsLineageExtraction", "sampleDataStorageConfig"})
public class AthenaConnection {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Service type.")
    private AthenaType type = AthenaType.fromValue("Athena");
    @JsonProperty(value="scheme")
    @JsonPropertyDescription(value="SQLAlchemy driver scheme options.")
    private AthenaScheme scheme = AthenaScheme.fromValue("awsathena+rest");
    @JsonProperty(value="awsConfig")
    @JsonPropertyDescription(value="AWS credentials configs.")
    @Valid
    @NotNull
    private AWSCredentials awsConfig;
    @JsonProperty(value="s3StagingDir")
    @JsonPropertyDescription(value="S3 Staging Directory. Example: s3://postgres/input/")
    @NotNull
    private URI s3StagingDir;
    @JsonProperty(value="workgroup")
    @JsonPropertyDescription(value="Athena workgroup.")
    @NotNull
    private String workgroup;
    @JsonProperty(value="databaseName")
    @JsonPropertyDescription(value="Optional name to give to the database in OpenMetadata. If left blank, we will use default as the database name.")
    private String databaseName;
    @JsonProperty(value="connectionOptions")
    @JsonPropertyDescription(value="Additional connection options to build the URL that can be sent to service during the connection.")
    @Valid
    private ConnectionOptions connectionOptions;
    @JsonProperty(value="connectionArguments")
    @JsonPropertyDescription(value="Additional connection arguments such as security or protocol configs that can be sent to service during connection.")
    @Valid
    private ConnectionArguments connectionArguments;
    @JsonProperty(value="supportsMetadataExtraction")
    @JsonPropertyDescription(value="Supports Metadata Extraction.")
    private Boolean supportsMetadataExtraction = true;
    @JsonProperty(value="supportsDBTExtraction")
    @JsonPropertyDescription(value="Supports DBT Extraction.")
    private Boolean supportsDBTExtraction = true;
    @JsonProperty(value="supportsProfiler")
    @JsonPropertyDescription(value="Supports Profiler")
    private Boolean supportsProfiler = true;
    @JsonProperty(value="supportsQueryComment")
    @JsonPropertyDescription(value="For Database Services using SQLAlchemy, True to enable running a comment for all queries run from OpenMetadata.")
    private Boolean supportsQueryComment = true;
    @JsonProperty(value="supportsUsageExtraction")
    @JsonPropertyDescription(value="Supports Usage Extraction.")
    private Boolean supportsUsageExtraction = true;
    @JsonProperty(value="supportsLineageExtraction")
    @JsonPropertyDescription(value="Supports Lineage Extraction.")
    private Boolean supportsLineageExtraction = true;
    @JsonProperty(value="sampleDataStorageConfig")
    @JsonPropertyDescription(value="Storage config to store sample data")
    @Valid
    private SampleDataStorageConfig sampleDataStorageConfig;

    @JsonProperty(value="type")
    public AthenaType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(AthenaType type) {
        this.type = type;
    }

    public AthenaConnection withType(AthenaType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="scheme")
    public AthenaScheme getScheme() {
        return this.scheme;
    }

    @JsonProperty(value="scheme")
    public void setScheme(AthenaScheme scheme) {
        this.scheme = scheme;
    }

    public AthenaConnection withScheme(AthenaScheme scheme) {
        this.scheme = scheme;
        return this;
    }

    @JsonProperty(value="awsConfig")
    public AWSCredentials getAwsConfig() {
        return this.awsConfig;
    }

    @JsonProperty(value="awsConfig")
    public void setAwsConfig(AWSCredentials awsConfig) {
        this.awsConfig = awsConfig;
    }

    public AthenaConnection withAwsConfig(AWSCredentials awsConfig) {
        this.awsConfig = awsConfig;
        return this;
    }

    @JsonProperty(value="s3StagingDir")
    public URI getS3StagingDir() {
        return this.s3StagingDir;
    }

    @JsonProperty(value="s3StagingDir")
    public void setS3StagingDir(URI s3StagingDir) {
        this.s3StagingDir = s3StagingDir;
    }

    public AthenaConnection withS3StagingDir(URI s3StagingDir) {
        this.s3StagingDir = s3StagingDir;
        return this;
    }

    @JsonProperty(value="workgroup")
    public String getWorkgroup() {
        return this.workgroup;
    }

    @JsonProperty(value="workgroup")
    public void setWorkgroup(String workgroup) {
        this.workgroup = workgroup;
    }

    public AthenaConnection withWorkgroup(String workgroup) {
        this.workgroup = workgroup;
        return this;
    }

    @JsonProperty(value="databaseName")
    public String getDatabaseName() {
        return this.databaseName;
    }

    @JsonProperty(value="databaseName")
    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public AthenaConnection withDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    @JsonProperty(value="connectionOptions")
    public ConnectionOptions getConnectionOptions() {
        return this.connectionOptions;
    }

    @JsonProperty(value="connectionOptions")
    public void setConnectionOptions(ConnectionOptions connectionOptions) {
        this.connectionOptions = connectionOptions;
    }

    public AthenaConnection withConnectionOptions(ConnectionOptions connectionOptions) {
        this.connectionOptions = connectionOptions;
        return this;
    }

    @JsonProperty(value="connectionArguments")
    public ConnectionArguments getConnectionArguments() {
        return this.connectionArguments;
    }

    @JsonProperty(value="connectionArguments")
    public void setConnectionArguments(ConnectionArguments connectionArguments) {
        this.connectionArguments = connectionArguments;
    }

    public AthenaConnection withConnectionArguments(ConnectionArguments connectionArguments) {
        this.connectionArguments = connectionArguments;
        return this;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public Boolean getSupportsMetadataExtraction() {
        return this.supportsMetadataExtraction;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public void setSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
    }

    public AthenaConnection withSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
        return this;
    }

    @JsonProperty(value="supportsDBTExtraction")
    public Boolean getSupportsDBTExtraction() {
        return this.supportsDBTExtraction;
    }

    @JsonProperty(value="supportsDBTExtraction")
    public void setSupportsDBTExtraction(Boolean supportsDBTExtraction) {
        this.supportsDBTExtraction = supportsDBTExtraction;
    }

    public AthenaConnection withSupportsDBTExtraction(Boolean supportsDBTExtraction) {
        this.supportsDBTExtraction = supportsDBTExtraction;
        return this;
    }

    @JsonProperty(value="supportsProfiler")
    public Boolean getSupportsProfiler() {
        return this.supportsProfiler;
    }

    @JsonProperty(value="supportsProfiler")
    public void setSupportsProfiler(Boolean supportsProfiler) {
        this.supportsProfiler = supportsProfiler;
    }

    public AthenaConnection withSupportsProfiler(Boolean supportsProfiler) {
        this.supportsProfiler = supportsProfiler;
        return this;
    }

    @JsonProperty(value="supportsQueryComment")
    public Boolean getSupportsQueryComment() {
        return this.supportsQueryComment;
    }

    @JsonProperty(value="supportsQueryComment")
    public void setSupportsQueryComment(Boolean supportsQueryComment) {
        this.supportsQueryComment = supportsQueryComment;
    }

    public AthenaConnection withSupportsQueryComment(Boolean supportsQueryComment) {
        this.supportsQueryComment = supportsQueryComment;
        return this;
    }

    @JsonProperty(value="supportsUsageExtraction")
    public Boolean getSupportsUsageExtraction() {
        return this.supportsUsageExtraction;
    }

    @JsonProperty(value="supportsUsageExtraction")
    public void setSupportsUsageExtraction(Boolean supportsUsageExtraction) {
        this.supportsUsageExtraction = supportsUsageExtraction;
    }

    public AthenaConnection withSupportsUsageExtraction(Boolean supportsUsageExtraction) {
        this.supportsUsageExtraction = supportsUsageExtraction;
        return this;
    }

    @JsonProperty(value="supportsLineageExtraction")
    public Boolean getSupportsLineageExtraction() {
        return this.supportsLineageExtraction;
    }

    @JsonProperty(value="supportsLineageExtraction")
    public void setSupportsLineageExtraction(Boolean supportsLineageExtraction) {
        this.supportsLineageExtraction = supportsLineageExtraction;
    }

    public AthenaConnection withSupportsLineageExtraction(Boolean supportsLineageExtraction) {
        this.supportsLineageExtraction = supportsLineageExtraction;
        return this;
    }

    @JsonProperty(value="sampleDataStorageConfig")
    public SampleDataStorageConfig getSampleDataStorageConfig() {
        return this.sampleDataStorageConfig;
    }

    @JsonProperty(value="sampleDataStorageConfig")
    public void setSampleDataStorageConfig(SampleDataStorageConfig sampleDataStorageConfig) {
        this.sampleDataStorageConfig = sampleDataStorageConfig;
    }

    public AthenaConnection withSampleDataStorageConfig(SampleDataStorageConfig sampleDataStorageConfig) {
        this.sampleDataStorageConfig = sampleDataStorageConfig;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(AthenaConnection.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("scheme");
        sb.append('=');
        sb.append(this.scheme == null ? "<null>" : this.scheme);
        sb.append(',');
        sb.append("awsConfig");
        sb.append('=');
        sb.append(this.awsConfig == null ? "<null>" : this.awsConfig);
        sb.append(',');
        sb.append("s3StagingDir");
        sb.append('=');
        sb.append(this.s3StagingDir == null ? "<null>" : this.s3StagingDir);
        sb.append(',');
        sb.append("workgroup");
        sb.append('=');
        sb.append(this.workgroup == null ? "<null>" : this.workgroup);
        sb.append(',');
        sb.append("databaseName");
        sb.append('=');
        sb.append(this.databaseName == null ? "<null>" : this.databaseName);
        sb.append(',');
        sb.append("connectionOptions");
        sb.append('=');
        sb.append(this.connectionOptions == null ? "<null>" : this.connectionOptions);
        sb.append(',');
        sb.append("connectionArguments");
        sb.append('=');
        sb.append(this.connectionArguments == null ? "<null>" : this.connectionArguments);
        sb.append(',');
        sb.append("supportsMetadataExtraction");
        sb.append('=');
        sb.append(this.supportsMetadataExtraction == null ? "<null>" : this.supportsMetadataExtraction);
        sb.append(',');
        sb.append("supportsDBTExtraction");
        sb.append('=');
        sb.append(this.supportsDBTExtraction == null ? "<null>" : this.supportsDBTExtraction);
        sb.append(',');
        sb.append("supportsProfiler");
        sb.append('=');
        sb.append(this.supportsProfiler == null ? "<null>" : this.supportsProfiler);
        sb.append(',');
        sb.append("supportsQueryComment");
        sb.append('=');
        sb.append(this.supportsQueryComment == null ? "<null>" : this.supportsQueryComment);
        sb.append(',');
        sb.append("supportsUsageExtraction");
        sb.append('=');
        sb.append(this.supportsUsageExtraction == null ? "<null>" : this.supportsUsageExtraction);
        sb.append(',');
        sb.append("supportsLineageExtraction");
        sb.append('=');
        sb.append(this.supportsLineageExtraction == null ? "<null>" : this.supportsLineageExtraction);
        sb.append(',');
        sb.append("sampleDataStorageConfig");
        sb.append('=');
        sb.append(this.sampleDataStorageConfig == null ? "<null>" : this.sampleDataStorageConfig);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.workgroup == null ? 0 : this.workgroup.hashCode());
        result = result * 31 + (this.supportsMetadataExtraction == null ? 0 : this.supportsMetadataExtraction.hashCode());
        result = result * 31 + (this.scheme == null ? 0 : this.scheme.hashCode());
        result = result * 31 + (this.databaseName == null ? 0 : this.databaseName.hashCode());
        result = result * 31 + (this.supportsProfiler == null ? 0 : this.supportsProfiler.hashCode());
        result = result * 31 + (this.sampleDataStorageConfig == null ? 0 : this.sampleDataStorageConfig.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.supportsUsageExtraction == null ? 0 : this.supportsUsageExtraction.hashCode());
        result = result * 31 + (this.supportsDBTExtraction == null ? 0 : this.supportsDBTExtraction.hashCode());
        result = result * 31 + (this.connectionArguments == null ? 0 : this.connectionArguments.hashCode());
        result = result * 31 + (this.supportsLineageExtraction == null ? 0 : this.supportsLineageExtraction.hashCode());
        result = result * 31 + (this.awsConfig == null ? 0 : this.awsConfig.hashCode());
        result = result * 31 + (this.connectionOptions == null ? 0 : this.connectionOptions.hashCode());
        result = result * 31 + (this.supportsQueryComment == null ? 0 : this.supportsQueryComment.hashCode());
        result = result * 31 + (this.s3StagingDir == null ? 0 : this.s3StagingDir.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof AthenaConnection)) {
            return false;
        }
        AthenaConnection rhs = (AthenaConnection)other;
        return (this.workgroup == rhs.workgroup || this.workgroup != null && this.workgroup.equals(rhs.workgroup)) && (this.supportsMetadataExtraction == rhs.supportsMetadataExtraction || this.supportsMetadataExtraction != null && this.supportsMetadataExtraction.equals(rhs.supportsMetadataExtraction)) && (this.scheme == rhs.scheme || this.scheme != null && this.scheme.equals((Object)rhs.scheme)) && (this.databaseName == rhs.databaseName || this.databaseName != null && this.databaseName.equals(rhs.databaseName)) && (this.supportsProfiler == rhs.supportsProfiler || this.supportsProfiler != null && this.supportsProfiler.equals(rhs.supportsProfiler)) && (this.sampleDataStorageConfig == rhs.sampleDataStorageConfig || this.sampleDataStorageConfig != null && this.sampleDataStorageConfig.equals(rhs.sampleDataStorageConfig)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.supportsUsageExtraction == rhs.supportsUsageExtraction || this.supportsUsageExtraction != null && this.supportsUsageExtraction.equals(rhs.supportsUsageExtraction)) && (this.supportsDBTExtraction == rhs.supportsDBTExtraction || this.supportsDBTExtraction != null && this.supportsDBTExtraction.equals(rhs.supportsDBTExtraction)) && (this.connectionArguments == rhs.connectionArguments || this.connectionArguments != null && this.connectionArguments.equals(rhs.connectionArguments)) && (this.supportsLineageExtraction == rhs.supportsLineageExtraction || this.supportsLineageExtraction != null && this.supportsLineageExtraction.equals(rhs.supportsLineageExtraction)) && (this.awsConfig == rhs.awsConfig || this.awsConfig != null && this.awsConfig.equals(rhs.awsConfig)) && (this.connectionOptions == rhs.connectionOptions || this.connectionOptions != null && this.connectionOptions.equals(rhs.connectionOptions)) && (this.supportsQueryComment == rhs.supportsQueryComment || this.supportsQueryComment != null && this.supportsQueryComment.equals(rhs.supportsQueryComment)) && (this.s3StagingDir == rhs.s3StagingDir || this.s3StagingDir != null && this.s3StagingDir.equals(rhs.s3StagingDir));
    }

    public static enum AthenaType {
        ATHENA("Athena");

        private final String value;
        private static final Map<String, AthenaType> CONSTANTS;

        private AthenaType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static AthenaType fromValue(String value) {
            AthenaType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, AthenaType>();
            for (AthenaType c : AthenaType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum AthenaScheme {
        AWSATHENA_REST("awsathena+rest");

        private final String value;
        private static final Map<String, AthenaScheme> CONSTANTS;

        private AthenaScheme(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static AthenaScheme fromValue(String value) {
            AthenaScheme constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, AthenaScheme>();
            for (AthenaScheme c : AthenaScheme.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

