/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.services.connections.database;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.validation.Valid;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"authentication", "encrypt", "trustServerCertificate", "connectionTimeout"})
public class AuthenticationMode {
    @JsonProperty(value="authentication")
    @JsonPropertyDescription(value="Authentication from Connection String for AzureSQL.")
    private Authentication authentication;
    @JsonProperty(value="encrypt")
    @JsonPropertyDescription(value="Encrypt from Connection String for AzureSQL.")
    private Boolean encrypt;
    @JsonProperty(value="trustServerCertificate")
    @JsonPropertyDescription(value="Trust Server Certificate from Connection String for AzureSQL.")
    private Boolean trustServerCertificate;
    @JsonProperty(value="connectionTimeout")
    @JsonPropertyDescription(value="Connection Timeout from Connection String for AzureSQL.")
    private Integer connectionTimeout = 30;
    @JsonIgnore
    @Valid
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    @JsonProperty(value="authentication")
    public Authentication getAuthentication() {
        return this.authentication;
    }

    @JsonProperty(value="authentication")
    public void setAuthentication(Authentication authentication) {
        this.authentication = authentication;
    }

    public AuthenticationMode withAuthentication(Authentication authentication) {
        this.authentication = authentication;
        return this;
    }

    @JsonProperty(value="encrypt")
    public Boolean getEncrypt() {
        return this.encrypt;
    }

    @JsonProperty(value="encrypt")
    public void setEncrypt(Boolean encrypt) {
        this.encrypt = encrypt;
    }

    public AuthenticationMode withEncrypt(Boolean encrypt) {
        this.encrypt = encrypt;
        return this;
    }

    @JsonProperty(value="trustServerCertificate")
    public Boolean getTrustServerCertificate() {
        return this.trustServerCertificate;
    }

    @JsonProperty(value="trustServerCertificate")
    public void setTrustServerCertificate(Boolean trustServerCertificate) {
        this.trustServerCertificate = trustServerCertificate;
    }

    public AuthenticationMode withTrustServerCertificate(Boolean trustServerCertificate) {
        this.trustServerCertificate = trustServerCertificate;
        return this;
    }

    @JsonProperty(value="connectionTimeout")
    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @JsonProperty(value="connectionTimeout")
    public void setConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public AuthenticationMode withConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public AuthenticationMode withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(AuthenticationMode.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("authentication");
        sb.append('=');
        sb.append(this.authentication == null ? "<null>" : this.authentication);
        sb.append(',');
        sb.append("encrypt");
        sb.append('=');
        sb.append(this.encrypt == null ? "<null>" : this.encrypt);
        sb.append(',');
        sb.append("trustServerCertificate");
        sb.append('=');
        sb.append(this.trustServerCertificate == null ? "<null>" : this.trustServerCertificate);
        sb.append(',');
        sb.append("connectionTimeout");
        sb.append('=');
        sb.append(this.connectionTimeout == null ? "<null>" : this.connectionTimeout);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.trustServerCertificate == null ? 0 : this.trustServerCertificate.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.connectionTimeout == null ? 0 : this.connectionTimeout.hashCode());
        result = result * 31 + (this.encrypt == null ? 0 : this.encrypt.hashCode());
        result = result * 31 + (this.authentication == null ? 0 : this.authentication.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof AuthenticationMode)) {
            return false;
        }
        AuthenticationMode rhs = (AuthenticationMode)other;
        return (this.trustServerCertificate == rhs.trustServerCertificate || this.trustServerCertificate != null && this.trustServerCertificate.equals(rhs.trustServerCertificate)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.connectionTimeout == rhs.connectionTimeout || this.connectionTimeout != null && this.connectionTimeout.equals(rhs.connectionTimeout)) && (this.encrypt == rhs.encrypt || this.encrypt != null && this.encrypt.equals(rhs.encrypt)) && (this.authentication == rhs.authentication || this.authentication != null && this.authentication.equals((Object)rhs.authentication));
    }

    public static enum Authentication {
        ACTIVE_DIRECTORY_INTEGRATED("ActiveDirectoryIntegrated"),
        ACTIVE_DIRECTORY_PASSWORD("ActiveDirectoryPassword");

        private final String value;
        private static final Map<String, Authentication> CONSTANTS;

        private Authentication(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Authentication fromValue(String value) {
            Authentication constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Authentication>();
            for (Authentication c : Authentication.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

