/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.services.connections.database;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.security.credentials.GCPCredentials;
import org.openmetadata.schema.services.connections.database.ConnectionArguments;
import org.openmetadata.schema.services.connections.database.ConnectionOptions;
import org.openmetadata.schema.services.connections.database.SampleDataStorageConfig;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "scheme", "hostPort", "credentials", "taxonomyProjectID", "taxonomyLocation", "usageLocation", "connectionOptions", "connectionArguments", "supportsMetadataExtraction", "supportsUsageExtraction", "supportsLineageExtraction", "supportsDBTExtraction", "supportsProfiler", "supportsDatabase", "supportsQueryComment", "sampleDataStorageConfig"})
public class BigQueryConnection {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Service type.")
    private BigqueryType type = BigqueryType.fromValue("BigQuery");
    @JsonProperty(value="scheme")
    @JsonPropertyDescription(value="SQLAlchemy driver scheme options.")
    private BigqueryScheme scheme = BigqueryScheme.fromValue("bigquery");
    @JsonProperty(value="hostPort")
    @JsonPropertyDescription(value="BigQuery APIs URL.")
    private String hostPort = "bigquery.googleapis.com";
    @JsonProperty(value="credentials")
    @JsonPropertyDescription(value="GCP credentials configs.")
    @Valid
    @NotNull
    private GCPCredentials credentials;
    @JsonProperty(value="taxonomyProjectID")
    @JsonPropertyDescription(value="Project IDs used to fetch policy tags")
    @Valid
    private List<String> taxonomyProjectID = null;
    @JsonProperty(value="taxonomyLocation")
    @JsonPropertyDescription(value="Taxonomy location used to fetch policy tags")
    private String taxonomyLocation = "us";
    @JsonProperty(value="usageLocation")
    @JsonPropertyDescription(value="Location used to query INFORMATION_SCHEMA.JOBS_BY_PROJECT to fetch usage data. You can pass multi-regions, such as `us` or `eu`, or you specific region. Australia and Asia multi-regions are not yet in GA.")
    private String usageLocation = "us";
    @JsonProperty(value="connectionOptions")
    @JsonPropertyDescription(value="Additional connection options to build the URL that can be sent to service during the connection.")
    @Valid
    private ConnectionOptions connectionOptions;
    @JsonProperty(value="connectionArguments")
    @JsonPropertyDescription(value="Additional connection arguments such as security or protocol configs that can be sent to service during connection.")
    @Valid
    private ConnectionArguments connectionArguments;
    @JsonProperty(value="supportsMetadataExtraction")
    @JsonPropertyDescription(value="Supports Metadata Extraction.")
    private Boolean supportsMetadataExtraction = true;
    @JsonProperty(value="supportsUsageExtraction")
    @JsonPropertyDescription(value="Supports Usage Extraction.")
    private Boolean supportsUsageExtraction = true;
    @JsonProperty(value="supportsLineageExtraction")
    @JsonPropertyDescription(value="Supports Lineage Extraction.")
    private Boolean supportsLineageExtraction = true;
    @JsonProperty(value="supportsDBTExtraction")
    @JsonPropertyDescription(value="Supports DBT Extraction.")
    private Boolean supportsDBTExtraction = true;
    @JsonProperty(value="supportsProfiler")
    @JsonPropertyDescription(value="Supports Profiler")
    private Boolean supportsProfiler = true;
    @JsonProperty(value="supportsDatabase")
    @JsonPropertyDescription(value="The source service supports the database concept in its hierarchy")
    private Boolean supportsDatabase = true;
    @JsonProperty(value="supportsQueryComment")
    @JsonPropertyDescription(value="For Database Services using SQLAlchemy, True to enable running a comment for all queries run from OpenMetadata.")
    private Boolean supportsQueryComment = true;
    @JsonProperty(value="sampleDataStorageConfig")
    @JsonPropertyDescription(value="Storage config to store sample data")
    @Valid
    private SampleDataStorageConfig sampleDataStorageConfig;

    @JsonProperty(value="type")
    public BigqueryType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(BigqueryType type) {
        this.type = type;
    }

    public BigQueryConnection withType(BigqueryType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="scheme")
    public BigqueryScheme getScheme() {
        return this.scheme;
    }

    @JsonProperty(value="scheme")
    public void setScheme(BigqueryScheme scheme) {
        this.scheme = scheme;
    }

    public BigQueryConnection withScheme(BigqueryScheme scheme) {
        this.scheme = scheme;
        return this;
    }

    @JsonProperty(value="hostPort")
    public String getHostPort() {
        return this.hostPort;
    }

    @JsonProperty(value="hostPort")
    public void setHostPort(String hostPort) {
        this.hostPort = hostPort;
    }

    public BigQueryConnection withHostPort(String hostPort) {
        this.hostPort = hostPort;
        return this;
    }

    @JsonProperty(value="credentials")
    public GCPCredentials getCredentials() {
        return this.credentials;
    }

    @JsonProperty(value="credentials")
    public void setCredentials(GCPCredentials credentials) {
        this.credentials = credentials;
    }

    public BigQueryConnection withCredentials(GCPCredentials credentials) {
        this.credentials = credentials;
        return this;
    }

    @JsonProperty(value="taxonomyProjectID")
    public List<String> getTaxonomyProjectID() {
        return this.taxonomyProjectID;
    }

    @JsonProperty(value="taxonomyProjectID")
    public void setTaxonomyProjectID(List<String> taxonomyProjectID) {
        this.taxonomyProjectID = taxonomyProjectID;
    }

    public BigQueryConnection withTaxonomyProjectID(List<String> taxonomyProjectID) {
        this.taxonomyProjectID = taxonomyProjectID;
        return this;
    }

    @JsonProperty(value="taxonomyLocation")
    public String getTaxonomyLocation() {
        return this.taxonomyLocation;
    }

    @JsonProperty(value="taxonomyLocation")
    public void setTaxonomyLocation(String taxonomyLocation) {
        this.taxonomyLocation = taxonomyLocation;
    }

    public BigQueryConnection withTaxonomyLocation(String taxonomyLocation) {
        this.taxonomyLocation = taxonomyLocation;
        return this;
    }

    @JsonProperty(value="usageLocation")
    public String getUsageLocation() {
        return this.usageLocation;
    }

    @JsonProperty(value="usageLocation")
    public void setUsageLocation(String usageLocation) {
        this.usageLocation = usageLocation;
    }

    public BigQueryConnection withUsageLocation(String usageLocation) {
        this.usageLocation = usageLocation;
        return this;
    }

    @JsonProperty(value="connectionOptions")
    public ConnectionOptions getConnectionOptions() {
        return this.connectionOptions;
    }

    @JsonProperty(value="connectionOptions")
    public void setConnectionOptions(ConnectionOptions connectionOptions) {
        this.connectionOptions = connectionOptions;
    }

    public BigQueryConnection withConnectionOptions(ConnectionOptions connectionOptions) {
        this.connectionOptions = connectionOptions;
        return this;
    }

    @JsonProperty(value="connectionArguments")
    public ConnectionArguments getConnectionArguments() {
        return this.connectionArguments;
    }

    @JsonProperty(value="connectionArguments")
    public void setConnectionArguments(ConnectionArguments connectionArguments) {
        this.connectionArguments = connectionArguments;
    }

    public BigQueryConnection withConnectionArguments(ConnectionArguments connectionArguments) {
        this.connectionArguments = connectionArguments;
        return this;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public Boolean getSupportsMetadataExtraction() {
        return this.supportsMetadataExtraction;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public void setSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
    }

    public BigQueryConnection withSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
        return this;
    }

    @JsonProperty(value="supportsUsageExtraction")
    public Boolean getSupportsUsageExtraction() {
        return this.supportsUsageExtraction;
    }

    @JsonProperty(value="supportsUsageExtraction")
    public void setSupportsUsageExtraction(Boolean supportsUsageExtraction) {
        this.supportsUsageExtraction = supportsUsageExtraction;
    }

    public BigQueryConnection withSupportsUsageExtraction(Boolean supportsUsageExtraction) {
        this.supportsUsageExtraction = supportsUsageExtraction;
        return this;
    }

    @JsonProperty(value="supportsLineageExtraction")
    public Boolean getSupportsLineageExtraction() {
        return this.supportsLineageExtraction;
    }

    @JsonProperty(value="supportsLineageExtraction")
    public void setSupportsLineageExtraction(Boolean supportsLineageExtraction) {
        this.supportsLineageExtraction = supportsLineageExtraction;
    }

    public BigQueryConnection withSupportsLineageExtraction(Boolean supportsLineageExtraction) {
        this.supportsLineageExtraction = supportsLineageExtraction;
        return this;
    }

    @JsonProperty(value="supportsDBTExtraction")
    public Boolean getSupportsDBTExtraction() {
        return this.supportsDBTExtraction;
    }

    @JsonProperty(value="supportsDBTExtraction")
    public void setSupportsDBTExtraction(Boolean supportsDBTExtraction) {
        this.supportsDBTExtraction = supportsDBTExtraction;
    }

    public BigQueryConnection withSupportsDBTExtraction(Boolean supportsDBTExtraction) {
        this.supportsDBTExtraction = supportsDBTExtraction;
        return this;
    }

    @JsonProperty(value="supportsProfiler")
    public Boolean getSupportsProfiler() {
        return this.supportsProfiler;
    }

    @JsonProperty(value="supportsProfiler")
    public void setSupportsProfiler(Boolean supportsProfiler) {
        this.supportsProfiler = supportsProfiler;
    }

    public BigQueryConnection withSupportsProfiler(Boolean supportsProfiler) {
        this.supportsProfiler = supportsProfiler;
        return this;
    }

    @JsonProperty(value="supportsDatabase")
    public Boolean getSupportsDatabase() {
        return this.supportsDatabase;
    }

    @JsonProperty(value="supportsDatabase")
    public void setSupportsDatabase(Boolean supportsDatabase) {
        this.supportsDatabase = supportsDatabase;
    }

    public BigQueryConnection withSupportsDatabase(Boolean supportsDatabase) {
        this.supportsDatabase = supportsDatabase;
        return this;
    }

    @JsonProperty(value="supportsQueryComment")
    public Boolean getSupportsQueryComment() {
        return this.supportsQueryComment;
    }

    @JsonProperty(value="supportsQueryComment")
    public void setSupportsQueryComment(Boolean supportsQueryComment) {
        this.supportsQueryComment = supportsQueryComment;
    }

    public BigQueryConnection withSupportsQueryComment(Boolean supportsQueryComment) {
        this.supportsQueryComment = supportsQueryComment;
        return this;
    }

    @JsonProperty(value="sampleDataStorageConfig")
    public SampleDataStorageConfig getSampleDataStorageConfig() {
        return this.sampleDataStorageConfig;
    }

    @JsonProperty(value="sampleDataStorageConfig")
    public void setSampleDataStorageConfig(SampleDataStorageConfig sampleDataStorageConfig) {
        this.sampleDataStorageConfig = sampleDataStorageConfig;
    }

    public BigQueryConnection withSampleDataStorageConfig(SampleDataStorageConfig sampleDataStorageConfig) {
        this.sampleDataStorageConfig = sampleDataStorageConfig;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(BigQueryConnection.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("scheme");
        sb.append('=');
        sb.append(this.scheme == null ? "<null>" : this.scheme);
        sb.append(',');
        sb.append("hostPort");
        sb.append('=');
        sb.append(this.hostPort == null ? "<null>" : this.hostPort);
        sb.append(',');
        sb.append("credentials");
        sb.append('=');
        sb.append(this.credentials == null ? "<null>" : this.credentials);
        sb.append(',');
        sb.append("taxonomyProjectID");
        sb.append('=');
        sb.append(this.taxonomyProjectID == null ? "<null>" : this.taxonomyProjectID);
        sb.append(',');
        sb.append("taxonomyLocation");
        sb.append('=');
        sb.append(this.taxonomyLocation == null ? "<null>" : this.taxonomyLocation);
        sb.append(',');
        sb.append("usageLocation");
        sb.append('=');
        sb.append(this.usageLocation == null ? "<null>" : this.usageLocation);
        sb.append(',');
        sb.append("connectionOptions");
        sb.append('=');
        sb.append(this.connectionOptions == null ? "<null>" : this.connectionOptions);
        sb.append(',');
        sb.append("connectionArguments");
        sb.append('=');
        sb.append(this.connectionArguments == null ? "<null>" : this.connectionArguments);
        sb.append(',');
        sb.append("supportsMetadataExtraction");
        sb.append('=');
        sb.append(this.supportsMetadataExtraction == null ? "<null>" : this.supportsMetadataExtraction);
        sb.append(',');
        sb.append("supportsUsageExtraction");
        sb.append('=');
        sb.append(this.supportsUsageExtraction == null ? "<null>" : this.supportsUsageExtraction);
        sb.append(',');
        sb.append("supportsLineageExtraction");
        sb.append('=');
        sb.append(this.supportsLineageExtraction == null ? "<null>" : this.supportsLineageExtraction);
        sb.append(',');
        sb.append("supportsDBTExtraction");
        sb.append('=');
        sb.append(this.supportsDBTExtraction == null ? "<null>" : this.supportsDBTExtraction);
        sb.append(',');
        sb.append("supportsProfiler");
        sb.append('=');
        sb.append(this.supportsProfiler == null ? "<null>" : this.supportsProfiler);
        sb.append(',');
        sb.append("supportsDatabase");
        sb.append('=');
        sb.append(this.supportsDatabase == null ? "<null>" : this.supportsDatabase);
        sb.append(',');
        sb.append("supportsQueryComment");
        sb.append('=');
        sb.append(this.supportsQueryComment == null ? "<null>" : this.supportsQueryComment);
        sb.append(',');
        sb.append("sampleDataStorageConfig");
        sb.append('=');
        sb.append(this.sampleDataStorageConfig == null ? "<null>" : this.sampleDataStorageConfig);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.supportsMetadataExtraction == null ? 0 : this.supportsMetadataExtraction.hashCode());
        result = result * 31 + (this.scheme == null ? 0 : this.scheme.hashCode());
        result = result * 31 + (this.supportsProfiler == null ? 0 : this.supportsProfiler.hashCode());
        result = result * 31 + (this.credentials == null ? 0 : this.credentials.hashCode());
        result = result * 31 + (this.sampleDataStorageConfig == null ? 0 : this.sampleDataStorageConfig.hashCode());
        result = result * 31 + (this.taxonomyProjectID == null ? 0 : this.taxonomyProjectID.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.supportsUsageExtraction == null ? 0 : this.supportsUsageExtraction.hashCode());
        result = result * 31 + (this.taxonomyLocation == null ? 0 : this.taxonomyLocation.hashCode());
        result = result * 31 + (this.supportsDBTExtraction == null ? 0 : this.supportsDBTExtraction.hashCode());
        result = result * 31 + (this.connectionArguments == null ? 0 : this.connectionArguments.hashCode());
        result = result * 31 + (this.supportsDatabase == null ? 0 : this.supportsDatabase.hashCode());
        result = result * 31 + (this.supportsLineageExtraction == null ? 0 : this.supportsLineageExtraction.hashCode());
        result = result * 31 + (this.connectionOptions == null ? 0 : this.connectionOptions.hashCode());
        result = result * 31 + (this.hostPort == null ? 0 : this.hostPort.hashCode());
        result = result * 31 + (this.usageLocation == null ? 0 : this.usageLocation.hashCode());
        result = result * 31 + (this.supportsQueryComment == null ? 0 : this.supportsQueryComment.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof BigQueryConnection)) {
            return false;
        }
        BigQueryConnection rhs = (BigQueryConnection)other;
        return (this.supportsMetadataExtraction == rhs.supportsMetadataExtraction || this.supportsMetadataExtraction != null && this.supportsMetadataExtraction.equals(rhs.supportsMetadataExtraction)) && (this.scheme == rhs.scheme || this.scheme != null && this.scheme.equals((Object)rhs.scheme)) && (this.supportsProfiler == rhs.supportsProfiler || this.supportsProfiler != null && this.supportsProfiler.equals(rhs.supportsProfiler)) && (this.credentials == rhs.credentials || this.credentials != null && this.credentials.equals(rhs.credentials)) && (this.sampleDataStorageConfig == rhs.sampleDataStorageConfig || this.sampleDataStorageConfig != null && this.sampleDataStorageConfig.equals(rhs.sampleDataStorageConfig)) && (this.taxonomyProjectID == rhs.taxonomyProjectID || this.taxonomyProjectID != null && this.taxonomyProjectID.equals(rhs.taxonomyProjectID)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.supportsUsageExtraction == rhs.supportsUsageExtraction || this.supportsUsageExtraction != null && this.supportsUsageExtraction.equals(rhs.supportsUsageExtraction)) && (this.taxonomyLocation == rhs.taxonomyLocation || this.taxonomyLocation != null && this.taxonomyLocation.equals(rhs.taxonomyLocation)) && (this.supportsDBTExtraction == rhs.supportsDBTExtraction || this.supportsDBTExtraction != null && this.supportsDBTExtraction.equals(rhs.supportsDBTExtraction)) && (this.connectionArguments == rhs.connectionArguments || this.connectionArguments != null && this.connectionArguments.equals(rhs.connectionArguments)) && (this.supportsDatabase == rhs.supportsDatabase || this.supportsDatabase != null && this.supportsDatabase.equals(rhs.supportsDatabase)) && (this.supportsLineageExtraction == rhs.supportsLineageExtraction || this.supportsLineageExtraction != null && this.supportsLineageExtraction.equals(rhs.supportsLineageExtraction)) && (this.connectionOptions == rhs.connectionOptions || this.connectionOptions != null && this.connectionOptions.equals(rhs.connectionOptions)) && (this.hostPort == rhs.hostPort || this.hostPort != null && this.hostPort.equals(rhs.hostPort)) && (this.usageLocation == rhs.usageLocation || this.usageLocation != null && this.usageLocation.equals(rhs.usageLocation)) && (this.supportsQueryComment == rhs.supportsQueryComment || this.supportsQueryComment != null && this.supportsQueryComment.equals(rhs.supportsQueryComment));
    }

    public static enum BigqueryType {
        BIG_QUERY("BigQuery");

        private final String value;
        private static final Map<String, BigqueryType> CONSTANTS;

        private BigqueryType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static BigqueryType fromValue(String value) {
            BigqueryType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, BigqueryType>();
            for (BigqueryType c : BigqueryType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum BigqueryScheme {
        BIGQUERY("bigquery");

        private final String value;
        private static final Map<String, BigqueryScheme> CONSTANTS;

        private BigqueryScheme(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static BigqueryScheme fromValue(String value) {
            BigqueryScheme constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, BigqueryScheme>();
            for (BigqueryScheme c : BigqueryScheme.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

