/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.services.connections.database;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.security.credentials.GCPCredentials;
import org.openmetadata.schema.services.connections.database.ConnectionArguments;
import org.openmetadata.schema.services.connections.database.ConnectionOptions;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "credentials", "connectionOptions", "connectionArguments", "supportsMetadataExtraction", "supportsDatabase"})
public class BigTableConnection {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Service type.")
    private BigtableType type = BigtableType.fromValue("BigTable");
    @JsonProperty(value="credentials")
    @JsonPropertyDescription(value="GCP credentials configs.")
    @Valid
    @NotNull
    private GCPCredentials credentials;
    @JsonProperty(value="connectionOptions")
    @JsonPropertyDescription(value="Additional connection options to build the URL that can be sent to service during the connection.")
    @Valid
    private ConnectionOptions connectionOptions;
    @JsonProperty(value="connectionArguments")
    @JsonPropertyDescription(value="Additional connection arguments such as security or protocol configs that can be sent to service during connection.")
    @Valid
    private ConnectionArguments connectionArguments;
    @JsonProperty(value="supportsMetadataExtraction")
    @JsonPropertyDescription(value="Supports Metadata Extraction.")
    private Boolean supportsMetadataExtraction = true;
    @JsonProperty(value="supportsDatabase")
    @JsonPropertyDescription(value="The source service supports the database concept in its hierarchy")
    private Boolean supportsDatabase = true;

    @JsonProperty(value="type")
    public BigtableType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(BigtableType type) {
        this.type = type;
    }

    public BigTableConnection withType(BigtableType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="credentials")
    public GCPCredentials getCredentials() {
        return this.credentials;
    }

    @JsonProperty(value="credentials")
    public void setCredentials(GCPCredentials credentials) {
        this.credentials = credentials;
    }

    public BigTableConnection withCredentials(GCPCredentials credentials) {
        this.credentials = credentials;
        return this;
    }

    @JsonProperty(value="connectionOptions")
    public ConnectionOptions getConnectionOptions() {
        return this.connectionOptions;
    }

    @JsonProperty(value="connectionOptions")
    public void setConnectionOptions(ConnectionOptions connectionOptions) {
        this.connectionOptions = connectionOptions;
    }

    public BigTableConnection withConnectionOptions(ConnectionOptions connectionOptions) {
        this.connectionOptions = connectionOptions;
        return this;
    }

    @JsonProperty(value="connectionArguments")
    public ConnectionArguments getConnectionArguments() {
        return this.connectionArguments;
    }

    @JsonProperty(value="connectionArguments")
    public void setConnectionArguments(ConnectionArguments connectionArguments) {
        this.connectionArguments = connectionArguments;
    }

    public BigTableConnection withConnectionArguments(ConnectionArguments connectionArguments) {
        this.connectionArguments = connectionArguments;
        return this;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public Boolean getSupportsMetadataExtraction() {
        return this.supportsMetadataExtraction;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public void setSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
    }

    public BigTableConnection withSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
        return this;
    }

    @JsonProperty(value="supportsDatabase")
    public Boolean getSupportsDatabase() {
        return this.supportsDatabase;
    }

    @JsonProperty(value="supportsDatabase")
    public void setSupportsDatabase(Boolean supportsDatabase) {
        this.supportsDatabase = supportsDatabase;
    }

    public BigTableConnection withSupportsDatabase(Boolean supportsDatabase) {
        this.supportsDatabase = supportsDatabase;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(BigTableConnection.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("credentials");
        sb.append('=');
        sb.append(this.credentials == null ? "<null>" : this.credentials);
        sb.append(',');
        sb.append("connectionOptions");
        sb.append('=');
        sb.append(this.connectionOptions == null ? "<null>" : this.connectionOptions);
        sb.append(',');
        sb.append("connectionArguments");
        sb.append('=');
        sb.append(this.connectionArguments == null ? "<null>" : this.connectionArguments);
        sb.append(',');
        sb.append("supportsMetadataExtraction");
        sb.append('=');
        sb.append(this.supportsMetadataExtraction == null ? "<null>" : this.supportsMetadataExtraction);
        sb.append(',');
        sb.append("supportsDatabase");
        sb.append('=');
        sb.append(this.supportsDatabase == null ? "<null>" : this.supportsDatabase);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.supportsMetadataExtraction == null ? 0 : this.supportsMetadataExtraction.hashCode());
        result = result * 31 + (this.credentials == null ? 0 : this.credentials.hashCode());
        result = result * 31 + (this.connectionOptions == null ? 0 : this.connectionOptions.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.connectionArguments == null ? 0 : this.connectionArguments.hashCode());
        result = result * 31 + (this.supportsDatabase == null ? 0 : this.supportsDatabase.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof BigTableConnection)) {
            return false;
        }
        BigTableConnection rhs = (BigTableConnection)other;
        return (this.supportsMetadataExtraction == rhs.supportsMetadataExtraction || this.supportsMetadataExtraction != null && this.supportsMetadataExtraction.equals(rhs.supportsMetadataExtraction)) && (this.credentials == rhs.credentials || this.credentials != null && this.credentials.equals(rhs.credentials)) && (this.connectionOptions == rhs.connectionOptions || this.connectionOptions != null && this.connectionOptions.equals(rhs.connectionOptions)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.connectionArguments == rhs.connectionArguments || this.connectionArguments != null && this.connectionArguments.equals(rhs.connectionArguments)) && (this.supportsDatabase == rhs.supportsDatabase || this.supportsDatabase != null && this.supportsDatabase.equals(rhs.supportsDatabase));
    }

    public static enum BigtableType {
        BIG_TABLE("BigTable");

        private final String value;
        private static final Map<String, BigtableType> CONSTANTS;

        private BigtableType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static BigtableType fromValue(String value) {
            BigtableType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, BigtableType>();
            for (BigtableType c : BigtableType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

