/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.services.connections.database;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.openmetadata.annotations.PasswordField;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "scheme", "bucket", "username", "password", "hostport", "supportsMetadataExtraction"})
public class CouchbaseConnection {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Service type.")
    private CouchbaseType type = CouchbaseType.fromValue("Couchbase");
    @JsonProperty(value="scheme")
    @JsonPropertyDescription(value="Couchbase driver scheme options.")
    private CouchbaseScheme scheme = CouchbaseScheme.fromValue("couchbase");
    @JsonProperty(value="bucket")
    @JsonPropertyDescription(value="Couchbase connection Bucket options.")
    private String bucket;
    @JsonProperty(value="username")
    @JsonPropertyDescription(value="Username to connect to Couchbase. This user should have privileges to read all the metadata in Couchbase.")
    @NotNull
    private String username;
    @JsonProperty(value="password")
    @JsonPropertyDescription(value="Password to connect to Couchbase.")
    @PasswordField
    @NotNull
    private String password;
    @JsonProperty(value="hostport")
    @JsonPropertyDescription(value="Hostname of the Couchbase service.")
    @NotNull
    private String hostport;
    @JsonProperty(value="supportsMetadataExtraction")
    @JsonPropertyDescription(value="Supports Metadata Extraction.")
    private Boolean supportsMetadataExtraction = true;

    @JsonProperty(value="type")
    public CouchbaseType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(CouchbaseType type) {
        this.type = type;
    }

    public CouchbaseConnection withType(CouchbaseType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="scheme")
    public CouchbaseScheme getScheme() {
        return this.scheme;
    }

    @JsonProperty(value="scheme")
    public void setScheme(CouchbaseScheme scheme) {
        this.scheme = scheme;
    }

    public CouchbaseConnection withScheme(CouchbaseScheme scheme) {
        this.scheme = scheme;
        return this;
    }

    @JsonProperty(value="bucket")
    public String getBucket() {
        return this.bucket;
    }

    @JsonProperty(value="bucket")
    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public CouchbaseConnection withBucket(String bucket) {
        this.bucket = bucket;
        return this;
    }

    @JsonProperty(value="username")
    public String getUsername() {
        return this.username;
    }

    @JsonProperty(value="username")
    public void setUsername(String username) {
        this.username = username;
    }

    public CouchbaseConnection withUsername(String username) {
        this.username = username;
        return this;
    }

    @JsonProperty(value="password")
    @PasswordField
    public String getPassword() {
        return this.password;
    }

    @JsonProperty(value="password")
    @PasswordField
    public void setPassword(String password) {
        this.password = password;
    }

    public CouchbaseConnection withPassword(String password) {
        this.password = password;
        return this;
    }

    @JsonProperty(value="hostport")
    public String getHostport() {
        return this.hostport;
    }

    @JsonProperty(value="hostport")
    public void setHostport(String hostport) {
        this.hostport = hostport;
    }

    public CouchbaseConnection withHostport(String hostport) {
        this.hostport = hostport;
        return this;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public Boolean getSupportsMetadataExtraction() {
        return this.supportsMetadataExtraction;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public void setSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
    }

    public CouchbaseConnection withSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CouchbaseConnection.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("scheme");
        sb.append('=');
        sb.append(this.scheme == null ? "<null>" : this.scheme);
        sb.append(',');
        sb.append("bucket");
        sb.append('=');
        sb.append(this.bucket == null ? "<null>" : this.bucket);
        sb.append(',');
        sb.append("username");
        sb.append('=');
        sb.append(this.username == null ? "<null>" : this.username);
        sb.append(',');
        sb.append("password");
        sb.append('=');
        sb.append(this.password == null ? "<null>" : this.password);
        sb.append(',');
        sb.append("hostport");
        sb.append('=');
        sb.append(this.hostport == null ? "<null>" : this.hostport);
        sb.append(',');
        sb.append("supportsMetadataExtraction");
        sb.append('=');
        sb.append(this.supportsMetadataExtraction == null ? "<null>" : this.supportsMetadataExtraction);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.bucket == null ? 0 : this.bucket.hashCode());
        result = result * 31 + (this.supportsMetadataExtraction == null ? 0 : this.supportsMetadataExtraction.hashCode());
        result = result * 31 + (this.password == null ? 0 : this.password.hashCode());
        result = result * 31 + (this.scheme == null ? 0 : this.scheme.hashCode());
        result = result * 31 + (this.hostport == null ? 0 : this.hostport.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.username == null ? 0 : this.username.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CouchbaseConnection)) {
            return false;
        }
        CouchbaseConnection rhs = (CouchbaseConnection)other;
        return (this.bucket == rhs.bucket || this.bucket != null && this.bucket.equals(rhs.bucket)) && (this.supportsMetadataExtraction == rhs.supportsMetadataExtraction || this.supportsMetadataExtraction != null && this.supportsMetadataExtraction.equals(rhs.supportsMetadataExtraction)) && (this.password == rhs.password || this.password != null && this.password.equals(rhs.password)) && (this.scheme == rhs.scheme || this.scheme != null && this.scheme.equals((Object)rhs.scheme)) && (this.hostport == rhs.hostport || this.hostport != null && this.hostport.equals(rhs.hostport)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.username == rhs.username || this.username != null && this.username.equals(rhs.username));
    }

    public static enum CouchbaseType {
        COUCHBASE("Couchbase");

        private final String value;
        private static final Map<String, CouchbaseType> CONSTANTS;

        private CouchbaseType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static CouchbaseType fromValue(String value) {
            CouchbaseType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, CouchbaseType>();
            for (CouchbaseType c : CouchbaseType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum CouchbaseScheme {
        COUCHBASE("couchbase");

        private final String value;
        private static final Map<String, CouchbaseScheme> CONSTANTS;

        private CouchbaseScheme(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static CouchbaseScheme fromValue(String value) {
            CouchbaseScheme constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, CouchbaseScheme>();
            for (CouchbaseScheme c : CouchbaseScheme.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

