/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.services.connections.database;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.annotations.PasswordField;
import org.openmetadata.schema.services.connections.database.ConnectionArguments;
import org.openmetadata.schema.services.connections.database.ConnectionOptions;
import org.openmetadata.schema.services.connections.database.SampleDataStorageConfig;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "scheme", "hostPort", "token", "httpPath", "catalog", "databaseSchema", "connectionTimeout", "connectionOptions", "connectionArguments", "supportsUsageExtraction", "supportsLineageExtraction", "supportsDBTExtraction", "supportsMetadataExtraction", "supportsProfiler", "supportsDatabase", "supportsQueryComment", "sampleDataStorageConfig"})
public class DatabricksConnection {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Service type.")
    private DatabricksType type = DatabricksType.fromValue("Databricks");
    @JsonProperty(value="scheme")
    @JsonPropertyDescription(value="SQLAlchemy driver scheme options.")
    private DatabricksScheme scheme = DatabricksScheme.fromValue("databricks+connector");
    @JsonProperty(value="hostPort")
    @JsonPropertyDescription(value="Host and port of the Databricks service.")
    @NotNull
    private String hostPort;
    @JsonProperty(value="token")
    @JsonPropertyDescription(value="Generated Token to connect to Databricks.")
    @PasswordField
    @NotNull
    private String token;
    @JsonProperty(value="httpPath")
    @JsonPropertyDescription(value="Databricks compute resources URL.")
    private String httpPath;
    @JsonProperty(value="catalog")
    @JsonPropertyDescription(value="Catalog of the data source(Example: hive_metastore). This is optional parameter, if you would like to restrict the metadata reading to a single catalog. When left blank, OpenMetadata Ingestion attempts to scan all the catalog.")
    private String catalog;
    @JsonProperty(value="databaseSchema")
    @JsonPropertyDescription(value="Database Schema of the data source. This is optional parameter, if you would like to restrict the metadata reading to a single schema. When left blank, OpenMetadata Ingestion attempts to scan all the schemas.")
    private String databaseSchema;
    @JsonProperty(value="connectionTimeout")
    @JsonPropertyDescription(value="The maximum amount of time (in seconds) to wait for a successful connection to the data source. If the connection attempt takes longer than this timeout period, an error will be returned.")
    private Integer connectionTimeout = 120;
    @JsonProperty(value="connectionOptions")
    @JsonPropertyDescription(value="Additional connection options to build the URL that can be sent to service during the connection.")
    @Valid
    private ConnectionOptions connectionOptions;
    @JsonProperty(value="connectionArguments")
    @JsonPropertyDescription(value="Additional connection arguments such as security or protocol configs that can be sent to service during connection.")
    @Valid
    private ConnectionArguments connectionArguments;
    @JsonProperty(value="supportsUsageExtraction")
    @JsonPropertyDescription(value="Supports Usage Extraction.")
    private Boolean supportsUsageExtraction = true;
    @JsonProperty(value="supportsLineageExtraction")
    @JsonPropertyDescription(value="Supports Lineage Extraction.")
    private Boolean supportsLineageExtraction = true;
    @JsonProperty(value="supportsDBTExtraction")
    @JsonPropertyDescription(value="Supports DBT Extraction.")
    private Boolean supportsDBTExtraction = true;
    @JsonProperty(value="supportsMetadataExtraction")
    @JsonPropertyDescription(value="Supports Metadata Extraction.")
    private Boolean supportsMetadataExtraction = true;
    @JsonProperty(value="supportsProfiler")
    @JsonPropertyDescription(value="Supports Profiler")
    private Boolean supportsProfiler = true;
    @JsonProperty(value="supportsDatabase")
    @JsonPropertyDescription(value="The source service supports the database concept in its hierarchy")
    private Boolean supportsDatabase = true;
    @JsonProperty(value="supportsQueryComment")
    @JsonPropertyDescription(value="For Database Services using SQLAlchemy, True to enable running a comment for all queries run from OpenMetadata.")
    private Boolean supportsQueryComment = true;
    @JsonProperty(value="sampleDataStorageConfig")
    @JsonPropertyDescription(value="Storage config to store sample data")
    @Valid
    private SampleDataStorageConfig sampleDataStorageConfig;

    @JsonProperty(value="type")
    public DatabricksType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(DatabricksType type) {
        this.type = type;
    }

    public DatabricksConnection withType(DatabricksType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="scheme")
    public DatabricksScheme getScheme() {
        return this.scheme;
    }

    @JsonProperty(value="scheme")
    public void setScheme(DatabricksScheme scheme) {
        this.scheme = scheme;
    }

    public DatabricksConnection withScheme(DatabricksScheme scheme) {
        this.scheme = scheme;
        return this;
    }

    @JsonProperty(value="hostPort")
    public String getHostPort() {
        return this.hostPort;
    }

    @JsonProperty(value="hostPort")
    public void setHostPort(String hostPort) {
        this.hostPort = hostPort;
    }

    public DatabricksConnection withHostPort(String hostPort) {
        this.hostPort = hostPort;
        return this;
    }

    @JsonProperty(value="token")
    @PasswordField
    public String getToken() {
        return this.token;
    }

    @JsonProperty(value="token")
    @PasswordField
    public void setToken(String token) {
        this.token = token;
    }

    public DatabricksConnection withToken(String token) {
        this.token = token;
        return this;
    }

    @JsonProperty(value="httpPath")
    public String getHttpPath() {
        return this.httpPath;
    }

    @JsonProperty(value="httpPath")
    public void setHttpPath(String httpPath) {
        this.httpPath = httpPath;
    }

    public DatabricksConnection withHttpPath(String httpPath) {
        this.httpPath = httpPath;
        return this;
    }

    @JsonProperty(value="catalog")
    public String getCatalog() {
        return this.catalog;
    }

    @JsonProperty(value="catalog")
    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public DatabricksConnection withCatalog(String catalog) {
        this.catalog = catalog;
        return this;
    }

    @JsonProperty(value="databaseSchema")
    public String getDatabaseSchema() {
        return this.databaseSchema;
    }

    @JsonProperty(value="databaseSchema")
    public void setDatabaseSchema(String databaseSchema) {
        this.databaseSchema = databaseSchema;
    }

    public DatabricksConnection withDatabaseSchema(String databaseSchema) {
        this.databaseSchema = databaseSchema;
        return this;
    }

    @JsonProperty(value="connectionTimeout")
    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @JsonProperty(value="connectionTimeout")
    public void setConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public DatabricksConnection withConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    @JsonProperty(value="connectionOptions")
    public ConnectionOptions getConnectionOptions() {
        return this.connectionOptions;
    }

    @JsonProperty(value="connectionOptions")
    public void setConnectionOptions(ConnectionOptions connectionOptions) {
        this.connectionOptions = connectionOptions;
    }

    public DatabricksConnection withConnectionOptions(ConnectionOptions connectionOptions) {
        this.connectionOptions = connectionOptions;
        return this;
    }

    @JsonProperty(value="connectionArguments")
    public ConnectionArguments getConnectionArguments() {
        return this.connectionArguments;
    }

    @JsonProperty(value="connectionArguments")
    public void setConnectionArguments(ConnectionArguments connectionArguments) {
        this.connectionArguments = connectionArguments;
    }

    public DatabricksConnection withConnectionArguments(ConnectionArguments connectionArguments) {
        this.connectionArguments = connectionArguments;
        return this;
    }

    @JsonProperty(value="supportsUsageExtraction")
    public Boolean getSupportsUsageExtraction() {
        return this.supportsUsageExtraction;
    }

    @JsonProperty(value="supportsUsageExtraction")
    public void setSupportsUsageExtraction(Boolean supportsUsageExtraction) {
        this.supportsUsageExtraction = supportsUsageExtraction;
    }

    public DatabricksConnection withSupportsUsageExtraction(Boolean supportsUsageExtraction) {
        this.supportsUsageExtraction = supportsUsageExtraction;
        return this;
    }

    @JsonProperty(value="supportsLineageExtraction")
    public Boolean getSupportsLineageExtraction() {
        return this.supportsLineageExtraction;
    }

    @JsonProperty(value="supportsLineageExtraction")
    public void setSupportsLineageExtraction(Boolean supportsLineageExtraction) {
        this.supportsLineageExtraction = supportsLineageExtraction;
    }

    public DatabricksConnection withSupportsLineageExtraction(Boolean supportsLineageExtraction) {
        this.supportsLineageExtraction = supportsLineageExtraction;
        return this;
    }

    @JsonProperty(value="supportsDBTExtraction")
    public Boolean getSupportsDBTExtraction() {
        return this.supportsDBTExtraction;
    }

    @JsonProperty(value="supportsDBTExtraction")
    public void setSupportsDBTExtraction(Boolean supportsDBTExtraction) {
        this.supportsDBTExtraction = supportsDBTExtraction;
    }

    public DatabricksConnection withSupportsDBTExtraction(Boolean supportsDBTExtraction) {
        this.supportsDBTExtraction = supportsDBTExtraction;
        return this;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public Boolean getSupportsMetadataExtraction() {
        return this.supportsMetadataExtraction;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public void setSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
    }

    public DatabricksConnection withSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
        return this;
    }

    @JsonProperty(value="supportsProfiler")
    public Boolean getSupportsProfiler() {
        return this.supportsProfiler;
    }

    @JsonProperty(value="supportsProfiler")
    public void setSupportsProfiler(Boolean supportsProfiler) {
        this.supportsProfiler = supportsProfiler;
    }

    public DatabricksConnection withSupportsProfiler(Boolean supportsProfiler) {
        this.supportsProfiler = supportsProfiler;
        return this;
    }

    @JsonProperty(value="supportsDatabase")
    public Boolean getSupportsDatabase() {
        return this.supportsDatabase;
    }

    @JsonProperty(value="supportsDatabase")
    public void setSupportsDatabase(Boolean supportsDatabase) {
        this.supportsDatabase = supportsDatabase;
    }

    public DatabricksConnection withSupportsDatabase(Boolean supportsDatabase) {
        this.supportsDatabase = supportsDatabase;
        return this;
    }

    @JsonProperty(value="supportsQueryComment")
    public Boolean getSupportsQueryComment() {
        return this.supportsQueryComment;
    }

    @JsonProperty(value="supportsQueryComment")
    public void setSupportsQueryComment(Boolean supportsQueryComment) {
        this.supportsQueryComment = supportsQueryComment;
    }

    public DatabricksConnection withSupportsQueryComment(Boolean supportsQueryComment) {
        this.supportsQueryComment = supportsQueryComment;
        return this;
    }

    @JsonProperty(value="sampleDataStorageConfig")
    public SampleDataStorageConfig getSampleDataStorageConfig() {
        return this.sampleDataStorageConfig;
    }

    @JsonProperty(value="sampleDataStorageConfig")
    public void setSampleDataStorageConfig(SampleDataStorageConfig sampleDataStorageConfig) {
        this.sampleDataStorageConfig = sampleDataStorageConfig;
    }

    public DatabricksConnection withSampleDataStorageConfig(SampleDataStorageConfig sampleDataStorageConfig) {
        this.sampleDataStorageConfig = sampleDataStorageConfig;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DatabricksConnection.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("scheme");
        sb.append('=');
        sb.append(this.scheme == null ? "<null>" : this.scheme);
        sb.append(',');
        sb.append("hostPort");
        sb.append('=');
        sb.append(this.hostPort == null ? "<null>" : this.hostPort);
        sb.append(',');
        sb.append("token");
        sb.append('=');
        sb.append(this.token == null ? "<null>" : this.token);
        sb.append(',');
        sb.append("httpPath");
        sb.append('=');
        sb.append(this.httpPath == null ? "<null>" : this.httpPath);
        sb.append(',');
        sb.append("catalog");
        sb.append('=');
        sb.append(this.catalog == null ? "<null>" : this.catalog);
        sb.append(',');
        sb.append("databaseSchema");
        sb.append('=');
        sb.append(this.databaseSchema == null ? "<null>" : this.databaseSchema);
        sb.append(',');
        sb.append("connectionTimeout");
        sb.append('=');
        sb.append(this.connectionTimeout == null ? "<null>" : this.connectionTimeout);
        sb.append(',');
        sb.append("connectionOptions");
        sb.append('=');
        sb.append(this.connectionOptions == null ? "<null>" : this.connectionOptions);
        sb.append(',');
        sb.append("connectionArguments");
        sb.append('=');
        sb.append(this.connectionArguments == null ? "<null>" : this.connectionArguments);
        sb.append(',');
        sb.append("supportsUsageExtraction");
        sb.append('=');
        sb.append(this.supportsUsageExtraction == null ? "<null>" : this.supportsUsageExtraction);
        sb.append(',');
        sb.append("supportsLineageExtraction");
        sb.append('=');
        sb.append(this.supportsLineageExtraction == null ? "<null>" : this.supportsLineageExtraction);
        sb.append(',');
        sb.append("supportsDBTExtraction");
        sb.append('=');
        sb.append(this.supportsDBTExtraction == null ? "<null>" : this.supportsDBTExtraction);
        sb.append(',');
        sb.append("supportsMetadataExtraction");
        sb.append('=');
        sb.append(this.supportsMetadataExtraction == null ? "<null>" : this.supportsMetadataExtraction);
        sb.append(',');
        sb.append("supportsProfiler");
        sb.append('=');
        sb.append(this.supportsProfiler == null ? "<null>" : this.supportsProfiler);
        sb.append(',');
        sb.append("supportsDatabase");
        sb.append('=');
        sb.append(this.supportsDatabase == null ? "<null>" : this.supportsDatabase);
        sb.append(',');
        sb.append("supportsQueryComment");
        sb.append('=');
        sb.append(this.supportsQueryComment == null ? "<null>" : this.supportsQueryComment);
        sb.append(',');
        sb.append("sampleDataStorageConfig");
        sb.append('=');
        sb.append(this.sampleDataStorageConfig == null ? "<null>" : this.sampleDataStorageConfig);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.databaseSchema == null ? 0 : this.databaseSchema.hashCode());
        result = result * 31 + (this.supportsMetadataExtraction == null ? 0 : this.supportsMetadataExtraction.hashCode());
        result = result * 31 + (this.httpPath == null ? 0 : this.httpPath.hashCode());
        result = result * 31 + (this.scheme == null ? 0 : this.scheme.hashCode());
        result = result * 31 + (this.supportsProfiler == null ? 0 : this.supportsProfiler.hashCode());
        result = result * 31 + (this.catalog == null ? 0 : this.catalog.hashCode());
        result = result * 31 + (this.sampleDataStorageConfig == null ? 0 : this.sampleDataStorageConfig.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.supportsUsageExtraction == null ? 0 : this.supportsUsageExtraction.hashCode());
        result = result * 31 + (this.supportsDBTExtraction == null ? 0 : this.supportsDBTExtraction.hashCode());
        result = result * 31 + (this.token == null ? 0 : this.token.hashCode());
        result = result * 31 + (this.connectionArguments == null ? 0 : this.connectionArguments.hashCode());
        result = result * 31 + (this.supportsDatabase == null ? 0 : this.supportsDatabase.hashCode());
        result = result * 31 + (this.supportsLineageExtraction == null ? 0 : this.supportsLineageExtraction.hashCode());
        result = result * 31 + (this.connectionOptions == null ? 0 : this.connectionOptions.hashCode());
        result = result * 31 + (this.hostPort == null ? 0 : this.hostPort.hashCode());
        result = result * 31 + (this.supportsQueryComment == null ? 0 : this.supportsQueryComment.hashCode());
        result = result * 31 + (this.connectionTimeout == null ? 0 : this.connectionTimeout.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof DatabricksConnection)) {
            return false;
        }
        DatabricksConnection rhs = (DatabricksConnection)other;
        return (this.databaseSchema == rhs.databaseSchema || this.databaseSchema != null && this.databaseSchema.equals(rhs.databaseSchema)) && (this.supportsMetadataExtraction == rhs.supportsMetadataExtraction || this.supportsMetadataExtraction != null && this.supportsMetadataExtraction.equals(rhs.supportsMetadataExtraction)) && (this.httpPath == rhs.httpPath || this.httpPath != null && this.httpPath.equals(rhs.httpPath)) && (this.scheme == rhs.scheme || this.scheme != null && this.scheme.equals((Object)rhs.scheme)) && (this.supportsProfiler == rhs.supportsProfiler || this.supportsProfiler != null && this.supportsProfiler.equals(rhs.supportsProfiler)) && (this.catalog == rhs.catalog || this.catalog != null && this.catalog.equals(rhs.catalog)) && (this.sampleDataStorageConfig == rhs.sampleDataStorageConfig || this.sampleDataStorageConfig != null && this.sampleDataStorageConfig.equals(rhs.sampleDataStorageConfig)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.supportsUsageExtraction == rhs.supportsUsageExtraction || this.supportsUsageExtraction != null && this.supportsUsageExtraction.equals(rhs.supportsUsageExtraction)) && (this.supportsDBTExtraction == rhs.supportsDBTExtraction || this.supportsDBTExtraction != null && this.supportsDBTExtraction.equals(rhs.supportsDBTExtraction)) && (this.token == rhs.token || this.token != null && this.token.equals(rhs.token)) && (this.connectionArguments == rhs.connectionArguments || this.connectionArguments != null && this.connectionArguments.equals(rhs.connectionArguments)) && (this.supportsDatabase == rhs.supportsDatabase || this.supportsDatabase != null && this.supportsDatabase.equals(rhs.supportsDatabase)) && (this.supportsLineageExtraction == rhs.supportsLineageExtraction || this.supportsLineageExtraction != null && this.supportsLineageExtraction.equals(rhs.supportsLineageExtraction)) && (this.connectionOptions == rhs.connectionOptions || this.connectionOptions != null && this.connectionOptions.equals(rhs.connectionOptions)) && (this.hostPort == rhs.hostPort || this.hostPort != null && this.hostPort.equals(rhs.hostPort)) && (this.supportsQueryComment == rhs.supportsQueryComment || this.supportsQueryComment != null && this.supportsQueryComment.equals(rhs.supportsQueryComment)) && (this.connectionTimeout == rhs.connectionTimeout || this.connectionTimeout != null && this.connectionTimeout.equals(rhs.connectionTimeout));
    }

    public static enum DatabricksType {
        DATABRICKS("Databricks");

        private final String value;
        private static final Map<String, DatabricksType> CONSTANTS;

        private DatabricksType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static DatabricksType fromValue(String value) {
            DatabricksType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, DatabricksType>();
            for (DatabricksType c : DatabricksType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum DatabricksScheme {
        DATABRICKS_CONNECTOR("databricks+connector");

        private final String value;
        private static final Map<String, DatabricksScheme> CONSTANTS;

        private DatabricksScheme(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static DatabricksScheme fromValue(String value) {
            DatabricksScheme constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, DatabricksScheme>();
            for (DatabricksScheme c : DatabricksScheme.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

