/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.services.connections.database;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.annotations.PasswordField;
import org.openmetadata.schema.services.connections.database.ConnectionArguments;
import org.openmetadata.schema.services.connections.database.ConnectionOptions;
import org.openmetadata.schema.services.connections.database.SampleDataStorageConfig;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "scheme", "username", "password", "hostPort", "database", "connectionOptions", "connectionArguments", "supportsMetadataExtraction", "supportsDBTExtraction", "supportsProfiler", "supportsDatabase", "supportsQueryComment", "sampleDataStorageConfig"})
public class Db2Connection {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Service type.")
    private Db2Type type = Db2Type.fromValue("Db2");
    @JsonProperty(value="scheme")
    @JsonPropertyDescription(value="SQLAlchemy driver scheme options.")
    private Db2Scheme scheme = Db2Scheme.fromValue("db2+ibm_db");
    @JsonProperty(value="username")
    @JsonPropertyDescription(value="Username to connect to DB2. This user should have privileges to read all the metadata in DB2.")
    @NotNull
    private String username;
    @JsonProperty(value="password")
    @JsonPropertyDescription(value="Password to connect to DB2.")
    @PasswordField
    private String password;
    @JsonProperty(value="hostPort")
    @JsonPropertyDescription(value="Host and port of the DB2 service.")
    @NotNull
    private String hostPort;
    @JsonProperty(value="database")
    @JsonPropertyDescription(value="Database of the data source.")
    @NotNull
    private String database;
    @JsonProperty(value="connectionOptions")
    @JsonPropertyDescription(value="Additional connection options to build the URL that can be sent to service during the connection.")
    @Valid
    private ConnectionOptions connectionOptions;
    @JsonProperty(value="connectionArguments")
    @JsonPropertyDescription(value="Additional connection arguments such as security or protocol configs that can be sent to service during connection.")
    @Valid
    private ConnectionArguments connectionArguments;
    @JsonProperty(value="supportsMetadataExtraction")
    @JsonPropertyDescription(value="Supports Metadata Extraction.")
    private Boolean supportsMetadataExtraction = true;
    @JsonProperty(value="supportsDBTExtraction")
    @JsonPropertyDescription(value="Supports DBT Extraction.")
    private Boolean supportsDBTExtraction = true;
    @JsonProperty(value="supportsProfiler")
    @JsonPropertyDescription(value="Supports Profiler")
    private Boolean supportsProfiler = true;
    @JsonProperty(value="supportsDatabase")
    @JsonPropertyDescription(value="The source service supports the database concept in its hierarchy")
    private Boolean supportsDatabase = true;
    @JsonProperty(value="supportsQueryComment")
    @JsonPropertyDescription(value="For Database Services using SQLAlchemy, True to enable running a comment for all queries run from OpenMetadata.")
    private Boolean supportsQueryComment = true;
    @JsonProperty(value="sampleDataStorageConfig")
    @JsonPropertyDescription(value="Storage config to store sample data")
    @Valid
    private SampleDataStorageConfig sampleDataStorageConfig;

    @JsonProperty(value="type")
    public Db2Type getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(Db2Type type) {
        this.type = type;
    }

    public Db2Connection withType(Db2Type type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="scheme")
    public Db2Scheme getScheme() {
        return this.scheme;
    }

    @JsonProperty(value="scheme")
    public void setScheme(Db2Scheme scheme) {
        this.scheme = scheme;
    }

    public Db2Connection withScheme(Db2Scheme scheme) {
        this.scheme = scheme;
        return this;
    }

    @JsonProperty(value="username")
    public String getUsername() {
        return this.username;
    }

    @JsonProperty(value="username")
    public void setUsername(String username) {
        this.username = username;
    }

    public Db2Connection withUsername(String username) {
        this.username = username;
        return this;
    }

    @JsonProperty(value="password")
    @PasswordField
    public String getPassword() {
        return this.password;
    }

    @JsonProperty(value="password")
    @PasswordField
    public void setPassword(String password) {
        this.password = password;
    }

    public Db2Connection withPassword(String password) {
        this.password = password;
        return this;
    }

    @JsonProperty(value="hostPort")
    public String getHostPort() {
        return this.hostPort;
    }

    @JsonProperty(value="hostPort")
    public void setHostPort(String hostPort) {
        this.hostPort = hostPort;
    }

    public Db2Connection withHostPort(String hostPort) {
        this.hostPort = hostPort;
        return this;
    }

    @JsonProperty(value="database")
    public String getDatabase() {
        return this.database;
    }

    @JsonProperty(value="database")
    public void setDatabase(String database) {
        this.database = database;
    }

    public Db2Connection withDatabase(String database) {
        this.database = database;
        return this;
    }

    @JsonProperty(value="connectionOptions")
    public ConnectionOptions getConnectionOptions() {
        return this.connectionOptions;
    }

    @JsonProperty(value="connectionOptions")
    public void setConnectionOptions(ConnectionOptions connectionOptions) {
        this.connectionOptions = connectionOptions;
    }

    public Db2Connection withConnectionOptions(ConnectionOptions connectionOptions) {
        this.connectionOptions = connectionOptions;
        return this;
    }

    @JsonProperty(value="connectionArguments")
    public ConnectionArguments getConnectionArguments() {
        return this.connectionArguments;
    }

    @JsonProperty(value="connectionArguments")
    public void setConnectionArguments(ConnectionArguments connectionArguments) {
        this.connectionArguments = connectionArguments;
    }

    public Db2Connection withConnectionArguments(ConnectionArguments connectionArguments) {
        this.connectionArguments = connectionArguments;
        return this;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public Boolean getSupportsMetadataExtraction() {
        return this.supportsMetadataExtraction;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public void setSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
    }

    public Db2Connection withSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
        return this;
    }

    @JsonProperty(value="supportsDBTExtraction")
    public Boolean getSupportsDBTExtraction() {
        return this.supportsDBTExtraction;
    }

    @JsonProperty(value="supportsDBTExtraction")
    public void setSupportsDBTExtraction(Boolean supportsDBTExtraction) {
        this.supportsDBTExtraction = supportsDBTExtraction;
    }

    public Db2Connection withSupportsDBTExtraction(Boolean supportsDBTExtraction) {
        this.supportsDBTExtraction = supportsDBTExtraction;
        return this;
    }

    @JsonProperty(value="supportsProfiler")
    public Boolean getSupportsProfiler() {
        return this.supportsProfiler;
    }

    @JsonProperty(value="supportsProfiler")
    public void setSupportsProfiler(Boolean supportsProfiler) {
        this.supportsProfiler = supportsProfiler;
    }

    public Db2Connection withSupportsProfiler(Boolean supportsProfiler) {
        this.supportsProfiler = supportsProfiler;
        return this;
    }

    @JsonProperty(value="supportsDatabase")
    public Boolean getSupportsDatabase() {
        return this.supportsDatabase;
    }

    @JsonProperty(value="supportsDatabase")
    public void setSupportsDatabase(Boolean supportsDatabase) {
        this.supportsDatabase = supportsDatabase;
    }

    public Db2Connection withSupportsDatabase(Boolean supportsDatabase) {
        this.supportsDatabase = supportsDatabase;
        return this;
    }

    @JsonProperty(value="supportsQueryComment")
    public Boolean getSupportsQueryComment() {
        return this.supportsQueryComment;
    }

    @JsonProperty(value="supportsQueryComment")
    public void setSupportsQueryComment(Boolean supportsQueryComment) {
        this.supportsQueryComment = supportsQueryComment;
    }

    public Db2Connection withSupportsQueryComment(Boolean supportsQueryComment) {
        this.supportsQueryComment = supportsQueryComment;
        return this;
    }

    @JsonProperty(value="sampleDataStorageConfig")
    public SampleDataStorageConfig getSampleDataStorageConfig() {
        return this.sampleDataStorageConfig;
    }

    @JsonProperty(value="sampleDataStorageConfig")
    public void setSampleDataStorageConfig(SampleDataStorageConfig sampleDataStorageConfig) {
        this.sampleDataStorageConfig = sampleDataStorageConfig;
    }

    public Db2Connection withSampleDataStorageConfig(SampleDataStorageConfig sampleDataStorageConfig) {
        this.sampleDataStorageConfig = sampleDataStorageConfig;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Db2Connection.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("scheme");
        sb.append('=');
        sb.append(this.scheme == null ? "<null>" : this.scheme);
        sb.append(',');
        sb.append("username");
        sb.append('=');
        sb.append(this.username == null ? "<null>" : this.username);
        sb.append(',');
        sb.append("password");
        sb.append('=');
        sb.append(this.password == null ? "<null>" : this.password);
        sb.append(',');
        sb.append("hostPort");
        sb.append('=');
        sb.append(this.hostPort == null ? "<null>" : this.hostPort);
        sb.append(',');
        sb.append("database");
        sb.append('=');
        sb.append(this.database == null ? "<null>" : this.database);
        sb.append(',');
        sb.append("connectionOptions");
        sb.append('=');
        sb.append(this.connectionOptions == null ? "<null>" : this.connectionOptions);
        sb.append(',');
        sb.append("connectionArguments");
        sb.append('=');
        sb.append(this.connectionArguments == null ? "<null>" : this.connectionArguments);
        sb.append(',');
        sb.append("supportsMetadataExtraction");
        sb.append('=');
        sb.append(this.supportsMetadataExtraction == null ? "<null>" : this.supportsMetadataExtraction);
        sb.append(',');
        sb.append("supportsDBTExtraction");
        sb.append('=');
        sb.append(this.supportsDBTExtraction == null ? "<null>" : this.supportsDBTExtraction);
        sb.append(',');
        sb.append("supportsProfiler");
        sb.append('=');
        sb.append(this.supportsProfiler == null ? "<null>" : this.supportsProfiler);
        sb.append(',');
        sb.append("supportsDatabase");
        sb.append('=');
        sb.append(this.supportsDatabase == null ? "<null>" : this.supportsDatabase);
        sb.append(',');
        sb.append("supportsQueryComment");
        sb.append('=');
        sb.append(this.supportsQueryComment == null ? "<null>" : this.supportsQueryComment);
        sb.append(',');
        sb.append("sampleDataStorageConfig");
        sb.append('=');
        sb.append(this.sampleDataStorageConfig == null ? "<null>" : this.sampleDataStorageConfig);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.supportsMetadataExtraction == null ? 0 : this.supportsMetadataExtraction.hashCode());
        result = result * 31 + (this.scheme == null ? 0 : this.scheme.hashCode());
        result = result * 31 + (this.supportsProfiler == null ? 0 : this.supportsProfiler.hashCode());
        result = result * 31 + (this.sampleDataStorageConfig == null ? 0 : this.sampleDataStorageConfig.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.supportsDBTExtraction == null ? 0 : this.supportsDBTExtraction.hashCode());
        result = result * 31 + (this.connectionArguments == null ? 0 : this.connectionArguments.hashCode());
        result = result * 31 + (this.supportsDatabase == null ? 0 : this.supportsDatabase.hashCode());
        result = result * 31 + (this.password == null ? 0 : this.password.hashCode());
        result = result * 31 + (this.database == null ? 0 : this.database.hashCode());
        result = result * 31 + (this.connectionOptions == null ? 0 : this.connectionOptions.hashCode());
        result = result * 31 + (this.hostPort == null ? 0 : this.hostPort.hashCode());
        result = result * 31 + (this.supportsQueryComment == null ? 0 : this.supportsQueryComment.hashCode());
        result = result * 31 + (this.username == null ? 0 : this.username.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Db2Connection)) {
            return false;
        }
        Db2Connection rhs = (Db2Connection)other;
        return (this.supportsMetadataExtraction == rhs.supportsMetadataExtraction || this.supportsMetadataExtraction != null && this.supportsMetadataExtraction.equals(rhs.supportsMetadataExtraction)) && (this.scheme == rhs.scheme || this.scheme != null && this.scheme.equals((Object)rhs.scheme)) && (this.supportsProfiler == rhs.supportsProfiler || this.supportsProfiler != null && this.supportsProfiler.equals(rhs.supportsProfiler)) && (this.sampleDataStorageConfig == rhs.sampleDataStorageConfig || this.sampleDataStorageConfig != null && this.sampleDataStorageConfig.equals(rhs.sampleDataStorageConfig)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.supportsDBTExtraction == rhs.supportsDBTExtraction || this.supportsDBTExtraction != null && this.supportsDBTExtraction.equals(rhs.supportsDBTExtraction)) && (this.connectionArguments == rhs.connectionArguments || this.connectionArguments != null && this.connectionArguments.equals(rhs.connectionArguments)) && (this.supportsDatabase == rhs.supportsDatabase || this.supportsDatabase != null && this.supportsDatabase.equals(rhs.supportsDatabase)) && (this.password == rhs.password || this.password != null && this.password.equals(rhs.password)) && (this.database == rhs.database || this.database != null && this.database.equals(rhs.database)) && (this.connectionOptions == rhs.connectionOptions || this.connectionOptions != null && this.connectionOptions.equals(rhs.connectionOptions)) && (this.hostPort == rhs.hostPort || this.hostPort != null && this.hostPort.equals(rhs.hostPort)) && (this.supportsQueryComment == rhs.supportsQueryComment || this.supportsQueryComment != null && this.supportsQueryComment.equals(rhs.supportsQueryComment)) && (this.username == rhs.username || this.username != null && this.username.equals(rhs.username));
    }

    public static enum Db2Type {
        DB_2("Db2");

        private final String value;
        private static final Map<String, Db2Type> CONSTANTS;

        private Db2Type(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Db2Type fromValue(String value) {
            Db2Type constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Db2Type>();
            for (Db2Type c : Db2Type.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum Db2Scheme {
        DB_2_IBM_DB("db2+ibm_db"),
        IBMI("ibmi");

        private final String value;
        private static final Map<String, Db2Scheme> CONSTANTS;

        private Db2Scheme(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Db2Scheme fromValue(String value) {
            Db2Scheme constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Db2Scheme>();
            for (Db2Scheme c : Db2Scheme.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

