/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.services.connections.database;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.services.connections.database.ConnectionArguments;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "configSource", "databaseName", "connectionArguments", "supportsMetadataExtraction", "supportsDBTExtraction"})
public class DeltaLakeConnection {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Service type.")
    private DeltaLakeType type = DeltaLakeType.fromValue("DeltaLake");
    @JsonProperty(value="configSource")
    @JsonPropertyDescription(value="Available sources to fetch the metadata.")
    @NotNull
    private Object configSource;
    @JsonProperty(value="databaseName")
    @JsonPropertyDescription(value="Optional name to give to the database in OpenMetadata. If left blank, we will use default as the database name.")
    private String databaseName;
    @JsonProperty(value="connectionArguments")
    @JsonPropertyDescription(value="Additional connection arguments such as security or protocol configs that can be sent to service during connection.")
    @Valid
    private ConnectionArguments connectionArguments;
    @JsonProperty(value="supportsMetadataExtraction")
    @JsonPropertyDescription(value="Supports Metadata Extraction.")
    private Boolean supportsMetadataExtraction = true;
    @JsonProperty(value="supportsDBTExtraction")
    @JsonPropertyDescription(value="Supports DBT Extraction.")
    private Boolean supportsDBTExtraction = true;

    @JsonProperty(value="type")
    public DeltaLakeType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(DeltaLakeType type) {
        this.type = type;
    }

    public DeltaLakeConnection withType(DeltaLakeType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="configSource")
    public Object getConfigSource() {
        return this.configSource;
    }

    @JsonProperty(value="configSource")
    public void setConfigSource(Object configSource) {
        this.configSource = configSource;
    }

    public DeltaLakeConnection withConfigSource(Object configSource) {
        this.configSource = configSource;
        return this;
    }

    @JsonProperty(value="databaseName")
    public String getDatabaseName() {
        return this.databaseName;
    }

    @JsonProperty(value="databaseName")
    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public DeltaLakeConnection withDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    @JsonProperty(value="connectionArguments")
    public ConnectionArguments getConnectionArguments() {
        return this.connectionArguments;
    }

    @JsonProperty(value="connectionArguments")
    public void setConnectionArguments(ConnectionArguments connectionArguments) {
        this.connectionArguments = connectionArguments;
    }

    public DeltaLakeConnection withConnectionArguments(ConnectionArguments connectionArguments) {
        this.connectionArguments = connectionArguments;
        return this;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public Boolean getSupportsMetadataExtraction() {
        return this.supportsMetadataExtraction;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public void setSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
    }

    public DeltaLakeConnection withSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
        return this;
    }

    @JsonProperty(value="supportsDBTExtraction")
    public Boolean getSupportsDBTExtraction() {
        return this.supportsDBTExtraction;
    }

    @JsonProperty(value="supportsDBTExtraction")
    public void setSupportsDBTExtraction(Boolean supportsDBTExtraction) {
        this.supportsDBTExtraction = supportsDBTExtraction;
    }

    public DeltaLakeConnection withSupportsDBTExtraction(Boolean supportsDBTExtraction) {
        this.supportsDBTExtraction = supportsDBTExtraction;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DeltaLakeConnection.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("configSource");
        sb.append('=');
        sb.append(this.configSource == null ? "<null>" : this.configSource);
        sb.append(',');
        sb.append("databaseName");
        sb.append('=');
        sb.append(this.databaseName == null ? "<null>" : this.databaseName);
        sb.append(',');
        sb.append("connectionArguments");
        sb.append('=');
        sb.append(this.connectionArguments == null ? "<null>" : this.connectionArguments);
        sb.append(',');
        sb.append("supportsMetadataExtraction");
        sb.append('=');
        sb.append(this.supportsMetadataExtraction == null ? "<null>" : this.supportsMetadataExtraction);
        sb.append(',');
        sb.append("supportsDBTExtraction");
        sb.append('=');
        sb.append(this.supportsDBTExtraction == null ? "<null>" : this.supportsDBTExtraction);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.supportsMetadataExtraction == null ? 0 : this.supportsMetadataExtraction.hashCode());
        result = result * 31 + (this.databaseName == null ? 0 : this.databaseName.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.configSource == null ? 0 : this.configSource.hashCode());
        result = result * 31 + (this.supportsDBTExtraction == null ? 0 : this.supportsDBTExtraction.hashCode());
        result = result * 31 + (this.connectionArguments == null ? 0 : this.connectionArguments.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof DeltaLakeConnection)) {
            return false;
        }
        DeltaLakeConnection rhs = (DeltaLakeConnection)other;
        return (this.supportsMetadataExtraction == rhs.supportsMetadataExtraction || this.supportsMetadataExtraction != null && this.supportsMetadataExtraction.equals(rhs.supportsMetadataExtraction)) && (this.databaseName == rhs.databaseName || this.databaseName != null && this.databaseName.equals(rhs.databaseName)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.configSource == rhs.configSource || this.configSource != null && this.configSource.equals(rhs.configSource)) && (this.supportsDBTExtraction == rhs.supportsDBTExtraction || this.supportsDBTExtraction != null && this.supportsDBTExtraction.equals(rhs.supportsDBTExtraction)) && (this.connectionArguments == rhs.connectionArguments || this.connectionArguments != null && this.connectionArguments.equals(rhs.connectionArguments));
    }

    public static enum DeltaLakeType {
        DELTA_LAKE("DeltaLake");

        private final String value;
        private static final Map<String, DeltaLakeType> CONSTANTS;

        private DeltaLakeType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static DeltaLakeType fromValue(String value) {
            DeltaLakeType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, DeltaLakeType>();
            for (DeltaLakeType c : DeltaLakeType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

