/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.services.connections.database;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.annotations.MaskedField;
import org.openmetadata.annotations.PasswordField;
import org.openmetadata.schema.services.connections.database.ConnectionArguments;
import org.openmetadata.schema.services.connections.database.ConnectionOptions;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "scheme", "username", "password", "hostPort", "databaseName", "databaseSchema", "sslConfig", "connectionOptions", "connectionArguments", "supportsMetadataExtraction", "supportsDBTExtraction", "supportsProfiler", "supportsQueryComment"})
public class DorisConnection {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Service type.")
    private DorisType type = DorisType.fromValue("Doris");
    @JsonProperty(value="scheme")
    @JsonPropertyDescription(value="SQLAlchemy driver scheme options.")
    private DorisScheme scheme = DorisScheme.fromValue("doris");
    @JsonProperty(value="username")
    @JsonPropertyDescription(value="Username to connect to Doris. This user should have privileges to read all the metadata in Doris.")
    @NotNull
    private String username;
    @JsonProperty(value="password")
    @JsonPropertyDescription(value="Password to connect to Doris.")
    @PasswordField
    private String password;
    @JsonProperty(value="hostPort")
    @JsonPropertyDescription(value="Host and port of the Doris service.")
    @NotNull
    private String hostPort;
    @JsonProperty(value="databaseName")
    @JsonPropertyDescription(value="Optional name to give to the database in OpenMetadata. If left blank, we will use default as the database name.")
    private String databaseName;
    @JsonProperty(value="databaseSchema")
    @JsonPropertyDescription(value="Database Schema of the data source. This is optional parameter, if you would like to restrict the metadata reading to a single schema. When left blank, OpenMetadata Ingestion attempts to scan all the schemas.")
    private String databaseSchema;
    @JsonProperty(value="sslConfig")
    @JsonPropertyDescription(value="Client SSL configuration")
    @MaskedField
    private Object sslConfig;
    @JsonProperty(value="connectionOptions")
    @JsonPropertyDescription(value="Additional connection options to build the URL that can be sent to service during the connection.")
    @Valid
    private ConnectionOptions connectionOptions;
    @JsonProperty(value="connectionArguments")
    @JsonPropertyDescription(value="Additional connection arguments such as security or protocol configs that can be sent to service during connection.")
    @Valid
    private ConnectionArguments connectionArguments;
    @JsonProperty(value="supportsMetadataExtraction")
    @JsonPropertyDescription(value="Supports Metadata Extraction.")
    private Boolean supportsMetadataExtraction = true;
    @JsonProperty(value="supportsDBTExtraction")
    @JsonPropertyDescription(value="Supports DBT Extraction.")
    private Boolean supportsDBTExtraction = true;
    @JsonProperty(value="supportsProfiler")
    @JsonPropertyDescription(value="Supports Profiler")
    private Boolean supportsProfiler = true;
    @JsonProperty(value="supportsQueryComment")
    @JsonPropertyDescription(value="For Database Services using SQLAlchemy, True to enable running a comment for all queries run from OpenMetadata.")
    private Boolean supportsQueryComment = true;

    @JsonProperty(value="type")
    public DorisType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(DorisType type) {
        this.type = type;
    }

    public DorisConnection withType(DorisType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="scheme")
    public DorisScheme getScheme() {
        return this.scheme;
    }

    @JsonProperty(value="scheme")
    public void setScheme(DorisScheme scheme) {
        this.scheme = scheme;
    }

    public DorisConnection withScheme(DorisScheme scheme) {
        this.scheme = scheme;
        return this;
    }

    @JsonProperty(value="username")
    public String getUsername() {
        return this.username;
    }

    @JsonProperty(value="username")
    public void setUsername(String username) {
        this.username = username;
    }

    public DorisConnection withUsername(String username) {
        this.username = username;
        return this;
    }

    @JsonProperty(value="password")
    @PasswordField
    public String getPassword() {
        return this.password;
    }

    @JsonProperty(value="password")
    @PasswordField
    public void setPassword(String password) {
        this.password = password;
    }

    public DorisConnection withPassword(String password) {
        this.password = password;
        return this;
    }

    @JsonProperty(value="hostPort")
    public String getHostPort() {
        return this.hostPort;
    }

    @JsonProperty(value="hostPort")
    public void setHostPort(String hostPort) {
        this.hostPort = hostPort;
    }

    public DorisConnection withHostPort(String hostPort) {
        this.hostPort = hostPort;
        return this;
    }

    @JsonProperty(value="databaseName")
    public String getDatabaseName() {
        return this.databaseName;
    }

    @JsonProperty(value="databaseName")
    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public DorisConnection withDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    @JsonProperty(value="databaseSchema")
    public String getDatabaseSchema() {
        return this.databaseSchema;
    }

    @JsonProperty(value="databaseSchema")
    public void setDatabaseSchema(String databaseSchema) {
        this.databaseSchema = databaseSchema;
    }

    public DorisConnection withDatabaseSchema(String databaseSchema) {
        this.databaseSchema = databaseSchema;
        return this;
    }

    @JsonProperty(value="sslConfig")
    @MaskedField
    public Object getSslConfig() {
        return this.sslConfig;
    }

    @JsonProperty(value="sslConfig")
    @MaskedField
    public void setSslConfig(Object sslConfig) {
        this.sslConfig = sslConfig;
    }

    public DorisConnection withSslConfig(Object sslConfig) {
        this.sslConfig = sslConfig;
        return this;
    }

    @JsonProperty(value="connectionOptions")
    public ConnectionOptions getConnectionOptions() {
        return this.connectionOptions;
    }

    @JsonProperty(value="connectionOptions")
    public void setConnectionOptions(ConnectionOptions connectionOptions) {
        this.connectionOptions = connectionOptions;
    }

    public DorisConnection withConnectionOptions(ConnectionOptions connectionOptions) {
        this.connectionOptions = connectionOptions;
        return this;
    }

    @JsonProperty(value="connectionArguments")
    public ConnectionArguments getConnectionArguments() {
        return this.connectionArguments;
    }

    @JsonProperty(value="connectionArguments")
    public void setConnectionArguments(ConnectionArguments connectionArguments) {
        this.connectionArguments = connectionArguments;
    }

    public DorisConnection withConnectionArguments(ConnectionArguments connectionArguments) {
        this.connectionArguments = connectionArguments;
        return this;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public Boolean getSupportsMetadataExtraction() {
        return this.supportsMetadataExtraction;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public void setSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
    }

    public DorisConnection withSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
        return this;
    }

    @JsonProperty(value="supportsDBTExtraction")
    public Boolean getSupportsDBTExtraction() {
        return this.supportsDBTExtraction;
    }

    @JsonProperty(value="supportsDBTExtraction")
    public void setSupportsDBTExtraction(Boolean supportsDBTExtraction) {
        this.supportsDBTExtraction = supportsDBTExtraction;
    }

    public DorisConnection withSupportsDBTExtraction(Boolean supportsDBTExtraction) {
        this.supportsDBTExtraction = supportsDBTExtraction;
        return this;
    }

    @JsonProperty(value="supportsProfiler")
    public Boolean getSupportsProfiler() {
        return this.supportsProfiler;
    }

    @JsonProperty(value="supportsProfiler")
    public void setSupportsProfiler(Boolean supportsProfiler) {
        this.supportsProfiler = supportsProfiler;
    }

    public DorisConnection withSupportsProfiler(Boolean supportsProfiler) {
        this.supportsProfiler = supportsProfiler;
        return this;
    }

    @JsonProperty(value="supportsQueryComment")
    public Boolean getSupportsQueryComment() {
        return this.supportsQueryComment;
    }

    @JsonProperty(value="supportsQueryComment")
    public void setSupportsQueryComment(Boolean supportsQueryComment) {
        this.supportsQueryComment = supportsQueryComment;
    }

    public DorisConnection withSupportsQueryComment(Boolean supportsQueryComment) {
        this.supportsQueryComment = supportsQueryComment;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DorisConnection.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("scheme");
        sb.append('=');
        sb.append(this.scheme == null ? "<null>" : this.scheme);
        sb.append(',');
        sb.append("username");
        sb.append('=');
        sb.append(this.username == null ? "<null>" : this.username);
        sb.append(',');
        sb.append("password");
        sb.append('=');
        sb.append(this.password == null ? "<null>" : this.password);
        sb.append(',');
        sb.append("hostPort");
        sb.append('=');
        sb.append(this.hostPort == null ? "<null>" : this.hostPort);
        sb.append(',');
        sb.append("databaseName");
        sb.append('=');
        sb.append(this.databaseName == null ? "<null>" : this.databaseName);
        sb.append(',');
        sb.append("databaseSchema");
        sb.append('=');
        sb.append(this.databaseSchema == null ? "<null>" : this.databaseSchema);
        sb.append(',');
        sb.append("sslConfig");
        sb.append('=');
        sb.append(this.sslConfig == null ? "<null>" : this.sslConfig);
        sb.append(',');
        sb.append("connectionOptions");
        sb.append('=');
        sb.append(this.connectionOptions == null ? "<null>" : this.connectionOptions);
        sb.append(',');
        sb.append("connectionArguments");
        sb.append('=');
        sb.append(this.connectionArguments == null ? "<null>" : this.connectionArguments);
        sb.append(',');
        sb.append("supportsMetadataExtraction");
        sb.append('=');
        sb.append(this.supportsMetadataExtraction == null ? "<null>" : this.supportsMetadataExtraction);
        sb.append(',');
        sb.append("supportsDBTExtraction");
        sb.append('=');
        sb.append(this.supportsDBTExtraction == null ? "<null>" : this.supportsDBTExtraction);
        sb.append(',');
        sb.append("supportsProfiler");
        sb.append('=');
        sb.append(this.supportsProfiler == null ? "<null>" : this.supportsProfiler);
        sb.append(',');
        sb.append("supportsQueryComment");
        sb.append('=');
        sb.append(this.supportsQueryComment == null ? "<null>" : this.supportsQueryComment);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.databaseSchema == null ? 0 : this.databaseSchema.hashCode());
        result = result * 31 + (this.supportsMetadataExtraction == null ? 0 : this.supportsMetadataExtraction.hashCode());
        result = result * 31 + (this.scheme == null ? 0 : this.scheme.hashCode());
        result = result * 31 + (this.databaseName == null ? 0 : this.databaseName.hashCode());
        result = result * 31 + (this.sslConfig == null ? 0 : this.sslConfig.hashCode());
        result = result * 31 + (this.supportsProfiler == null ? 0 : this.supportsProfiler.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.supportsDBTExtraction == null ? 0 : this.supportsDBTExtraction.hashCode());
        result = result * 31 + (this.connectionArguments == null ? 0 : this.connectionArguments.hashCode());
        result = result * 31 + (this.password == null ? 0 : this.password.hashCode());
        result = result * 31 + (this.connectionOptions == null ? 0 : this.connectionOptions.hashCode());
        result = result * 31 + (this.hostPort == null ? 0 : this.hostPort.hashCode());
        result = result * 31 + (this.supportsQueryComment == null ? 0 : this.supportsQueryComment.hashCode());
        result = result * 31 + (this.username == null ? 0 : this.username.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof DorisConnection)) {
            return false;
        }
        DorisConnection rhs = (DorisConnection)other;
        return (this.databaseSchema == rhs.databaseSchema || this.databaseSchema != null && this.databaseSchema.equals(rhs.databaseSchema)) && (this.supportsMetadataExtraction == rhs.supportsMetadataExtraction || this.supportsMetadataExtraction != null && this.supportsMetadataExtraction.equals(rhs.supportsMetadataExtraction)) && (this.scheme == rhs.scheme || this.scheme != null && this.scheme.equals((Object)rhs.scheme)) && (this.databaseName == rhs.databaseName || this.databaseName != null && this.databaseName.equals(rhs.databaseName)) && (this.sslConfig == rhs.sslConfig || this.sslConfig != null && this.sslConfig.equals(rhs.sslConfig)) && (this.supportsProfiler == rhs.supportsProfiler || this.supportsProfiler != null && this.supportsProfiler.equals(rhs.supportsProfiler)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.supportsDBTExtraction == rhs.supportsDBTExtraction || this.supportsDBTExtraction != null && this.supportsDBTExtraction.equals(rhs.supportsDBTExtraction)) && (this.connectionArguments == rhs.connectionArguments || this.connectionArguments != null && this.connectionArguments.equals(rhs.connectionArguments)) && (this.password == rhs.password || this.password != null && this.password.equals(rhs.password)) && (this.connectionOptions == rhs.connectionOptions || this.connectionOptions != null && this.connectionOptions.equals(rhs.connectionOptions)) && (this.hostPort == rhs.hostPort || this.hostPort != null && this.hostPort.equals(rhs.hostPort)) && (this.supportsQueryComment == rhs.supportsQueryComment || this.supportsQueryComment != null && this.supportsQueryComment.equals(rhs.supportsQueryComment)) && (this.username == rhs.username || this.username != null && this.username.equals(rhs.username));
    }

    public static enum DorisType {
        DORIS("Doris");

        private final String value;
        private static final Map<String, DorisType> CONSTANTS;

        private DorisType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static DorisType fromValue(String value) {
            DorisType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, DorisType>();
            for (DorisType c : DorisType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum DorisScheme {
        DORIS("doris");

        private final String value;
        private static final Map<String, DorisScheme> CONSTANTS;

        private DorisScheme(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static DorisScheme fromValue(String value) {
            DorisScheme constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, DorisScheme>();
            for (DorisScheme c : DorisScheme.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

