/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.services.connections.database;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.services.connections.database.iceberg.IcebergCatalog;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "catalog", "ownershipProperty", "supportsMetadataExtraction"})
public class IcebergConnection {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Service type.")
    private IcebergType type = IcebergType.fromValue("Iceberg");
    @JsonProperty(value="catalog")
    @JsonPropertyDescription(value="Iceberg Catalog configuration.")
    @Valid
    @NotNull
    private IcebergCatalog catalog;
    @JsonProperty(value="ownershipProperty")
    @JsonPropertyDescription(value="Table property to look for the Owner.")
    private String ownershipProperty = "owner";
    @JsonProperty(value="supportsMetadataExtraction")
    @JsonPropertyDescription(value="Supports Metadata Extraction.")
    private Boolean supportsMetadataExtraction = true;

    @JsonProperty(value="type")
    public IcebergType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(IcebergType type) {
        this.type = type;
    }

    public IcebergConnection withType(IcebergType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="catalog")
    public IcebergCatalog getCatalog() {
        return this.catalog;
    }

    @JsonProperty(value="catalog")
    public void setCatalog(IcebergCatalog catalog) {
        this.catalog = catalog;
    }

    public IcebergConnection withCatalog(IcebergCatalog catalog) {
        this.catalog = catalog;
        return this;
    }

    @JsonProperty(value="ownershipProperty")
    public String getOwnershipProperty() {
        return this.ownershipProperty;
    }

    @JsonProperty(value="ownershipProperty")
    public void setOwnershipProperty(String ownershipProperty) {
        this.ownershipProperty = ownershipProperty;
    }

    public IcebergConnection withOwnershipProperty(String ownershipProperty) {
        this.ownershipProperty = ownershipProperty;
        return this;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public Boolean getSupportsMetadataExtraction() {
        return this.supportsMetadataExtraction;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public void setSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
    }

    public IcebergConnection withSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(IcebergConnection.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("catalog");
        sb.append('=');
        sb.append(this.catalog == null ? "<null>" : this.catalog);
        sb.append(',');
        sb.append("ownershipProperty");
        sb.append('=');
        sb.append(this.ownershipProperty == null ? "<null>" : this.ownershipProperty);
        sb.append(',');
        sb.append("supportsMetadataExtraction");
        sb.append('=');
        sb.append(this.supportsMetadataExtraction == null ? "<null>" : this.supportsMetadataExtraction);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.ownershipProperty == null ? 0 : this.ownershipProperty.hashCode());
        result = result * 31 + (this.supportsMetadataExtraction == null ? 0 : this.supportsMetadataExtraction.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.catalog == null ? 0 : this.catalog.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof IcebergConnection)) {
            return false;
        }
        IcebergConnection rhs = (IcebergConnection)other;
        return (this.ownershipProperty == rhs.ownershipProperty || this.ownershipProperty != null && this.ownershipProperty.equals(rhs.ownershipProperty)) && (this.supportsMetadataExtraction == rhs.supportsMetadataExtraction || this.supportsMetadataExtraction != null && this.supportsMetadataExtraction.equals(rhs.supportsMetadataExtraction)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.catalog == rhs.catalog || this.catalog != null && this.catalog.equals(rhs.catalog));
    }

    public static enum IcebergType {
        ICEBERG("Iceberg");

        private final String value;
        private static final Map<String, IcebergType> CONSTANTS;

        private IcebergType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static IcebergType fromValue(String value) {
            IcebergType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, IcebergType>();
            for (IcebergType c : IcebergType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

