/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.services.connections.database;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.openmetadata.annotations.PasswordField;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "username", "password", "serverHost", "datatables", "dataTablesCustomFilter", "reports", "reportsCustomFilter", "dataflows", "dataflowsCustomFilter"})
public class SASConnection {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Service type.")
    private SasType type = SasType.fromValue("SAS");
    @JsonProperty(value="username")
    @JsonPropertyDescription(value="Username to connect to SAS Viya.")
    @NotNull
    private String username;
    @JsonProperty(value="password")
    @JsonPropertyDescription(value="Password to connect to SAS Viya")
    @PasswordField
    @NotNull
    private String password;
    @JsonProperty(value="serverHost")
    @JsonPropertyDescription(value="Hostname of SAS Viya deployment.")
    @NotNull
    private URI serverHost;
    @JsonProperty(value="datatables")
    @JsonPropertyDescription(value="Enable datatables for ingestion")
    private Boolean datatables = true;
    @JsonProperty(value="dataTablesCustomFilter")
    @JsonPropertyDescription(value="Custom filter for datatables")
    private Object dataTablesCustomFilter;
    @JsonProperty(value="reports")
    @JsonPropertyDescription(value="Enable report for ingestion")
    private Boolean reports = false;
    @JsonProperty(value="reportsCustomFilter")
    @JsonPropertyDescription(value="Custom filter for reports")
    private Object reportsCustomFilter;
    @JsonProperty(value="dataflows")
    @JsonPropertyDescription(value="Enable dataflow for ingestion")
    private Boolean dataflows = false;
    @JsonProperty(value="dataflowsCustomFilter")
    @JsonPropertyDescription(value="Custom filter for dataflows")
    private Object dataflowsCustomFilter;

    @JsonProperty(value="type")
    public SasType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(SasType type) {
        this.type = type;
    }

    public SASConnection withType(SasType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="username")
    public String getUsername() {
        return this.username;
    }

    @JsonProperty(value="username")
    public void setUsername(String username) {
        this.username = username;
    }

    public SASConnection withUsername(String username) {
        this.username = username;
        return this;
    }

    @JsonProperty(value="password")
    @PasswordField
    public String getPassword() {
        return this.password;
    }

    @JsonProperty(value="password")
    @PasswordField
    public void setPassword(String password) {
        this.password = password;
    }

    public SASConnection withPassword(String password) {
        this.password = password;
        return this;
    }

    @JsonProperty(value="serverHost")
    public URI getServerHost() {
        return this.serverHost;
    }

    @JsonProperty(value="serverHost")
    public void setServerHost(URI serverHost) {
        this.serverHost = serverHost;
    }

    public SASConnection withServerHost(URI serverHost) {
        this.serverHost = serverHost;
        return this;
    }

    @JsonProperty(value="datatables")
    public Boolean getDatatables() {
        return this.datatables;
    }

    @JsonProperty(value="datatables")
    public void setDatatables(Boolean datatables) {
        this.datatables = datatables;
    }

    public SASConnection withDatatables(Boolean datatables) {
        this.datatables = datatables;
        return this;
    }

    @JsonProperty(value="dataTablesCustomFilter")
    public Object getDataTablesCustomFilter() {
        return this.dataTablesCustomFilter;
    }

    @JsonProperty(value="dataTablesCustomFilter")
    public void setDataTablesCustomFilter(Object dataTablesCustomFilter) {
        this.dataTablesCustomFilter = dataTablesCustomFilter;
    }

    public SASConnection withDataTablesCustomFilter(Object dataTablesCustomFilter) {
        this.dataTablesCustomFilter = dataTablesCustomFilter;
        return this;
    }

    @JsonProperty(value="reports")
    public Boolean getReports() {
        return this.reports;
    }

    @JsonProperty(value="reports")
    public void setReports(Boolean reports) {
        this.reports = reports;
    }

    public SASConnection withReports(Boolean reports) {
        this.reports = reports;
        return this;
    }

    @JsonProperty(value="reportsCustomFilter")
    public Object getReportsCustomFilter() {
        return this.reportsCustomFilter;
    }

    @JsonProperty(value="reportsCustomFilter")
    public void setReportsCustomFilter(Object reportsCustomFilter) {
        this.reportsCustomFilter = reportsCustomFilter;
    }

    public SASConnection withReportsCustomFilter(Object reportsCustomFilter) {
        this.reportsCustomFilter = reportsCustomFilter;
        return this;
    }

    @JsonProperty(value="dataflows")
    public Boolean getDataflows() {
        return this.dataflows;
    }

    @JsonProperty(value="dataflows")
    public void setDataflows(Boolean dataflows) {
        this.dataflows = dataflows;
    }

    public SASConnection withDataflows(Boolean dataflows) {
        this.dataflows = dataflows;
        return this;
    }

    @JsonProperty(value="dataflowsCustomFilter")
    public Object getDataflowsCustomFilter() {
        return this.dataflowsCustomFilter;
    }

    @JsonProperty(value="dataflowsCustomFilter")
    public void setDataflowsCustomFilter(Object dataflowsCustomFilter) {
        this.dataflowsCustomFilter = dataflowsCustomFilter;
    }

    public SASConnection withDataflowsCustomFilter(Object dataflowsCustomFilter) {
        this.dataflowsCustomFilter = dataflowsCustomFilter;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(SASConnection.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("username");
        sb.append('=');
        sb.append(this.username == null ? "<null>" : this.username);
        sb.append(',');
        sb.append("password");
        sb.append('=');
        sb.append(this.password == null ? "<null>" : this.password);
        sb.append(',');
        sb.append("serverHost");
        sb.append('=');
        sb.append(this.serverHost == null ? "<null>" : this.serverHost);
        sb.append(',');
        sb.append("datatables");
        sb.append('=');
        sb.append(this.datatables == null ? "<null>" : this.datatables);
        sb.append(',');
        sb.append("dataTablesCustomFilter");
        sb.append('=');
        sb.append(this.dataTablesCustomFilter == null ? "<null>" : this.dataTablesCustomFilter);
        sb.append(',');
        sb.append("reports");
        sb.append('=');
        sb.append(this.reports == null ? "<null>" : this.reports);
        sb.append(',');
        sb.append("reportsCustomFilter");
        sb.append('=');
        sb.append(this.reportsCustomFilter == null ? "<null>" : this.reportsCustomFilter);
        sb.append(',');
        sb.append("dataflows");
        sb.append('=');
        sb.append(this.dataflows == null ? "<null>" : this.dataflows);
        sb.append(',');
        sb.append("dataflowsCustomFilter");
        sb.append('=');
        sb.append(this.dataflowsCustomFilter == null ? "<null>" : this.dataflowsCustomFilter);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.reports == null ? 0 : this.reports.hashCode());
        result = result * 31 + (this.password == null ? 0 : this.password.hashCode());
        result = result * 31 + (this.reportsCustomFilter == null ? 0 : this.reportsCustomFilter.hashCode());
        result = result * 31 + (this.datatables == null ? 0 : this.datatables.hashCode());
        result = result * 31 + (this.dataTablesCustomFilter == null ? 0 : this.dataTablesCustomFilter.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.dataflowsCustomFilter == null ? 0 : this.dataflowsCustomFilter.hashCode());
        result = result * 31 + (this.dataflows == null ? 0 : this.dataflows.hashCode());
        result = result * 31 + (this.serverHost == null ? 0 : this.serverHost.hashCode());
        result = result * 31 + (this.username == null ? 0 : this.username.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SASConnection)) {
            return false;
        }
        SASConnection rhs = (SASConnection)other;
        return (this.reports == rhs.reports || this.reports != null && this.reports.equals(rhs.reports)) && (this.password == rhs.password || this.password != null && this.password.equals(rhs.password)) && (this.reportsCustomFilter == rhs.reportsCustomFilter || this.reportsCustomFilter != null && this.reportsCustomFilter.equals(rhs.reportsCustomFilter)) && (this.datatables == rhs.datatables || this.datatables != null && this.datatables.equals(rhs.datatables)) && (this.dataTablesCustomFilter == rhs.dataTablesCustomFilter || this.dataTablesCustomFilter != null && this.dataTablesCustomFilter.equals(rhs.dataTablesCustomFilter)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.dataflowsCustomFilter == rhs.dataflowsCustomFilter || this.dataflowsCustomFilter != null && this.dataflowsCustomFilter.equals(rhs.dataflowsCustomFilter)) && (this.dataflows == rhs.dataflows || this.dataflows != null && this.dataflows.equals(rhs.dataflows)) && (this.serverHost == rhs.serverHost || this.serverHost != null && this.serverHost.equals(rhs.serverHost)) && (this.username == rhs.username || this.username != null && this.username.equals(rhs.username));
    }

    public static enum SasType {
        SAS("SAS");

        private final String value;
        private static final Map<String, SasType> CONSTANTS;

        private SasType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static SasType fromValue(String value) {
            SasType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, SasType>();
            for (SasType c : SasType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

