/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.services.connections.database;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.annotations.MaskedField;
import org.openmetadata.annotations.PasswordField;
import org.openmetadata.schema.services.connections.database.ConnectionArguments;
import org.openmetadata.schema.services.connections.database.ConnectionOptions;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "username", "password", "securityToken", "organizationId", "sobjectName", "databaseName", "salesforceApiVersion", "salesforceDomain", "sslConfig", "connectionOptions", "connectionArguments", "supportsMetadataExtraction"})
public class SalesforceConnection {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Service type.")
    private SalesforceType type = SalesforceType.fromValue("Salesforce");
    @JsonProperty(value="username")
    @JsonPropertyDescription(value="Username to connect to the Salesforce. This user should have privileges to read all the metadata in Redshift.")
    @NotNull
    private String username;
    @JsonProperty(value="password")
    @JsonPropertyDescription(value="Password to connect to the Salesforce.")
    @PasswordField
    private String password;
    @JsonProperty(value="securityToken")
    @JsonPropertyDescription(value="Salesforce Security Token.")
    @PasswordField
    private String securityToken;
    @JsonProperty(value="organizationId")
    @JsonPropertyDescription(value="Salesforce Organization ID is the unique identifier for your Salesforce identity")
    private String organizationId;
    @JsonProperty(value="sobjectName")
    @JsonPropertyDescription(value="Salesforce Object Name.")
    private String sobjectName;
    @JsonProperty(value="databaseName")
    @JsonPropertyDescription(value="Optional name to give to the database in OpenMetadata. If left blank, we will use default as the database name.")
    private String databaseName;
    @JsonProperty(value="salesforceApiVersion")
    @JsonPropertyDescription(value="API version of the Salesforce instance")
    private String salesforceApiVersion = "42.0";
    @JsonProperty(value="salesforceDomain")
    @JsonPropertyDescription(value="Domain of Salesforce instance")
    private String salesforceDomain = "login";
    @JsonProperty(value="sslConfig")
    @JsonPropertyDescription(value="Client SSL configuration")
    @MaskedField
    private Object sslConfig;
    @JsonProperty(value="connectionOptions")
    @JsonPropertyDescription(value="Additional connection options to build the URL that can be sent to service during the connection.")
    @Valid
    private ConnectionOptions connectionOptions;
    @JsonProperty(value="connectionArguments")
    @JsonPropertyDescription(value="Additional connection arguments such as security or protocol configs that can be sent to service during connection.")
    @Valid
    private ConnectionArguments connectionArguments;
    @JsonProperty(value="supportsMetadataExtraction")
    @JsonPropertyDescription(value="Supports Metadata Extraction.")
    private Boolean supportsMetadataExtraction = true;

    @JsonProperty(value="type")
    public SalesforceType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(SalesforceType type) {
        this.type = type;
    }

    public SalesforceConnection withType(SalesforceType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="username")
    public String getUsername() {
        return this.username;
    }

    @JsonProperty(value="username")
    public void setUsername(String username) {
        this.username = username;
    }

    public SalesforceConnection withUsername(String username) {
        this.username = username;
        return this;
    }

    @JsonProperty(value="password")
    @PasswordField
    public String getPassword() {
        return this.password;
    }

    @JsonProperty(value="password")
    @PasswordField
    public void setPassword(String password) {
        this.password = password;
    }

    public SalesforceConnection withPassword(String password) {
        this.password = password;
        return this;
    }

    @JsonProperty(value="securityToken")
    @PasswordField
    public String getSecurityToken() {
        return this.securityToken;
    }

    @JsonProperty(value="securityToken")
    @PasswordField
    public void setSecurityToken(String securityToken) {
        this.securityToken = securityToken;
    }

    public SalesforceConnection withSecurityToken(String securityToken) {
        this.securityToken = securityToken;
        return this;
    }

    @JsonProperty(value="organizationId")
    public String getOrganizationId() {
        return this.organizationId;
    }

    @JsonProperty(value="organizationId")
    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public SalesforceConnection withOrganizationId(String organizationId) {
        this.organizationId = organizationId;
        return this;
    }

    @JsonProperty(value="sobjectName")
    public String getSobjectName() {
        return this.sobjectName;
    }

    @JsonProperty(value="sobjectName")
    public void setSobjectName(String sobjectName) {
        this.sobjectName = sobjectName;
    }

    public SalesforceConnection withSobjectName(String sobjectName) {
        this.sobjectName = sobjectName;
        return this;
    }

    @JsonProperty(value="databaseName")
    public String getDatabaseName() {
        return this.databaseName;
    }

    @JsonProperty(value="databaseName")
    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public SalesforceConnection withDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    @JsonProperty(value="salesforceApiVersion")
    public String getSalesforceApiVersion() {
        return this.salesforceApiVersion;
    }

    @JsonProperty(value="salesforceApiVersion")
    public void setSalesforceApiVersion(String salesforceApiVersion) {
        this.salesforceApiVersion = salesforceApiVersion;
    }

    public SalesforceConnection withSalesforceApiVersion(String salesforceApiVersion) {
        this.salesforceApiVersion = salesforceApiVersion;
        return this;
    }

    @JsonProperty(value="salesforceDomain")
    public String getSalesforceDomain() {
        return this.salesforceDomain;
    }

    @JsonProperty(value="salesforceDomain")
    public void setSalesforceDomain(String salesforceDomain) {
        this.salesforceDomain = salesforceDomain;
    }

    public SalesforceConnection withSalesforceDomain(String salesforceDomain) {
        this.salesforceDomain = salesforceDomain;
        return this;
    }

    @JsonProperty(value="sslConfig")
    @MaskedField
    public Object getSslConfig() {
        return this.sslConfig;
    }

    @JsonProperty(value="sslConfig")
    @MaskedField
    public void setSslConfig(Object sslConfig) {
        this.sslConfig = sslConfig;
    }

    public SalesforceConnection withSslConfig(Object sslConfig) {
        this.sslConfig = sslConfig;
        return this;
    }

    @JsonProperty(value="connectionOptions")
    public ConnectionOptions getConnectionOptions() {
        return this.connectionOptions;
    }

    @JsonProperty(value="connectionOptions")
    public void setConnectionOptions(ConnectionOptions connectionOptions) {
        this.connectionOptions = connectionOptions;
    }

    public SalesforceConnection withConnectionOptions(ConnectionOptions connectionOptions) {
        this.connectionOptions = connectionOptions;
        return this;
    }

    @JsonProperty(value="connectionArguments")
    public ConnectionArguments getConnectionArguments() {
        return this.connectionArguments;
    }

    @JsonProperty(value="connectionArguments")
    public void setConnectionArguments(ConnectionArguments connectionArguments) {
        this.connectionArguments = connectionArguments;
    }

    public SalesforceConnection withConnectionArguments(ConnectionArguments connectionArguments) {
        this.connectionArguments = connectionArguments;
        return this;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public Boolean getSupportsMetadataExtraction() {
        return this.supportsMetadataExtraction;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public void setSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
    }

    public SalesforceConnection withSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(SalesforceConnection.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("username");
        sb.append('=');
        sb.append(this.username == null ? "<null>" : this.username);
        sb.append(',');
        sb.append("password");
        sb.append('=');
        sb.append(this.password == null ? "<null>" : this.password);
        sb.append(',');
        sb.append("securityToken");
        sb.append('=');
        sb.append(this.securityToken == null ? "<null>" : this.securityToken);
        sb.append(',');
        sb.append("organizationId");
        sb.append('=');
        sb.append(this.organizationId == null ? "<null>" : this.organizationId);
        sb.append(',');
        sb.append("sobjectName");
        sb.append('=');
        sb.append(this.sobjectName == null ? "<null>" : this.sobjectName);
        sb.append(',');
        sb.append("databaseName");
        sb.append('=');
        sb.append(this.databaseName == null ? "<null>" : this.databaseName);
        sb.append(',');
        sb.append("salesforceApiVersion");
        sb.append('=');
        sb.append(this.salesforceApiVersion == null ? "<null>" : this.salesforceApiVersion);
        sb.append(',');
        sb.append("salesforceDomain");
        sb.append('=');
        sb.append(this.salesforceDomain == null ? "<null>" : this.salesforceDomain);
        sb.append(',');
        sb.append("sslConfig");
        sb.append('=');
        sb.append(this.sslConfig == null ? "<null>" : this.sslConfig);
        sb.append(',');
        sb.append("connectionOptions");
        sb.append('=');
        sb.append(this.connectionOptions == null ? "<null>" : this.connectionOptions);
        sb.append(',');
        sb.append("connectionArguments");
        sb.append('=');
        sb.append(this.connectionArguments == null ? "<null>" : this.connectionArguments);
        sb.append(',');
        sb.append("supportsMetadataExtraction");
        sb.append('=');
        sb.append(this.supportsMetadataExtraction == null ? "<null>" : this.supportsMetadataExtraction);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.supportsMetadataExtraction == null ? 0 : this.supportsMetadataExtraction.hashCode());
        result = result * 31 + (this.databaseName == null ? 0 : this.databaseName.hashCode());
        result = result * 31 + (this.sslConfig == null ? 0 : this.sslConfig.hashCode());
        result = result * 31 + (this.salesforceApiVersion == null ? 0 : this.salesforceApiVersion.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.sobjectName == null ? 0 : this.sobjectName.hashCode());
        result = result * 31 + (this.salesforceDomain == null ? 0 : this.salesforceDomain.hashCode());
        result = result * 31 + (this.connectionArguments == null ? 0 : this.connectionArguments.hashCode());
        result = result * 31 + (this.securityToken == null ? 0 : this.securityToken.hashCode());
        result = result * 31 + (this.organizationId == null ? 0 : this.organizationId.hashCode());
        result = result * 31 + (this.password == null ? 0 : this.password.hashCode());
        result = result * 31 + (this.connectionOptions == null ? 0 : this.connectionOptions.hashCode());
        result = result * 31 + (this.username == null ? 0 : this.username.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SalesforceConnection)) {
            return false;
        }
        SalesforceConnection rhs = (SalesforceConnection)other;
        return (this.supportsMetadataExtraction == rhs.supportsMetadataExtraction || this.supportsMetadataExtraction != null && this.supportsMetadataExtraction.equals(rhs.supportsMetadataExtraction)) && (this.databaseName == rhs.databaseName || this.databaseName != null && this.databaseName.equals(rhs.databaseName)) && (this.sslConfig == rhs.sslConfig || this.sslConfig != null && this.sslConfig.equals(rhs.sslConfig)) && (this.salesforceApiVersion == rhs.salesforceApiVersion || this.salesforceApiVersion != null && this.salesforceApiVersion.equals(rhs.salesforceApiVersion)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.sobjectName == rhs.sobjectName || this.sobjectName != null && this.sobjectName.equals(rhs.sobjectName)) && (this.salesforceDomain == rhs.salesforceDomain || this.salesforceDomain != null && this.salesforceDomain.equals(rhs.salesforceDomain)) && (this.connectionArguments == rhs.connectionArguments || this.connectionArguments != null && this.connectionArguments.equals(rhs.connectionArguments)) && (this.securityToken == rhs.securityToken || this.securityToken != null && this.securityToken.equals(rhs.securityToken)) && (this.organizationId == rhs.organizationId || this.organizationId != null && this.organizationId.equals(rhs.organizationId)) && (this.password == rhs.password || this.password != null && this.password.equals(rhs.password)) && (this.connectionOptions == rhs.connectionOptions || this.connectionOptions != null && this.connectionOptions.equals(rhs.connectionOptions)) && (this.username == rhs.username || this.username != null && this.username.equals(rhs.username));
    }

    public static enum SalesforceType {
        SALESFORCE("Salesforce");

        private final String value;
        private static final Map<String, SalesforceType> CONSTANTS;

        private SalesforceType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static SalesforceType fromValue(String value) {
            SalesforceType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, SalesforceType>();
            for (SalesforceType c : SalesforceType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

