/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.services.connections.database;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.annotations.PasswordField;
import org.openmetadata.schema.services.connections.database.ConnectionArguments;
import org.openmetadata.schema.services.connections.database.ConnectionOptions;
import org.openmetadata.schema.services.connections.database.SampleDataStorageConfig;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "scheme", "username", "password", "account", "role", "database", "warehouse", "queryTag", "privateKey", "snowflakePrivatekeyPassphrase", "includeTransientTables", "clientSessionKeepAlive", "connectionOptions", "connectionArguments", "supportsMetadataExtraction", "supportsUsageExtraction", "supportsLineageExtraction", "supportsDBTExtraction", "supportsProfiler", "supportsDatabase", "supportsQueryComment", "sampleDataStorageConfig"})
public class SnowflakeConnection {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Service type.")
    private SnowflakeType type = SnowflakeType.fromValue("Snowflake");
    @JsonProperty(value="scheme")
    @JsonPropertyDescription(value="SQLAlchemy driver scheme options.")
    private SnowflakeScheme scheme = SnowflakeScheme.fromValue("snowflake");
    @JsonProperty(value="username")
    @JsonPropertyDescription(value="Username to connect to Snowflake. This user should have privileges to read all the metadata in Snowflake.")
    @NotNull
    private String username;
    @JsonProperty(value="password")
    @JsonPropertyDescription(value="Password to connect to Snowflake.")
    @PasswordField
    private String password;
    @JsonProperty(value="account")
    @JsonPropertyDescription(value="If the Snowflake URL is https://xyz1234.us-east-1.gcp.snowflakecomputing.com, then the account is xyz1234.us-east-1.gcp")
    @NotNull
    private String account;
    @JsonProperty(value="role")
    @JsonPropertyDescription(value="Snowflake Role.")
    private String role;
    @JsonProperty(value="database")
    @JsonPropertyDescription(value="Database of the data source. This is optional parameter, if you would like to restrict the metadata reading to a single database. When left blank, OpenMetadata Ingestion attempts to scan all the databases.")
    private String database;
    @JsonProperty(value="warehouse")
    @JsonPropertyDescription(value="Snowflake warehouse.")
    @NotNull
    private String warehouse;
    @JsonProperty(value="queryTag")
    @JsonPropertyDescription(value="Session query tag used to monitor usage on snowflake. To use a query tag snowflake user should have enough privileges to alter the session.")
    private String queryTag;
    @JsonProperty(value="privateKey")
    @JsonPropertyDescription(value="Connection to Snowflake instance via Private Key")
    @PasswordField
    private String privateKey;
    @JsonProperty(value="snowflakePrivatekeyPassphrase")
    @JsonPropertyDescription(value="Snowflake Passphrase Key used with Private Key")
    @PasswordField
    private String snowflakePrivatekeyPassphrase;
    @JsonProperty(value="includeTransientTables")
    @JsonPropertyDescription(value="Optional configuration for ingestion of TRANSIENT tables, By default, it will skip the TRANSIENT tables.")
    private Boolean includeTransientTables = true;
    @JsonProperty(value="clientSessionKeepAlive")
    @JsonPropertyDescription(value="Optional configuration for ingestion to keep the client session active in case the ingestion process runs for longer durations.")
    private Boolean clientSessionKeepAlive = false;
    @JsonProperty(value="connectionOptions")
    @JsonPropertyDescription(value="Additional connection options to build the URL that can be sent to service during the connection.")
    @Valid
    private ConnectionOptions connectionOptions;
    @JsonProperty(value="connectionArguments")
    @JsonPropertyDescription(value="Additional connection arguments such as security or protocol configs that can be sent to service during connection.")
    @Valid
    private ConnectionArguments connectionArguments;
    @JsonProperty(value="supportsMetadataExtraction")
    @JsonPropertyDescription(value="Supports Metadata Extraction.")
    private Boolean supportsMetadataExtraction = true;
    @JsonProperty(value="supportsUsageExtraction")
    @JsonPropertyDescription(value="Supports Usage Extraction.")
    private Boolean supportsUsageExtraction = true;
    @JsonProperty(value="supportsLineageExtraction")
    @JsonPropertyDescription(value="Supports Lineage Extraction.")
    private Boolean supportsLineageExtraction = true;
    @JsonProperty(value="supportsDBTExtraction")
    @JsonPropertyDescription(value="Supports DBT Extraction.")
    private Boolean supportsDBTExtraction = true;
    @JsonProperty(value="supportsProfiler")
    @JsonPropertyDescription(value="Supports Profiler")
    private Boolean supportsProfiler = true;
    @JsonProperty(value="supportsDatabase")
    @JsonPropertyDescription(value="The source service supports the database concept in its hierarchy")
    private Boolean supportsDatabase = true;
    @JsonProperty(value="supportsQueryComment")
    @JsonPropertyDescription(value="For Database Services using SQLAlchemy, True to enable running a comment for all queries run from OpenMetadata.")
    private Boolean supportsQueryComment = true;
    @JsonProperty(value="sampleDataStorageConfig")
    @JsonPropertyDescription(value="Storage config to store sample data")
    @Valid
    private SampleDataStorageConfig sampleDataStorageConfig;

    @JsonProperty(value="type")
    public SnowflakeType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(SnowflakeType type) {
        this.type = type;
    }

    public SnowflakeConnection withType(SnowflakeType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="scheme")
    public SnowflakeScheme getScheme() {
        return this.scheme;
    }

    @JsonProperty(value="scheme")
    public void setScheme(SnowflakeScheme scheme) {
        this.scheme = scheme;
    }

    public SnowflakeConnection withScheme(SnowflakeScheme scheme) {
        this.scheme = scheme;
        return this;
    }

    @JsonProperty(value="username")
    public String getUsername() {
        return this.username;
    }

    @JsonProperty(value="username")
    public void setUsername(String username) {
        this.username = username;
    }

    public SnowflakeConnection withUsername(String username) {
        this.username = username;
        return this;
    }

    @JsonProperty(value="password")
    @PasswordField
    public String getPassword() {
        return this.password;
    }

    @JsonProperty(value="password")
    @PasswordField
    public void setPassword(String password) {
        this.password = password;
    }

    public SnowflakeConnection withPassword(String password) {
        this.password = password;
        return this;
    }

    @JsonProperty(value="account")
    public String getAccount() {
        return this.account;
    }

    @JsonProperty(value="account")
    public void setAccount(String account) {
        this.account = account;
    }

    public SnowflakeConnection withAccount(String account) {
        this.account = account;
        return this;
    }

    @JsonProperty(value="role")
    public String getRole() {
        return this.role;
    }

    @JsonProperty(value="role")
    public void setRole(String role) {
        this.role = role;
    }

    public SnowflakeConnection withRole(String role) {
        this.role = role;
        return this;
    }

    @JsonProperty(value="database")
    public String getDatabase() {
        return this.database;
    }

    @JsonProperty(value="database")
    public void setDatabase(String database) {
        this.database = database;
    }

    public SnowflakeConnection withDatabase(String database) {
        this.database = database;
        return this;
    }

    @JsonProperty(value="warehouse")
    public String getWarehouse() {
        return this.warehouse;
    }

    @JsonProperty(value="warehouse")
    public void setWarehouse(String warehouse) {
        this.warehouse = warehouse;
    }

    public SnowflakeConnection withWarehouse(String warehouse) {
        this.warehouse = warehouse;
        return this;
    }

    @JsonProperty(value="queryTag")
    public String getQueryTag() {
        return this.queryTag;
    }

    @JsonProperty(value="queryTag")
    public void setQueryTag(String queryTag) {
        this.queryTag = queryTag;
    }

    public SnowflakeConnection withQueryTag(String queryTag) {
        this.queryTag = queryTag;
        return this;
    }

    @JsonProperty(value="privateKey")
    @PasswordField
    public String getPrivateKey() {
        return this.privateKey;
    }

    @JsonProperty(value="privateKey")
    @PasswordField
    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public SnowflakeConnection withPrivateKey(String privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    @JsonProperty(value="snowflakePrivatekeyPassphrase")
    @PasswordField
    public String getSnowflakePrivatekeyPassphrase() {
        return this.snowflakePrivatekeyPassphrase;
    }

    @JsonProperty(value="snowflakePrivatekeyPassphrase")
    @PasswordField
    public void setSnowflakePrivatekeyPassphrase(String snowflakePrivatekeyPassphrase) {
        this.snowflakePrivatekeyPassphrase = snowflakePrivatekeyPassphrase;
    }

    public SnowflakeConnection withSnowflakePrivatekeyPassphrase(String snowflakePrivatekeyPassphrase) {
        this.snowflakePrivatekeyPassphrase = snowflakePrivatekeyPassphrase;
        return this;
    }

    @JsonProperty(value="includeTransientTables")
    public Boolean getIncludeTransientTables() {
        return this.includeTransientTables;
    }

    @JsonProperty(value="includeTransientTables")
    public void setIncludeTransientTables(Boolean includeTransientTables) {
        this.includeTransientTables = includeTransientTables;
    }

    public SnowflakeConnection withIncludeTransientTables(Boolean includeTransientTables) {
        this.includeTransientTables = includeTransientTables;
        return this;
    }

    @JsonProperty(value="clientSessionKeepAlive")
    public Boolean getClientSessionKeepAlive() {
        return this.clientSessionKeepAlive;
    }

    @JsonProperty(value="clientSessionKeepAlive")
    public void setClientSessionKeepAlive(Boolean clientSessionKeepAlive) {
        this.clientSessionKeepAlive = clientSessionKeepAlive;
    }

    public SnowflakeConnection withClientSessionKeepAlive(Boolean clientSessionKeepAlive) {
        this.clientSessionKeepAlive = clientSessionKeepAlive;
        return this;
    }

    @JsonProperty(value="connectionOptions")
    public ConnectionOptions getConnectionOptions() {
        return this.connectionOptions;
    }

    @JsonProperty(value="connectionOptions")
    public void setConnectionOptions(ConnectionOptions connectionOptions) {
        this.connectionOptions = connectionOptions;
    }

    public SnowflakeConnection withConnectionOptions(ConnectionOptions connectionOptions) {
        this.connectionOptions = connectionOptions;
        return this;
    }

    @JsonProperty(value="connectionArguments")
    public ConnectionArguments getConnectionArguments() {
        return this.connectionArguments;
    }

    @JsonProperty(value="connectionArguments")
    public void setConnectionArguments(ConnectionArguments connectionArguments) {
        this.connectionArguments = connectionArguments;
    }

    public SnowflakeConnection withConnectionArguments(ConnectionArguments connectionArguments) {
        this.connectionArguments = connectionArguments;
        return this;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public Boolean getSupportsMetadataExtraction() {
        return this.supportsMetadataExtraction;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public void setSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
    }

    public SnowflakeConnection withSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
        return this;
    }

    @JsonProperty(value="supportsUsageExtraction")
    public Boolean getSupportsUsageExtraction() {
        return this.supportsUsageExtraction;
    }

    @JsonProperty(value="supportsUsageExtraction")
    public void setSupportsUsageExtraction(Boolean supportsUsageExtraction) {
        this.supportsUsageExtraction = supportsUsageExtraction;
    }

    public SnowflakeConnection withSupportsUsageExtraction(Boolean supportsUsageExtraction) {
        this.supportsUsageExtraction = supportsUsageExtraction;
        return this;
    }

    @JsonProperty(value="supportsLineageExtraction")
    public Boolean getSupportsLineageExtraction() {
        return this.supportsLineageExtraction;
    }

    @JsonProperty(value="supportsLineageExtraction")
    public void setSupportsLineageExtraction(Boolean supportsLineageExtraction) {
        this.supportsLineageExtraction = supportsLineageExtraction;
    }

    public SnowflakeConnection withSupportsLineageExtraction(Boolean supportsLineageExtraction) {
        this.supportsLineageExtraction = supportsLineageExtraction;
        return this;
    }

    @JsonProperty(value="supportsDBTExtraction")
    public Boolean getSupportsDBTExtraction() {
        return this.supportsDBTExtraction;
    }

    @JsonProperty(value="supportsDBTExtraction")
    public void setSupportsDBTExtraction(Boolean supportsDBTExtraction) {
        this.supportsDBTExtraction = supportsDBTExtraction;
    }

    public SnowflakeConnection withSupportsDBTExtraction(Boolean supportsDBTExtraction) {
        this.supportsDBTExtraction = supportsDBTExtraction;
        return this;
    }

    @JsonProperty(value="supportsProfiler")
    public Boolean getSupportsProfiler() {
        return this.supportsProfiler;
    }

    @JsonProperty(value="supportsProfiler")
    public void setSupportsProfiler(Boolean supportsProfiler) {
        this.supportsProfiler = supportsProfiler;
    }

    public SnowflakeConnection withSupportsProfiler(Boolean supportsProfiler) {
        this.supportsProfiler = supportsProfiler;
        return this;
    }

    @JsonProperty(value="supportsDatabase")
    public Boolean getSupportsDatabase() {
        return this.supportsDatabase;
    }

    @JsonProperty(value="supportsDatabase")
    public void setSupportsDatabase(Boolean supportsDatabase) {
        this.supportsDatabase = supportsDatabase;
    }

    public SnowflakeConnection withSupportsDatabase(Boolean supportsDatabase) {
        this.supportsDatabase = supportsDatabase;
        return this;
    }

    @JsonProperty(value="supportsQueryComment")
    public Boolean getSupportsQueryComment() {
        return this.supportsQueryComment;
    }

    @JsonProperty(value="supportsQueryComment")
    public void setSupportsQueryComment(Boolean supportsQueryComment) {
        this.supportsQueryComment = supportsQueryComment;
    }

    public SnowflakeConnection withSupportsQueryComment(Boolean supportsQueryComment) {
        this.supportsQueryComment = supportsQueryComment;
        return this;
    }

    @JsonProperty(value="sampleDataStorageConfig")
    public SampleDataStorageConfig getSampleDataStorageConfig() {
        return this.sampleDataStorageConfig;
    }

    @JsonProperty(value="sampleDataStorageConfig")
    public void setSampleDataStorageConfig(SampleDataStorageConfig sampleDataStorageConfig) {
        this.sampleDataStorageConfig = sampleDataStorageConfig;
    }

    public SnowflakeConnection withSampleDataStorageConfig(SampleDataStorageConfig sampleDataStorageConfig) {
        this.sampleDataStorageConfig = sampleDataStorageConfig;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(SnowflakeConnection.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("scheme");
        sb.append('=');
        sb.append(this.scheme == null ? "<null>" : this.scheme);
        sb.append(',');
        sb.append("username");
        sb.append('=');
        sb.append(this.username == null ? "<null>" : this.username);
        sb.append(',');
        sb.append("password");
        sb.append('=');
        sb.append(this.password == null ? "<null>" : this.password);
        sb.append(',');
        sb.append("account");
        sb.append('=');
        sb.append(this.account == null ? "<null>" : this.account);
        sb.append(',');
        sb.append("role");
        sb.append('=');
        sb.append(this.role == null ? "<null>" : this.role);
        sb.append(',');
        sb.append("database");
        sb.append('=');
        sb.append(this.database == null ? "<null>" : this.database);
        sb.append(',');
        sb.append("warehouse");
        sb.append('=');
        sb.append(this.warehouse == null ? "<null>" : this.warehouse);
        sb.append(',');
        sb.append("queryTag");
        sb.append('=');
        sb.append(this.queryTag == null ? "<null>" : this.queryTag);
        sb.append(',');
        sb.append("privateKey");
        sb.append('=');
        sb.append(this.privateKey == null ? "<null>" : this.privateKey);
        sb.append(',');
        sb.append("snowflakePrivatekeyPassphrase");
        sb.append('=');
        sb.append(this.snowflakePrivatekeyPassphrase == null ? "<null>" : this.snowflakePrivatekeyPassphrase);
        sb.append(',');
        sb.append("includeTransientTables");
        sb.append('=');
        sb.append(this.includeTransientTables == null ? "<null>" : this.includeTransientTables);
        sb.append(',');
        sb.append("clientSessionKeepAlive");
        sb.append('=');
        sb.append(this.clientSessionKeepAlive == null ? "<null>" : this.clientSessionKeepAlive);
        sb.append(',');
        sb.append("connectionOptions");
        sb.append('=');
        sb.append(this.connectionOptions == null ? "<null>" : this.connectionOptions);
        sb.append(',');
        sb.append("connectionArguments");
        sb.append('=');
        sb.append(this.connectionArguments == null ? "<null>" : this.connectionArguments);
        sb.append(',');
        sb.append("supportsMetadataExtraction");
        sb.append('=');
        sb.append(this.supportsMetadataExtraction == null ? "<null>" : this.supportsMetadataExtraction);
        sb.append(',');
        sb.append("supportsUsageExtraction");
        sb.append('=');
        sb.append(this.supportsUsageExtraction == null ? "<null>" : this.supportsUsageExtraction);
        sb.append(',');
        sb.append("supportsLineageExtraction");
        sb.append('=');
        sb.append(this.supportsLineageExtraction == null ? "<null>" : this.supportsLineageExtraction);
        sb.append(',');
        sb.append("supportsDBTExtraction");
        sb.append('=');
        sb.append(this.supportsDBTExtraction == null ? "<null>" : this.supportsDBTExtraction);
        sb.append(',');
        sb.append("supportsProfiler");
        sb.append('=');
        sb.append(this.supportsProfiler == null ? "<null>" : this.supportsProfiler);
        sb.append(',');
        sb.append("supportsDatabase");
        sb.append('=');
        sb.append(this.supportsDatabase == null ? "<null>" : this.supportsDatabase);
        sb.append(',');
        sb.append("supportsQueryComment");
        sb.append('=');
        sb.append(this.supportsQueryComment == null ? "<null>" : this.supportsQueryComment);
        sb.append(',');
        sb.append("sampleDataStorageConfig");
        sb.append('=');
        sb.append(this.sampleDataStorageConfig == null ? "<null>" : this.sampleDataStorageConfig);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.includeTransientTables == null ? 0 : this.includeTransientTables.hashCode());
        result = result * 31 + (this.supportsMetadataExtraction == null ? 0 : this.supportsMetadataExtraction.hashCode());
        result = result * 31 + (this.role == null ? 0 : this.role.hashCode());
        result = result * 31 + (this.scheme == null ? 0 : this.scheme.hashCode());
        result = result * 31 + (this.queryTag == null ? 0 : this.queryTag.hashCode());
        result = result * 31 + (this.supportsProfiler == null ? 0 : this.supportsProfiler.hashCode());
        result = result * 31 + (this.sampleDataStorageConfig == null ? 0 : this.sampleDataStorageConfig.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.warehouse == null ? 0 : this.warehouse.hashCode());
        result = result * 31 + (this.supportsUsageExtraction == null ? 0 : this.supportsUsageExtraction.hashCode());
        result = result * 31 + (this.supportsDBTExtraction == null ? 0 : this.supportsDBTExtraction.hashCode());
        result = result * 31 + (this.connectionArguments == null ? 0 : this.connectionArguments.hashCode());
        result = result * 31 + (this.supportsDatabase == null ? 0 : this.supportsDatabase.hashCode());
        result = result * 31 + (this.privateKey == null ? 0 : this.privateKey.hashCode());
        result = result * 31 + (this.clientSessionKeepAlive == null ? 0 : this.clientSessionKeepAlive.hashCode());
        result = result * 31 + (this.supportsLineageExtraction == null ? 0 : this.supportsLineageExtraction.hashCode());
        result = result * 31 + (this.password == null ? 0 : this.password.hashCode());
        result = result * 31 + (this.database == null ? 0 : this.database.hashCode());
        result = result * 31 + (this.snowflakePrivatekeyPassphrase == null ? 0 : this.snowflakePrivatekeyPassphrase.hashCode());
        result = result * 31 + (this.connectionOptions == null ? 0 : this.connectionOptions.hashCode());
        result = result * 31 + (this.supportsQueryComment == null ? 0 : this.supportsQueryComment.hashCode());
        result = result * 31 + (this.account == null ? 0 : this.account.hashCode());
        result = result * 31 + (this.username == null ? 0 : this.username.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SnowflakeConnection)) {
            return false;
        }
        SnowflakeConnection rhs = (SnowflakeConnection)other;
        return (this.includeTransientTables == rhs.includeTransientTables || this.includeTransientTables != null && this.includeTransientTables.equals(rhs.includeTransientTables)) && (this.supportsMetadataExtraction == rhs.supportsMetadataExtraction || this.supportsMetadataExtraction != null && this.supportsMetadataExtraction.equals(rhs.supportsMetadataExtraction)) && (this.role == rhs.role || this.role != null && this.role.equals(rhs.role)) && (this.scheme == rhs.scheme || this.scheme != null && this.scheme.equals((Object)rhs.scheme)) && (this.queryTag == rhs.queryTag || this.queryTag != null && this.queryTag.equals(rhs.queryTag)) && (this.supportsProfiler == rhs.supportsProfiler || this.supportsProfiler != null && this.supportsProfiler.equals(rhs.supportsProfiler)) && (this.sampleDataStorageConfig == rhs.sampleDataStorageConfig || this.sampleDataStorageConfig != null && this.sampleDataStorageConfig.equals(rhs.sampleDataStorageConfig)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.warehouse == rhs.warehouse || this.warehouse != null && this.warehouse.equals(rhs.warehouse)) && (this.supportsUsageExtraction == rhs.supportsUsageExtraction || this.supportsUsageExtraction != null && this.supportsUsageExtraction.equals(rhs.supportsUsageExtraction)) && (this.supportsDBTExtraction == rhs.supportsDBTExtraction || this.supportsDBTExtraction != null && this.supportsDBTExtraction.equals(rhs.supportsDBTExtraction)) && (this.connectionArguments == rhs.connectionArguments || this.connectionArguments != null && this.connectionArguments.equals(rhs.connectionArguments)) && (this.supportsDatabase == rhs.supportsDatabase || this.supportsDatabase != null && this.supportsDatabase.equals(rhs.supportsDatabase)) && (this.privateKey == rhs.privateKey || this.privateKey != null && this.privateKey.equals(rhs.privateKey)) && (this.clientSessionKeepAlive == rhs.clientSessionKeepAlive || this.clientSessionKeepAlive != null && this.clientSessionKeepAlive.equals(rhs.clientSessionKeepAlive)) && (this.supportsLineageExtraction == rhs.supportsLineageExtraction || this.supportsLineageExtraction != null && this.supportsLineageExtraction.equals(rhs.supportsLineageExtraction)) && (this.password == rhs.password || this.password != null && this.password.equals(rhs.password)) && (this.database == rhs.database || this.database != null && this.database.equals(rhs.database)) && (this.snowflakePrivatekeyPassphrase == rhs.snowflakePrivatekeyPassphrase || this.snowflakePrivatekeyPassphrase != null && this.snowflakePrivatekeyPassphrase.equals(rhs.snowflakePrivatekeyPassphrase)) && (this.connectionOptions == rhs.connectionOptions || this.connectionOptions != null && this.connectionOptions.equals(rhs.connectionOptions)) && (this.supportsQueryComment == rhs.supportsQueryComment || this.supportsQueryComment != null && this.supportsQueryComment.equals(rhs.supportsQueryComment)) && (this.account == rhs.account || this.account != null && this.account.equals(rhs.account)) && (this.username == rhs.username || this.username != null && this.username.equals(rhs.username));
    }

    public static enum SnowflakeType {
        SNOWFLAKE("Snowflake");

        private final String value;
        private static final Map<String, SnowflakeType> CONSTANTS;

        private SnowflakeType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static SnowflakeType fromValue(String value) {
            SnowflakeType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, SnowflakeType>();
            for (SnowflakeType c : SnowflakeType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum SnowflakeScheme {
        SNOWFLAKE("snowflake");

        private final String value;
        private static final Map<String, SnowflakeScheme> CONSTANTS;

        private SnowflakeScheme(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static SnowflakeScheme fromValue(String value) {
            SnowflakeScheme constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, SnowflakeScheme>();
            for (SnowflakeScheme c : SnowflakeScheme.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

