/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.services.connections.database;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.annotations.PasswordField;
import org.openmetadata.schema.services.connections.database.ConnectionArguments;
import org.openmetadata.schema.services.connections.database.ConnectionOptions;
import org.openmetadata.schema.services.connections.database.SampleDataStorageConfig;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "scheme", "username", "password", "logmech", "logdata", "hostPort", "tmode", "account", "connectionOptions", "connectionArguments", "supportsMetadataExtraction", "supportsProfiler", "supportsQueryComment", "sampleDataStorageConfig"})
public class TeradataConnection {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Service type.")
    private TeradataType type = TeradataType.fromValue("Teradata");
    @JsonProperty(value="scheme")
    @JsonPropertyDescription(value="SQLAlchemy driver scheme options.")
    private TeradataScheme scheme = TeradataScheme.fromValue("teradatasql");
    @JsonProperty(value="username")
    @JsonPropertyDescription(value="Username to connect to Teradata. This user should have privileges to read all the metadata in Teradata.")
    @NotNull
    private String username;
    @JsonProperty(value="password")
    @JsonPropertyDescription(value="Password to connect to Teradata.")
    @PasswordField
    private String password;
    @JsonProperty(value="logmech")
    @JsonPropertyDescription(value="Specifies the logon authentication method. Possible values are TD2 (the default), JWT, LDAP, KRB5 for Kerberos, or TDNEGO")
    private Logmech logmech = Logmech.fromValue("TD2");
    @JsonProperty(value="logdata")
    @JsonPropertyDescription(value="Specifies additional data needed by a logon mechanism, such as a secure token, Distinguished Name, or a domain/realm name. LOGDATA values are specific to each logon mechanism.")
    private String logdata;
    @JsonProperty(value="hostPort")
    @JsonPropertyDescription(value="Host and port of the Teradata service.")
    @NotNull
    private String hostPort;
    @JsonProperty(value="tmode")
    @JsonPropertyDescription(value="Specifies the transaction mode for the connection")
    private Tmode tmode = Tmode.fromValue("DEFAULT");
    @JsonProperty(value="account")
    @JsonPropertyDescription(value="Specifies an account string to override the default account string defined for the database user. Accounts are used by the database for workload management and resource usage monitoring.")
    private String account;
    @JsonProperty(value="connectionOptions")
    @JsonPropertyDescription(value="Additional connection options to build the URL that can be sent to service during the connection.")
    @Valid
    private ConnectionOptions connectionOptions;
    @JsonProperty(value="connectionArguments")
    @JsonPropertyDescription(value="Additional connection arguments such as security or protocol configs that can be sent to service during connection.")
    @Valid
    private ConnectionArguments connectionArguments;
    @JsonProperty(value="supportsMetadataExtraction")
    @JsonPropertyDescription(value="Supports Metadata Extraction.")
    private Boolean supportsMetadataExtraction = true;
    @JsonProperty(value="supportsProfiler")
    @JsonPropertyDescription(value="Supports Profiler")
    private Boolean supportsProfiler = true;
    @JsonProperty(value="supportsQueryComment")
    @JsonPropertyDescription(value="For Database Services using SQLAlchemy, True to enable running a comment for all queries run from OpenMetadata.")
    private Boolean supportsQueryComment = true;
    @JsonProperty(value="sampleDataStorageConfig")
    @JsonPropertyDescription(value="Storage config to store sample data")
    @Valid
    private SampleDataStorageConfig sampleDataStorageConfig;

    @JsonProperty(value="type")
    public TeradataType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(TeradataType type) {
        this.type = type;
    }

    public TeradataConnection withType(TeradataType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="scheme")
    public TeradataScheme getScheme() {
        return this.scheme;
    }

    @JsonProperty(value="scheme")
    public void setScheme(TeradataScheme scheme) {
        this.scheme = scheme;
    }

    public TeradataConnection withScheme(TeradataScheme scheme) {
        this.scheme = scheme;
        return this;
    }

    @JsonProperty(value="username")
    public String getUsername() {
        return this.username;
    }

    @JsonProperty(value="username")
    public void setUsername(String username) {
        this.username = username;
    }

    public TeradataConnection withUsername(String username) {
        this.username = username;
        return this;
    }

    @JsonProperty(value="password")
    @PasswordField
    public String getPassword() {
        return this.password;
    }

    @JsonProperty(value="password")
    @PasswordField
    public void setPassword(String password) {
        this.password = password;
    }

    public TeradataConnection withPassword(String password) {
        this.password = password;
        return this;
    }

    @JsonProperty(value="logmech")
    public Logmech getLogmech() {
        return this.logmech;
    }

    @JsonProperty(value="logmech")
    public void setLogmech(Logmech logmech) {
        this.logmech = logmech;
    }

    public TeradataConnection withLogmech(Logmech logmech) {
        this.logmech = logmech;
        return this;
    }

    @JsonProperty(value="logdata")
    public String getLogdata() {
        return this.logdata;
    }

    @JsonProperty(value="logdata")
    public void setLogdata(String logdata) {
        this.logdata = logdata;
    }

    public TeradataConnection withLogdata(String logdata) {
        this.logdata = logdata;
        return this;
    }

    @JsonProperty(value="hostPort")
    public String getHostPort() {
        return this.hostPort;
    }

    @JsonProperty(value="hostPort")
    public void setHostPort(String hostPort) {
        this.hostPort = hostPort;
    }

    public TeradataConnection withHostPort(String hostPort) {
        this.hostPort = hostPort;
        return this;
    }

    @JsonProperty(value="tmode")
    public Tmode getTmode() {
        return this.tmode;
    }

    @JsonProperty(value="tmode")
    public void setTmode(Tmode tmode) {
        this.tmode = tmode;
    }

    public TeradataConnection withTmode(Tmode tmode) {
        this.tmode = tmode;
        return this;
    }

    @JsonProperty(value="account")
    public String getAccount() {
        return this.account;
    }

    @JsonProperty(value="account")
    public void setAccount(String account) {
        this.account = account;
    }

    public TeradataConnection withAccount(String account) {
        this.account = account;
        return this;
    }

    @JsonProperty(value="connectionOptions")
    public ConnectionOptions getConnectionOptions() {
        return this.connectionOptions;
    }

    @JsonProperty(value="connectionOptions")
    public void setConnectionOptions(ConnectionOptions connectionOptions) {
        this.connectionOptions = connectionOptions;
    }

    public TeradataConnection withConnectionOptions(ConnectionOptions connectionOptions) {
        this.connectionOptions = connectionOptions;
        return this;
    }

    @JsonProperty(value="connectionArguments")
    public ConnectionArguments getConnectionArguments() {
        return this.connectionArguments;
    }

    @JsonProperty(value="connectionArguments")
    public void setConnectionArguments(ConnectionArguments connectionArguments) {
        this.connectionArguments = connectionArguments;
    }

    public TeradataConnection withConnectionArguments(ConnectionArguments connectionArguments) {
        this.connectionArguments = connectionArguments;
        return this;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public Boolean getSupportsMetadataExtraction() {
        return this.supportsMetadataExtraction;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public void setSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
    }

    public TeradataConnection withSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
        return this;
    }

    @JsonProperty(value="supportsProfiler")
    public Boolean getSupportsProfiler() {
        return this.supportsProfiler;
    }

    @JsonProperty(value="supportsProfiler")
    public void setSupportsProfiler(Boolean supportsProfiler) {
        this.supportsProfiler = supportsProfiler;
    }

    public TeradataConnection withSupportsProfiler(Boolean supportsProfiler) {
        this.supportsProfiler = supportsProfiler;
        return this;
    }

    @JsonProperty(value="supportsQueryComment")
    public Boolean getSupportsQueryComment() {
        return this.supportsQueryComment;
    }

    @JsonProperty(value="supportsQueryComment")
    public void setSupportsQueryComment(Boolean supportsQueryComment) {
        this.supportsQueryComment = supportsQueryComment;
    }

    public TeradataConnection withSupportsQueryComment(Boolean supportsQueryComment) {
        this.supportsQueryComment = supportsQueryComment;
        return this;
    }

    @JsonProperty(value="sampleDataStorageConfig")
    public SampleDataStorageConfig getSampleDataStorageConfig() {
        return this.sampleDataStorageConfig;
    }

    @JsonProperty(value="sampleDataStorageConfig")
    public void setSampleDataStorageConfig(SampleDataStorageConfig sampleDataStorageConfig) {
        this.sampleDataStorageConfig = sampleDataStorageConfig;
    }

    public TeradataConnection withSampleDataStorageConfig(SampleDataStorageConfig sampleDataStorageConfig) {
        this.sampleDataStorageConfig = sampleDataStorageConfig;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TeradataConnection.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("scheme");
        sb.append('=');
        sb.append(this.scheme == null ? "<null>" : this.scheme);
        sb.append(',');
        sb.append("username");
        sb.append('=');
        sb.append(this.username == null ? "<null>" : this.username);
        sb.append(',');
        sb.append("password");
        sb.append('=');
        sb.append(this.password == null ? "<null>" : this.password);
        sb.append(',');
        sb.append("logmech");
        sb.append('=');
        sb.append(this.logmech == null ? "<null>" : this.logmech);
        sb.append(',');
        sb.append("logdata");
        sb.append('=');
        sb.append(this.logdata == null ? "<null>" : this.logdata);
        sb.append(',');
        sb.append("hostPort");
        sb.append('=');
        sb.append(this.hostPort == null ? "<null>" : this.hostPort);
        sb.append(',');
        sb.append("tmode");
        sb.append('=');
        sb.append(this.tmode == null ? "<null>" : this.tmode);
        sb.append(',');
        sb.append("account");
        sb.append('=');
        sb.append(this.account == null ? "<null>" : this.account);
        sb.append(',');
        sb.append("connectionOptions");
        sb.append('=');
        sb.append(this.connectionOptions == null ? "<null>" : this.connectionOptions);
        sb.append(',');
        sb.append("connectionArguments");
        sb.append('=');
        sb.append(this.connectionArguments == null ? "<null>" : this.connectionArguments);
        sb.append(',');
        sb.append("supportsMetadataExtraction");
        sb.append('=');
        sb.append(this.supportsMetadataExtraction == null ? "<null>" : this.supportsMetadataExtraction);
        sb.append(',');
        sb.append("supportsProfiler");
        sb.append('=');
        sb.append(this.supportsProfiler == null ? "<null>" : this.supportsProfiler);
        sb.append(',');
        sb.append("supportsQueryComment");
        sb.append('=');
        sb.append(this.supportsQueryComment == null ? "<null>" : this.supportsQueryComment);
        sb.append(',');
        sb.append("sampleDataStorageConfig");
        sb.append('=');
        sb.append(this.sampleDataStorageConfig == null ? "<null>" : this.sampleDataStorageConfig);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.supportsMetadataExtraction == null ? 0 : this.supportsMetadataExtraction.hashCode());
        result = result * 31 + (this.tmode == null ? 0 : this.tmode.hashCode());
        result = result * 31 + (this.scheme == null ? 0 : this.scheme.hashCode());
        result = result * 31 + (this.supportsProfiler == null ? 0 : this.supportsProfiler.hashCode());
        result = result * 31 + (this.logmech == null ? 0 : this.logmech.hashCode());
        result = result * 31 + (this.sampleDataStorageConfig == null ? 0 : this.sampleDataStorageConfig.hashCode());
        result = result * 31 + (this.logdata == null ? 0 : this.logdata.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.connectionArguments == null ? 0 : this.connectionArguments.hashCode());
        result = result * 31 + (this.password == null ? 0 : this.password.hashCode());
        result = result * 31 + (this.connectionOptions == null ? 0 : this.connectionOptions.hashCode());
        result = result * 31 + (this.hostPort == null ? 0 : this.hostPort.hashCode());
        result = result * 31 + (this.supportsQueryComment == null ? 0 : this.supportsQueryComment.hashCode());
        result = result * 31 + (this.account == null ? 0 : this.account.hashCode());
        result = result * 31 + (this.username == null ? 0 : this.username.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof TeradataConnection)) {
            return false;
        }
        TeradataConnection rhs = (TeradataConnection)other;
        return (this.supportsMetadataExtraction == rhs.supportsMetadataExtraction || this.supportsMetadataExtraction != null && this.supportsMetadataExtraction.equals(rhs.supportsMetadataExtraction)) && (this.tmode == rhs.tmode || this.tmode != null && this.tmode.equals((Object)rhs.tmode)) && (this.scheme == rhs.scheme || this.scheme != null && this.scheme.equals((Object)rhs.scheme)) && (this.supportsProfiler == rhs.supportsProfiler || this.supportsProfiler != null && this.supportsProfiler.equals(rhs.supportsProfiler)) && (this.logmech == rhs.logmech || this.logmech != null && this.logmech.equals((Object)rhs.logmech)) && (this.sampleDataStorageConfig == rhs.sampleDataStorageConfig || this.sampleDataStorageConfig != null && this.sampleDataStorageConfig.equals(rhs.sampleDataStorageConfig)) && (this.logdata == rhs.logdata || this.logdata != null && this.logdata.equals(rhs.logdata)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.connectionArguments == rhs.connectionArguments || this.connectionArguments != null && this.connectionArguments.equals(rhs.connectionArguments)) && (this.password == rhs.password || this.password != null && this.password.equals(rhs.password)) && (this.connectionOptions == rhs.connectionOptions || this.connectionOptions != null && this.connectionOptions.equals(rhs.connectionOptions)) && (this.hostPort == rhs.hostPort || this.hostPort != null && this.hostPort.equals(rhs.hostPort)) && (this.supportsQueryComment == rhs.supportsQueryComment || this.supportsQueryComment != null && this.supportsQueryComment.equals(rhs.supportsQueryComment)) && (this.account == rhs.account || this.account != null && this.account.equals(rhs.account)) && (this.username == rhs.username || this.username != null && this.username.equals(rhs.username));
    }

    public static enum TeradataType {
        TERADATA("Teradata");

        private final String value;
        private static final Map<String, TeradataType> CONSTANTS;

        private TeradataType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static TeradataType fromValue(String value) {
            TeradataType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, TeradataType>();
            for (TeradataType c : TeradataType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum TeradataScheme {
        TERADATASQL("teradatasql");

        private final String value;
        private static final Map<String, TeradataScheme> CONSTANTS;

        private TeradataScheme(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static TeradataScheme fromValue(String value) {
            TeradataScheme constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, TeradataScheme>();
            for (TeradataScheme c : TeradataScheme.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum Logmech {
        TD_2("TD2"),
        LDAP("LDAP"),
        JWT("JWT"),
        KRB_5("KRB5"),
        CUSTOM("CUSTOM"),
        TDNEGO("TDNEGO");

        private final String value;
        private static final Map<String, Logmech> CONSTANTS;

        private Logmech(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Logmech fromValue(String value) {
            Logmech constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Logmech>();
            for (Logmech c : Logmech.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum Tmode {
        ANSI("ANSI"),
        TERA("TERA"),
        DEFAULT("DEFAULT");

        private final String value;
        private static final Map<String, Tmode> CONSTANTS;

        private Tmode(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Tmode fromValue(String value) {
            Tmode constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Tmode>();
            for (Tmode c : Tmode.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

