/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.services.connections.database.iceberg;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.security.credentials.AWSCredentials;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"tableName", "awsConfig"})
public class DynamoDbCatalogConnection {
    @JsonProperty(value="tableName")
    @JsonPropertyDescription(value="DynamoDB table name.")
    @NotNull
    private String tableName = "iceberg";
    @JsonProperty(value="awsConfig")
    @JsonPropertyDescription(value="AWS credentials configs.")
    @Valid
    @NotNull
    private AWSCredentials awsConfig;

    @JsonProperty(value="tableName")
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty(value="tableName")
    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public DynamoDbCatalogConnection withTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    @JsonProperty(value="awsConfig")
    public AWSCredentials getAwsConfig() {
        return this.awsConfig;
    }

    @JsonProperty(value="awsConfig")
    public void setAwsConfig(AWSCredentials awsConfig) {
        this.awsConfig = awsConfig;
    }

    public DynamoDbCatalogConnection withAwsConfig(AWSCredentials awsConfig) {
        this.awsConfig = awsConfig;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DynamoDbCatalogConnection.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("tableName");
        sb.append('=');
        sb.append(this.tableName == null ? "<null>" : this.tableName);
        sb.append(',');
        sb.append("awsConfig");
        sb.append('=');
        sb.append(this.awsConfig == null ? "<null>" : this.awsConfig);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.awsConfig == null ? 0 : this.awsConfig.hashCode());
        result = result * 31 + (this.tableName == null ? 0 : this.tableName.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof DynamoDbCatalogConnection)) {
            return false;
        }
        DynamoDbCatalogConnection rhs = (DynamoDbCatalogConnection)other;
        return (this.awsConfig == rhs.awsConfig || this.awsConfig != null && this.awsConfig.equals(rhs.awsConfig)) && (this.tableName == rhs.tableName || this.tableName != null && this.tableName.equals(rhs.tableName));
    }
}

