/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.services.connections.database.iceberg;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.net.URI;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.annotations.PasswordField;
import org.openmetadata.schema.services.common.SSLCertPaths;
import org.openmetadata.schema.services.connections.database.iceberg.Credential;
import org.openmetadata.schema.services.connections.database.iceberg.IcebergFileSystem;
import org.openmetadata.schema.services.connections.database.iceberg.Sigv4;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"uri", "credential", "token", "ssl", "sigv4", "fileSystem"})
public class RestCatalogConnection {
    @JsonProperty(value="uri")
    @JsonPropertyDescription(value="Uri to the REST catalog. Example: 'http://rest-catalog/ws/'")
    @NotNull
    private URI uri;
    @JsonProperty(value="credential")
    @JsonPropertyDescription(value="OAuth2 credential to use when initializing the catalog.")
    @Valid
    private Credential credential;
    @JsonProperty(value="token")
    @JsonPropertyDescription(value="Berarer token to use for the 'Authorization' header.")
    @PasswordField
    private String token;
    @JsonProperty(value="ssl")
    @JsonPropertyDescription(value="SSL Certificates By Path")
    @Valid
    private SSLCertPaths ssl;
    @JsonProperty(value="sigv4")
    @JsonPropertyDescription(value="Sign requests to the REST Server using AWS SigV4 protocol.")
    @Valid
    private Sigv4 sigv4;
    @JsonProperty(value="fileSystem")
    @JsonPropertyDescription(value="Iceberg File System configuration, based on where the Iceberg Warehouse is located.")
    @Valid
    private IcebergFileSystem fileSystem;

    @JsonProperty(value="uri")
    public URI getUri() {
        return this.uri;
    }

    @JsonProperty(value="uri")
    public void setUri(URI uri) {
        this.uri = uri;
    }

    public RestCatalogConnection withUri(URI uri) {
        this.uri = uri;
        return this;
    }

    @JsonProperty(value="credential")
    public Credential getCredential() {
        return this.credential;
    }

    @JsonProperty(value="credential")
    public void setCredential(Credential credential) {
        this.credential = credential;
    }

    public RestCatalogConnection withCredential(Credential credential) {
        this.credential = credential;
        return this;
    }

    @JsonProperty(value="token")
    @PasswordField
    public String getToken() {
        return this.token;
    }

    @JsonProperty(value="token")
    @PasswordField
    public void setToken(String token) {
        this.token = token;
    }

    public RestCatalogConnection withToken(String token) {
        this.token = token;
        return this;
    }

    @JsonProperty(value="ssl")
    public SSLCertPaths getSsl() {
        return this.ssl;
    }

    @JsonProperty(value="ssl")
    public void setSsl(SSLCertPaths ssl) {
        this.ssl = ssl;
    }

    public RestCatalogConnection withSsl(SSLCertPaths ssl) {
        this.ssl = ssl;
        return this;
    }

    @JsonProperty(value="sigv4")
    public Sigv4 getSigv4() {
        return this.sigv4;
    }

    @JsonProperty(value="sigv4")
    public void setSigv4(Sigv4 sigv4) {
        this.sigv4 = sigv4;
    }

    public RestCatalogConnection withSigv4(Sigv4 sigv4) {
        this.sigv4 = sigv4;
        return this;
    }

    @JsonProperty(value="fileSystem")
    public IcebergFileSystem getFileSystem() {
        return this.fileSystem;
    }

    @JsonProperty(value="fileSystem")
    public void setFileSystem(IcebergFileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    public RestCatalogConnection withFileSystem(IcebergFileSystem fileSystem) {
        this.fileSystem = fileSystem;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(RestCatalogConnection.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("uri");
        sb.append('=');
        sb.append(this.uri == null ? "<null>" : this.uri);
        sb.append(',');
        sb.append("credential");
        sb.append('=');
        sb.append(this.credential == null ? "<null>" : this.credential);
        sb.append(',');
        sb.append("token");
        sb.append('=');
        sb.append(this.token == null ? "<null>" : this.token);
        sb.append(',');
        sb.append("ssl");
        sb.append('=');
        sb.append(this.ssl == null ? "<null>" : this.ssl);
        sb.append(',');
        sb.append("sigv4");
        sb.append('=');
        sb.append(this.sigv4 == null ? "<null>" : this.sigv4);
        sb.append(',');
        sb.append("fileSystem");
        sb.append('=');
        sb.append(this.fileSystem == null ? "<null>" : this.fileSystem);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.fileSystem == null ? 0 : this.fileSystem.hashCode());
        result = result * 31 + (this.credential == null ? 0 : this.credential.hashCode());
        result = result * 31 + (this.sigv4 == null ? 0 : this.sigv4.hashCode());
        result = result * 31 + (this.uri == null ? 0 : this.uri.hashCode());
        result = result * 31 + (this.ssl == null ? 0 : this.ssl.hashCode());
        result = result * 31 + (this.token == null ? 0 : this.token.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof RestCatalogConnection)) {
            return false;
        }
        RestCatalogConnection rhs = (RestCatalogConnection)other;
        return (this.fileSystem == rhs.fileSystem || this.fileSystem != null && this.fileSystem.equals(rhs.fileSystem)) && (this.credential == rhs.credential || this.credential != null && this.credential.equals(rhs.credential)) && (this.sigv4 == rhs.sigv4 || this.sigv4 != null && this.sigv4.equals(rhs.sigv4)) && (this.uri == rhs.uri || this.uri != null && this.uri.equals(rhs.uri)) && (this.ssl == rhs.ssl || this.ssl != null && this.ssl.equals(rhs.ssl)) && (this.token == rhs.token || this.token != null && this.token.equals(rhs.token));
    }
}

