/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.services.connections.database.sapHana;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.constraints.NotNull;
import org.openmetadata.annotations.PasswordField;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"hostPort", "username", "password", "databaseSchema", "database"})
public class SapHanaSQLConnection {
    @JsonProperty(value="hostPort")
    @JsonPropertyDescription(value="Host and port of the Hana service.")
    @NotNull
    private String hostPort;
    @JsonProperty(value="username")
    @JsonPropertyDescription(value="Username to connect to Hana. This user should have privileges to read all the metadata.")
    @NotNull
    private String username;
    @JsonProperty(value="password")
    @JsonPropertyDescription(value="Password to connect to Hana.")
    @PasswordField
    @NotNull
    private String password;
    @JsonProperty(value="databaseSchema")
    @JsonPropertyDescription(value="Database Schema of the data source. This is an optional parameter, if you would like to restrict the metadata reading to a single schema. When left blank, OpenMetadata Ingestion attempts to scan all the schemas.")
    private String databaseSchema;
    @JsonProperty(value="database")
    @JsonPropertyDescription(value="Database of the data source.")
    private String database;

    @JsonProperty(value="hostPort")
    public String getHostPort() {
        return this.hostPort;
    }

    @JsonProperty(value="hostPort")
    public void setHostPort(String hostPort) {
        this.hostPort = hostPort;
    }

    public SapHanaSQLConnection withHostPort(String hostPort) {
        this.hostPort = hostPort;
        return this;
    }

    @JsonProperty(value="username")
    public String getUsername() {
        return this.username;
    }

    @JsonProperty(value="username")
    public void setUsername(String username) {
        this.username = username;
    }

    public SapHanaSQLConnection withUsername(String username) {
        this.username = username;
        return this;
    }

    @JsonProperty(value="password")
    @PasswordField
    public String getPassword() {
        return this.password;
    }

    @JsonProperty(value="password")
    @PasswordField
    public void setPassword(String password) {
        this.password = password;
    }

    public SapHanaSQLConnection withPassword(String password) {
        this.password = password;
        return this;
    }

    @JsonProperty(value="databaseSchema")
    public String getDatabaseSchema() {
        return this.databaseSchema;
    }

    @JsonProperty(value="databaseSchema")
    public void setDatabaseSchema(String databaseSchema) {
        this.databaseSchema = databaseSchema;
    }

    public SapHanaSQLConnection withDatabaseSchema(String databaseSchema) {
        this.databaseSchema = databaseSchema;
        return this;
    }

    @JsonProperty(value="database")
    public String getDatabase() {
        return this.database;
    }

    @JsonProperty(value="database")
    public void setDatabase(String database) {
        this.database = database;
    }

    public SapHanaSQLConnection withDatabase(String database) {
        this.database = database;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(SapHanaSQLConnection.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("hostPort");
        sb.append('=');
        sb.append(this.hostPort == null ? "<null>" : this.hostPort);
        sb.append(',');
        sb.append("username");
        sb.append('=');
        sb.append(this.username == null ? "<null>" : this.username);
        sb.append(',');
        sb.append("password");
        sb.append('=');
        sb.append(this.password == null ? "<null>" : this.password);
        sb.append(',');
        sb.append("databaseSchema");
        sb.append('=');
        sb.append(this.databaseSchema == null ? "<null>" : this.databaseSchema);
        sb.append(',');
        sb.append("database");
        sb.append('=');
        sb.append(this.database == null ? "<null>" : this.database);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.databaseSchema == null ? 0 : this.databaseSchema.hashCode());
        result = result * 31 + (this.hostPort == null ? 0 : this.hostPort.hashCode());
        result = result * 31 + (this.password == null ? 0 : this.password.hashCode());
        result = result * 31 + (this.database == null ? 0 : this.database.hashCode());
        result = result * 31 + (this.username == null ? 0 : this.username.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SapHanaSQLConnection)) {
            return false;
        }
        SapHanaSQLConnection rhs = (SapHanaSQLConnection)other;
        return (this.databaseSchema == rhs.databaseSchema || this.databaseSchema != null && this.databaseSchema.equals(rhs.databaseSchema)) && (this.hostPort == rhs.hostPort || this.hostPort != null && this.hostPort.equals(rhs.hostPort)) && (this.password == rhs.password || this.password != null && this.password.equals(rhs.password)) && (this.database == rhs.database || this.database != null && this.database.equals(rhs.database)) && (this.username == rhs.username || this.username != null && this.username.equals(rhs.username));
    }
}

