/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.services.connections.messaging;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.services.connections.database.ConnectionOptions;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "sourcePythonClass", "connectionOptions"})
public class CustomMessagingConnection {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Custom messaging service type")
    @NotNull
    private CustomMessagingType type = CustomMessagingType.fromValue("CustomMessaging");
    @JsonProperty(value="sourcePythonClass")
    @JsonPropertyDescription(value="Source Python Class Name to instantiated by the ingestion workflow")
    private String sourcePythonClass;
    @JsonProperty(value="connectionOptions")
    @JsonPropertyDescription(value="Additional connection options to build the URL that can be sent to service during the connection.")
    @Valid
    private ConnectionOptions connectionOptions;

    @JsonProperty(value="type")
    public CustomMessagingType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(CustomMessagingType type) {
        this.type = type;
    }

    public CustomMessagingConnection withType(CustomMessagingType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="sourcePythonClass")
    public String getSourcePythonClass() {
        return this.sourcePythonClass;
    }

    @JsonProperty(value="sourcePythonClass")
    public void setSourcePythonClass(String sourcePythonClass) {
        this.sourcePythonClass = sourcePythonClass;
    }

    public CustomMessagingConnection withSourcePythonClass(String sourcePythonClass) {
        this.sourcePythonClass = sourcePythonClass;
        return this;
    }

    @JsonProperty(value="connectionOptions")
    public ConnectionOptions getConnectionOptions() {
        return this.connectionOptions;
    }

    @JsonProperty(value="connectionOptions")
    public void setConnectionOptions(ConnectionOptions connectionOptions) {
        this.connectionOptions = connectionOptions;
    }

    public CustomMessagingConnection withConnectionOptions(ConnectionOptions connectionOptions) {
        this.connectionOptions = connectionOptions;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CustomMessagingConnection.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("sourcePythonClass");
        sb.append('=');
        sb.append(this.sourcePythonClass == null ? "<null>" : this.sourcePythonClass);
        sb.append(',');
        sb.append("connectionOptions");
        sb.append('=');
        sb.append(this.connectionOptions == null ? "<null>" : this.connectionOptions);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.sourcePythonClass == null ? 0 : this.sourcePythonClass.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.connectionOptions == null ? 0 : this.connectionOptions.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CustomMessagingConnection)) {
            return false;
        }
        CustomMessagingConnection rhs = (CustomMessagingConnection)other;
        return (this.sourcePythonClass == rhs.sourcePythonClass || this.sourcePythonClass != null && this.sourcePythonClass.equals(rhs.sourcePythonClass)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.connectionOptions == rhs.connectionOptions || this.connectionOptions != null && this.connectionOptions.equals(rhs.connectionOptions));
    }

    public static enum CustomMessagingType {
        CUSTOM_MESSAGING("CustomMessaging");

        private final String value;
        private static final Map<String, CustomMessagingType> CONSTANTS;

        private CustomMessagingType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static CustomMessagingType fromValue(String value) {
            CustomMessagingType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, CustomMessagingType>();
            for (CustomMessagingType c : CustomMessagingType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

