/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.services.connections.messaging;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.annotations.PasswordField;
import org.openmetadata.schema.services.connections.messaging.ConsumerConfig__1;
import org.openmetadata.schema.services.connections.messaging.SaslMechanismType;
import org.openmetadata.schema.services.connections.messaging.SchemaRegistryConfig__1;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "bootstrapServers", "schemaRegistryURL", "saslUsername", "saslPassword", "securityProtocol", "saslMechanism", "basicAuthUserInfo", "consumerConfig", "schemaRegistryConfig", "supportsMetadataExtraction"})
public class RedpandaConnection {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Redpanda service type")
    private RedpandaType type = RedpandaType.fromValue("Redpanda");
    @JsonProperty(value="bootstrapServers")
    @JsonPropertyDescription(value="Redpanda bootstrap servers. add them in comma separated values ex: host1:9092,host2:9092")
    @NotNull
    private String bootstrapServers;
    @JsonProperty(value="schemaRegistryURL")
    @JsonPropertyDescription(value="Confluent Redpanda Schema Registry URL.")
    private URI schemaRegistryURL;
    @JsonProperty(value="saslUsername")
    @JsonPropertyDescription(value="sasl.username consumer config property")
    private String saslUsername;
    @JsonProperty(value="saslPassword")
    @JsonPropertyDescription(value="sasl.password consumer config property")
    @PasswordField
    private String saslPassword;
    @JsonProperty(value="securityProtocol")
    @JsonPropertyDescription(value="security.protocol consumer config property")
    private SecurityProtocol securityProtocol = SecurityProtocol.fromValue("PLAINTEXT");
    @JsonProperty(value="saslMechanism")
    @JsonPropertyDescription(value="SASL Mechanism consumer config property")
    private SaslMechanismType saslMechanism = SaslMechanismType.fromValue("PLAIN");
    @JsonProperty(value="basicAuthUserInfo")
    @JsonPropertyDescription(value="basic.auth.user.info schema registry config property, Client HTTP credentials in the form of username:password.")
    @PasswordField
    private String basicAuthUserInfo;
    @JsonProperty(value="consumerConfig")
    @JsonPropertyDescription(value="Confluent Redpanda Consumer Config")
    @Valid
    private ConsumerConfig__1 consumerConfig;
    @JsonProperty(value="schemaRegistryConfig")
    @JsonPropertyDescription(value="Confluent Redpanda Schema Registry Config.")
    @Valid
    private SchemaRegistryConfig__1 schemaRegistryConfig;
    @JsonProperty(value="supportsMetadataExtraction")
    @JsonPropertyDescription(value="Supports Metadata Extraction.")
    private Boolean supportsMetadataExtraction = true;

    @JsonProperty(value="type")
    public RedpandaType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(RedpandaType type) {
        this.type = type;
    }

    public RedpandaConnection withType(RedpandaType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="bootstrapServers")
    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    @JsonProperty(value="bootstrapServers")
    public void setBootstrapServers(String bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
    }

    public RedpandaConnection withBootstrapServers(String bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
        return this;
    }

    @JsonProperty(value="schemaRegistryURL")
    public URI getSchemaRegistryURL() {
        return this.schemaRegistryURL;
    }

    @JsonProperty(value="schemaRegistryURL")
    public void setSchemaRegistryURL(URI schemaRegistryURL) {
        this.schemaRegistryURL = schemaRegistryURL;
    }

    public RedpandaConnection withSchemaRegistryURL(URI schemaRegistryURL) {
        this.schemaRegistryURL = schemaRegistryURL;
        return this;
    }

    @JsonProperty(value="saslUsername")
    public String getSaslUsername() {
        return this.saslUsername;
    }

    @JsonProperty(value="saslUsername")
    public void setSaslUsername(String saslUsername) {
        this.saslUsername = saslUsername;
    }

    public RedpandaConnection withSaslUsername(String saslUsername) {
        this.saslUsername = saslUsername;
        return this;
    }

    @JsonProperty(value="saslPassword")
    @PasswordField
    public String getSaslPassword() {
        return this.saslPassword;
    }

    @JsonProperty(value="saslPassword")
    @PasswordField
    public void setSaslPassword(String saslPassword) {
        this.saslPassword = saslPassword;
    }

    public RedpandaConnection withSaslPassword(String saslPassword) {
        this.saslPassword = saslPassword;
        return this;
    }

    @JsonProperty(value="securityProtocol")
    public SecurityProtocol getSecurityProtocol() {
        return this.securityProtocol;
    }

    @JsonProperty(value="securityProtocol")
    public void setSecurityProtocol(SecurityProtocol securityProtocol) {
        this.securityProtocol = securityProtocol;
    }

    public RedpandaConnection withSecurityProtocol(SecurityProtocol securityProtocol) {
        this.securityProtocol = securityProtocol;
        return this;
    }

    @JsonProperty(value="saslMechanism")
    public SaslMechanismType getSaslMechanism() {
        return this.saslMechanism;
    }

    @JsonProperty(value="saslMechanism")
    public void setSaslMechanism(SaslMechanismType saslMechanism) {
        this.saslMechanism = saslMechanism;
    }

    public RedpandaConnection withSaslMechanism(SaslMechanismType saslMechanism) {
        this.saslMechanism = saslMechanism;
        return this;
    }

    @JsonProperty(value="basicAuthUserInfo")
    @PasswordField
    public String getBasicAuthUserInfo() {
        return this.basicAuthUserInfo;
    }

    @JsonProperty(value="basicAuthUserInfo")
    @PasswordField
    public void setBasicAuthUserInfo(String basicAuthUserInfo) {
        this.basicAuthUserInfo = basicAuthUserInfo;
    }

    public RedpandaConnection withBasicAuthUserInfo(String basicAuthUserInfo) {
        this.basicAuthUserInfo = basicAuthUserInfo;
        return this;
    }

    @JsonProperty(value="consumerConfig")
    public ConsumerConfig__1 getConsumerConfig() {
        return this.consumerConfig;
    }

    @JsonProperty(value="consumerConfig")
    public void setConsumerConfig(ConsumerConfig__1 consumerConfig) {
        this.consumerConfig = consumerConfig;
    }

    public RedpandaConnection withConsumerConfig(ConsumerConfig__1 consumerConfig) {
        this.consumerConfig = consumerConfig;
        return this;
    }

    @JsonProperty(value="schemaRegistryConfig")
    public SchemaRegistryConfig__1 getSchemaRegistryConfig() {
        return this.schemaRegistryConfig;
    }

    @JsonProperty(value="schemaRegistryConfig")
    public void setSchemaRegistryConfig(SchemaRegistryConfig__1 schemaRegistryConfig) {
        this.schemaRegistryConfig = schemaRegistryConfig;
    }

    public RedpandaConnection withSchemaRegistryConfig(SchemaRegistryConfig__1 schemaRegistryConfig) {
        this.schemaRegistryConfig = schemaRegistryConfig;
        return this;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public Boolean getSupportsMetadataExtraction() {
        return this.supportsMetadataExtraction;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public void setSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
    }

    public RedpandaConnection withSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(RedpandaConnection.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("bootstrapServers");
        sb.append('=');
        sb.append(this.bootstrapServers == null ? "<null>" : this.bootstrapServers);
        sb.append(',');
        sb.append("schemaRegistryURL");
        sb.append('=');
        sb.append(this.schemaRegistryURL == null ? "<null>" : this.schemaRegistryURL);
        sb.append(',');
        sb.append("saslUsername");
        sb.append('=');
        sb.append(this.saslUsername == null ? "<null>" : this.saslUsername);
        sb.append(',');
        sb.append("saslPassword");
        sb.append('=');
        sb.append(this.saslPassword == null ? "<null>" : this.saslPassword);
        sb.append(',');
        sb.append("securityProtocol");
        sb.append('=');
        sb.append(this.securityProtocol == null ? "<null>" : this.securityProtocol);
        sb.append(',');
        sb.append("saslMechanism");
        sb.append('=');
        sb.append(this.saslMechanism == null ? "<null>" : this.saslMechanism);
        sb.append(',');
        sb.append("basicAuthUserInfo");
        sb.append('=');
        sb.append(this.basicAuthUserInfo == null ? "<null>" : this.basicAuthUserInfo);
        sb.append(',');
        sb.append("consumerConfig");
        sb.append('=');
        sb.append(this.consumerConfig == null ? "<null>" : this.consumerConfig);
        sb.append(',');
        sb.append("schemaRegistryConfig");
        sb.append('=');
        sb.append(this.schemaRegistryConfig == null ? "<null>" : this.schemaRegistryConfig);
        sb.append(',');
        sb.append("supportsMetadataExtraction");
        sb.append('=');
        sb.append(this.supportsMetadataExtraction == null ? "<null>" : this.supportsMetadataExtraction);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.schemaRegistryURL == null ? 0 : this.schemaRegistryURL.hashCode());
        result = result * 31 + (this.supportsMetadataExtraction == null ? 0 : this.supportsMetadataExtraction.hashCode());
        result = result * 31 + (this.consumerConfig == null ? 0 : this.consumerConfig.hashCode());
        result = result * 31 + (this.securityProtocol == null ? 0 : this.securityProtocol.hashCode());
        result = result * 31 + (this.bootstrapServers == null ? 0 : this.bootstrapServers.hashCode());
        result = result * 31 + (this.saslPassword == null ? 0 : this.saslPassword.hashCode());
        result = result * 31 + (this.basicAuthUserInfo == null ? 0 : this.basicAuthUserInfo.hashCode());
        result = result * 31 + (this.saslUsername == null ? 0 : this.saslUsername.hashCode());
        result = result * 31 + (this.saslMechanism == null ? 0 : this.saslMechanism.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.schemaRegistryConfig == null ? 0 : this.schemaRegistryConfig.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof RedpandaConnection)) {
            return false;
        }
        RedpandaConnection rhs = (RedpandaConnection)other;
        return (this.schemaRegistryURL == rhs.schemaRegistryURL || this.schemaRegistryURL != null && this.schemaRegistryURL.equals(rhs.schemaRegistryURL)) && (this.supportsMetadataExtraction == rhs.supportsMetadataExtraction || this.supportsMetadataExtraction != null && this.supportsMetadataExtraction.equals(rhs.supportsMetadataExtraction)) && (this.consumerConfig == rhs.consumerConfig || this.consumerConfig != null && this.consumerConfig.equals(rhs.consumerConfig)) && (this.securityProtocol == rhs.securityProtocol || this.securityProtocol != null && this.securityProtocol.equals((Object)rhs.securityProtocol)) && (this.bootstrapServers == rhs.bootstrapServers || this.bootstrapServers != null && this.bootstrapServers.equals(rhs.bootstrapServers)) && (this.saslPassword == rhs.saslPassword || this.saslPassword != null && this.saslPassword.equals(rhs.saslPassword)) && (this.basicAuthUserInfo == rhs.basicAuthUserInfo || this.basicAuthUserInfo != null && this.basicAuthUserInfo.equals(rhs.basicAuthUserInfo)) && (this.saslUsername == rhs.saslUsername || this.saslUsername != null && this.saslUsername.equals(rhs.saslUsername)) && (this.saslMechanism == rhs.saslMechanism || this.saslMechanism != null && this.saslMechanism.equals((Object)rhs.saslMechanism)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.schemaRegistryConfig == rhs.schemaRegistryConfig || this.schemaRegistryConfig != null && this.schemaRegistryConfig.equals(rhs.schemaRegistryConfig));
    }

    public static enum RedpandaType {
        REDPANDA("Redpanda");

        private final String value;
        private static final Map<String, RedpandaType> CONSTANTS;

        private RedpandaType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static RedpandaType fromValue(String value) {
            RedpandaType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, RedpandaType>();
            for (RedpandaType c : RedpandaType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum SecurityProtocol {
        PLAINTEXT("PLAINTEXT"),
        SASL_PLAINTEXT("SASL_PLAINTEXT"),
        SASL_SSL("SASL_SSL"),
        SSL("SSL");

        private final String value;
        private static final Map<String, SecurityProtocol> CONSTANTS;

        private SecurityProtocol(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static SecurityProtocol fromValue(String value) {
            SecurityProtocol constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, SecurityProtocol>();
            for (SecurityProtocol c : SecurityProtocol.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

