/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.services.connections.messaging;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum SaslMechanismType {
    PLAIN("PLAIN"),
    GSSAPI("GSSAPI"),
    SCRAM_SHA_256("SCRAM-SHA-256"),
    SCRAM_SHA_512("SCRAM-SHA-512"),
    OAUTHBEARER("OAUTHBEARER");

    private final String value;
    private static final Map<String, SaslMechanismType> CONSTANTS;

    private SaslMechanismType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static SaslMechanismType fromValue(String value) {
        SaslMechanismType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, SaslMechanismType>();
        for (SaslMechanismType c : SaslMechanismType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

