/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.services.connections.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.annotations.ExposedField;
import org.openmetadata.annotations.MaskedField;
import org.openmetadata.schema.services.connections.database.ConnectionArguments;
import org.openmetadata.schema.services.connections.database.ConnectionOptions;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "hostPort", "authType", "connection", "projectName", "paginationLimit", "includeUndeployedDatasources", "includeHiddenDatasources", "ingestDatasources", "ingestUsersAndGroups", "ingestDomains", "ingestKnowledgeArticles", "ingestDashboards", "alationTagClassificationName", "connectionOptions", "connectionArguments", "supportsMetadataExtraction"})
public class AlationConnection {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Service type.")
    private AlationType type = AlationType.fromValue("Alation");
    @JsonProperty(value="hostPort")
    @JsonPropertyDescription(value="Host and port of the Alation service.")
    @ExposedField
    @NotNull
    private URI hostPort;
    @JsonProperty(value="authType")
    @JsonPropertyDescription(value="Types of methods used to authenticate to the alation instance")
    @MaskedField
    @NotNull
    private Object authType;
    @JsonProperty(value="connection")
    @JsonPropertyDescription(value="Choose between mysql and postgres connection for alation database")
    private Object connection;
    @JsonProperty(value="projectName")
    @JsonPropertyDescription(value="Project name to create the refreshToken. Can be anything")
    private String projectName = "AlationAPI";
    @JsonProperty(value="paginationLimit")
    @JsonPropertyDescription(value="Pagination limit used for Alation APIs pagination")
    private Integer paginationLimit = 10;
    @JsonProperty(value="includeUndeployedDatasources")
    @JsonPropertyDescription(value="Specifies if undeployed datasources should be included while ingesting.")
    private Boolean includeUndeployedDatasources = false;
    @JsonProperty(value="includeHiddenDatasources")
    @JsonPropertyDescription(value="Specifies if hidden datasources should be included while ingesting.")
    private Boolean includeHiddenDatasources = false;
    @JsonProperty(value="ingestDatasources")
    @JsonPropertyDescription(value="Specifies if Datasources are to be ingested while running the ingestion job.")
    private Boolean ingestDatasources = true;
    @JsonProperty(value="ingestUsersAndGroups")
    @JsonPropertyDescription(value="Specifies if Users and Groups are to be ingested while running the ingestion job.")
    private Boolean ingestUsersAndGroups = true;
    @JsonProperty(value="ingestDomains")
    @JsonPropertyDescription(value="Specifies if Domains are to be ingested while running the ingestion job.")
    private Boolean ingestDomains = true;
    @JsonProperty(value="ingestKnowledgeArticles")
    @JsonPropertyDescription(value="Specifies if Knowledge Articles are to be ingested while running the ingestion job.")
    private Boolean ingestKnowledgeArticles = true;
    @JsonProperty(value="ingestDashboards")
    @JsonPropertyDescription(value="Specifies if Dashboards are to be ingested while running the ingestion job.")
    private Boolean ingestDashboards = true;
    @JsonProperty(value="alationTagClassificationName")
    @JsonPropertyDescription(value="Custom OpenMetadata Classification name for alation tags.")
    private String alationTagClassificationName = "alationTags";
    @JsonProperty(value="connectionOptions")
    @JsonPropertyDescription(value="Additional connection options to build the URL that can be sent to service during the connection.")
    @Valid
    private ConnectionOptions connectionOptions;
    @JsonProperty(value="connectionArguments")
    @JsonPropertyDescription(value="Additional connection arguments such as security or protocol configs that can be sent to service during connection.")
    @Valid
    private ConnectionArguments connectionArguments;
    @JsonProperty(value="supportsMetadataExtraction")
    @JsonPropertyDescription(value="Supports Metadata Extraction.")
    private Boolean supportsMetadataExtraction = true;

    @JsonProperty(value="type")
    public AlationType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(AlationType type) {
        this.type = type;
    }

    public AlationConnection withType(AlationType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="hostPort")
    @ExposedField
    public URI getHostPort() {
        return this.hostPort;
    }

    @JsonProperty(value="hostPort")
    @ExposedField
    public void setHostPort(URI hostPort) {
        this.hostPort = hostPort;
    }

    public AlationConnection withHostPort(URI hostPort) {
        this.hostPort = hostPort;
        return this;
    }

    @JsonProperty(value="authType")
    @MaskedField
    public Object getAuthType() {
        return this.authType;
    }

    @JsonProperty(value="authType")
    @MaskedField
    public void setAuthType(Object authType) {
        this.authType = authType;
    }

    public AlationConnection withAuthType(Object authType) {
        this.authType = authType;
        return this;
    }

    @JsonProperty(value="connection")
    public Object getConnection() {
        return this.connection;
    }

    @JsonProperty(value="connection")
    public void setConnection(Object connection) {
        this.connection = connection;
    }

    public AlationConnection withConnection(Object connection) {
        this.connection = connection;
        return this;
    }

    @JsonProperty(value="projectName")
    public String getProjectName() {
        return this.projectName;
    }

    @JsonProperty(value="projectName")
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public AlationConnection withProjectName(String projectName) {
        this.projectName = projectName;
        return this;
    }

    @JsonProperty(value="paginationLimit")
    public Integer getPaginationLimit() {
        return this.paginationLimit;
    }

    @JsonProperty(value="paginationLimit")
    public void setPaginationLimit(Integer paginationLimit) {
        this.paginationLimit = paginationLimit;
    }

    public AlationConnection withPaginationLimit(Integer paginationLimit) {
        this.paginationLimit = paginationLimit;
        return this;
    }

    @JsonProperty(value="includeUndeployedDatasources")
    public Boolean getIncludeUndeployedDatasources() {
        return this.includeUndeployedDatasources;
    }

    @JsonProperty(value="includeUndeployedDatasources")
    public void setIncludeUndeployedDatasources(Boolean includeUndeployedDatasources) {
        this.includeUndeployedDatasources = includeUndeployedDatasources;
    }

    public AlationConnection withIncludeUndeployedDatasources(Boolean includeUndeployedDatasources) {
        this.includeUndeployedDatasources = includeUndeployedDatasources;
        return this;
    }

    @JsonProperty(value="includeHiddenDatasources")
    public Boolean getIncludeHiddenDatasources() {
        return this.includeHiddenDatasources;
    }

    @JsonProperty(value="includeHiddenDatasources")
    public void setIncludeHiddenDatasources(Boolean includeHiddenDatasources) {
        this.includeHiddenDatasources = includeHiddenDatasources;
    }

    public AlationConnection withIncludeHiddenDatasources(Boolean includeHiddenDatasources) {
        this.includeHiddenDatasources = includeHiddenDatasources;
        return this;
    }

    @JsonProperty(value="ingestDatasources")
    public Boolean getIngestDatasources() {
        return this.ingestDatasources;
    }

    @JsonProperty(value="ingestDatasources")
    public void setIngestDatasources(Boolean ingestDatasources) {
        this.ingestDatasources = ingestDatasources;
    }

    public AlationConnection withIngestDatasources(Boolean ingestDatasources) {
        this.ingestDatasources = ingestDatasources;
        return this;
    }

    @JsonProperty(value="ingestUsersAndGroups")
    public Boolean getIngestUsersAndGroups() {
        return this.ingestUsersAndGroups;
    }

    @JsonProperty(value="ingestUsersAndGroups")
    public void setIngestUsersAndGroups(Boolean ingestUsersAndGroups) {
        this.ingestUsersAndGroups = ingestUsersAndGroups;
    }

    public AlationConnection withIngestUsersAndGroups(Boolean ingestUsersAndGroups) {
        this.ingestUsersAndGroups = ingestUsersAndGroups;
        return this;
    }

    @JsonProperty(value="ingestDomains")
    public Boolean getIngestDomains() {
        return this.ingestDomains;
    }

    @JsonProperty(value="ingestDomains")
    public void setIngestDomains(Boolean ingestDomains) {
        this.ingestDomains = ingestDomains;
    }

    public AlationConnection withIngestDomains(Boolean ingestDomains) {
        this.ingestDomains = ingestDomains;
        return this;
    }

    @JsonProperty(value="ingestKnowledgeArticles")
    public Boolean getIngestKnowledgeArticles() {
        return this.ingestKnowledgeArticles;
    }

    @JsonProperty(value="ingestKnowledgeArticles")
    public void setIngestKnowledgeArticles(Boolean ingestKnowledgeArticles) {
        this.ingestKnowledgeArticles = ingestKnowledgeArticles;
    }

    public AlationConnection withIngestKnowledgeArticles(Boolean ingestKnowledgeArticles) {
        this.ingestKnowledgeArticles = ingestKnowledgeArticles;
        return this;
    }

    @JsonProperty(value="ingestDashboards")
    public Boolean getIngestDashboards() {
        return this.ingestDashboards;
    }

    @JsonProperty(value="ingestDashboards")
    public void setIngestDashboards(Boolean ingestDashboards) {
        this.ingestDashboards = ingestDashboards;
    }

    public AlationConnection withIngestDashboards(Boolean ingestDashboards) {
        this.ingestDashboards = ingestDashboards;
        return this;
    }

    @JsonProperty(value="alationTagClassificationName")
    public String getAlationTagClassificationName() {
        return this.alationTagClassificationName;
    }

    @JsonProperty(value="alationTagClassificationName")
    public void setAlationTagClassificationName(String alationTagClassificationName) {
        this.alationTagClassificationName = alationTagClassificationName;
    }

    public AlationConnection withAlationTagClassificationName(String alationTagClassificationName) {
        this.alationTagClassificationName = alationTagClassificationName;
        return this;
    }

    @JsonProperty(value="connectionOptions")
    public ConnectionOptions getConnectionOptions() {
        return this.connectionOptions;
    }

    @JsonProperty(value="connectionOptions")
    public void setConnectionOptions(ConnectionOptions connectionOptions) {
        this.connectionOptions = connectionOptions;
    }

    public AlationConnection withConnectionOptions(ConnectionOptions connectionOptions) {
        this.connectionOptions = connectionOptions;
        return this;
    }

    @JsonProperty(value="connectionArguments")
    public ConnectionArguments getConnectionArguments() {
        return this.connectionArguments;
    }

    @JsonProperty(value="connectionArguments")
    public void setConnectionArguments(ConnectionArguments connectionArguments) {
        this.connectionArguments = connectionArguments;
    }

    public AlationConnection withConnectionArguments(ConnectionArguments connectionArguments) {
        this.connectionArguments = connectionArguments;
        return this;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public Boolean getSupportsMetadataExtraction() {
        return this.supportsMetadataExtraction;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public void setSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
    }

    public AlationConnection withSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(AlationConnection.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("hostPort");
        sb.append('=');
        sb.append(this.hostPort == null ? "<null>" : this.hostPort);
        sb.append(',');
        sb.append("authType");
        sb.append('=');
        sb.append(this.authType == null ? "<null>" : this.authType);
        sb.append(',');
        sb.append("connection");
        sb.append('=');
        sb.append(this.connection == null ? "<null>" : this.connection);
        sb.append(',');
        sb.append("projectName");
        sb.append('=');
        sb.append(this.projectName == null ? "<null>" : this.projectName);
        sb.append(',');
        sb.append("paginationLimit");
        sb.append('=');
        sb.append(this.paginationLimit == null ? "<null>" : this.paginationLimit);
        sb.append(',');
        sb.append("includeUndeployedDatasources");
        sb.append('=');
        sb.append(this.includeUndeployedDatasources == null ? "<null>" : this.includeUndeployedDatasources);
        sb.append(',');
        sb.append("includeHiddenDatasources");
        sb.append('=');
        sb.append(this.includeHiddenDatasources == null ? "<null>" : this.includeHiddenDatasources);
        sb.append(',');
        sb.append("ingestDatasources");
        sb.append('=');
        sb.append(this.ingestDatasources == null ? "<null>" : this.ingestDatasources);
        sb.append(',');
        sb.append("ingestUsersAndGroups");
        sb.append('=');
        sb.append(this.ingestUsersAndGroups == null ? "<null>" : this.ingestUsersAndGroups);
        sb.append(',');
        sb.append("ingestDomains");
        sb.append('=');
        sb.append(this.ingestDomains == null ? "<null>" : this.ingestDomains);
        sb.append(',');
        sb.append("ingestKnowledgeArticles");
        sb.append('=');
        sb.append(this.ingestKnowledgeArticles == null ? "<null>" : this.ingestKnowledgeArticles);
        sb.append(',');
        sb.append("ingestDashboards");
        sb.append('=');
        sb.append(this.ingestDashboards == null ? "<null>" : this.ingestDashboards);
        sb.append(',');
        sb.append("alationTagClassificationName");
        sb.append('=');
        sb.append(this.alationTagClassificationName == null ? "<null>" : this.alationTagClassificationName);
        sb.append(',');
        sb.append("connectionOptions");
        sb.append('=');
        sb.append(this.connectionOptions == null ? "<null>" : this.connectionOptions);
        sb.append(',');
        sb.append("connectionArguments");
        sb.append('=');
        sb.append(this.connectionArguments == null ? "<null>" : this.connectionArguments);
        sb.append(',');
        sb.append("supportsMetadataExtraction");
        sb.append('=');
        sb.append(this.supportsMetadataExtraction == null ? "<null>" : this.supportsMetadataExtraction);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.supportsMetadataExtraction == null ? 0 : this.supportsMetadataExtraction.hashCode());
        result = result * 31 + (this.ingestKnowledgeArticles == null ? 0 : this.ingestKnowledgeArticles.hashCode());
        result = result * 31 + (this.ingestDatasources == null ? 0 : this.ingestDatasources.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.connectionArguments == null ? 0 : this.connectionArguments.hashCode());
        result = result * 31 + (this.includeUndeployedDatasources == null ? 0 : this.includeUndeployedDatasources.hashCode());
        result = result * 31 + (this.connectionOptions == null ? 0 : this.connectionOptions.hashCode());
        result = result * 31 + (this.ingestUsersAndGroups == null ? 0 : this.ingestUsersAndGroups.hashCode());
        result = result * 31 + (this.ingestDashboards == null ? 0 : this.ingestDashboards.hashCode());
        result = result * 31 + (this.alationTagClassificationName == null ? 0 : this.alationTagClassificationName.hashCode());
        result = result * 31 + (this.hostPort == null ? 0 : this.hostPort.hashCode());
        result = result * 31 + (this.connection == null ? 0 : this.connection.hashCode());
        result = result * 31 + (this.paginationLimit == null ? 0 : this.paginationLimit.hashCode());
        result = result * 31 + (this.authType == null ? 0 : this.authType.hashCode());
        result = result * 31 + (this.projectName == null ? 0 : this.projectName.hashCode());
        result = result * 31 + (this.ingestDomains == null ? 0 : this.ingestDomains.hashCode());
        result = result * 31 + (this.includeHiddenDatasources == null ? 0 : this.includeHiddenDatasources.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof AlationConnection)) {
            return false;
        }
        AlationConnection rhs = (AlationConnection)other;
        return (this.supportsMetadataExtraction == rhs.supportsMetadataExtraction || this.supportsMetadataExtraction != null && this.supportsMetadataExtraction.equals(rhs.supportsMetadataExtraction)) && (this.ingestKnowledgeArticles == rhs.ingestKnowledgeArticles || this.ingestKnowledgeArticles != null && this.ingestKnowledgeArticles.equals(rhs.ingestKnowledgeArticles)) && (this.ingestDatasources == rhs.ingestDatasources || this.ingestDatasources != null && this.ingestDatasources.equals(rhs.ingestDatasources)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.connectionArguments == rhs.connectionArguments || this.connectionArguments != null && this.connectionArguments.equals(rhs.connectionArguments)) && (this.includeUndeployedDatasources == rhs.includeUndeployedDatasources || this.includeUndeployedDatasources != null && this.includeUndeployedDatasources.equals(rhs.includeUndeployedDatasources)) && (this.connectionOptions == rhs.connectionOptions || this.connectionOptions != null && this.connectionOptions.equals(rhs.connectionOptions)) && (this.ingestUsersAndGroups == rhs.ingestUsersAndGroups || this.ingestUsersAndGroups != null && this.ingestUsersAndGroups.equals(rhs.ingestUsersAndGroups)) && (this.ingestDashboards == rhs.ingestDashboards || this.ingestDashboards != null && this.ingestDashboards.equals(rhs.ingestDashboards)) && (this.alationTagClassificationName == rhs.alationTagClassificationName || this.alationTagClassificationName != null && this.alationTagClassificationName.equals(rhs.alationTagClassificationName)) && (this.hostPort == rhs.hostPort || this.hostPort != null && this.hostPort.equals(rhs.hostPort)) && (this.connection == rhs.connection || this.connection != null && this.connection.equals(rhs.connection)) && (this.paginationLimit == rhs.paginationLimit || this.paginationLimit != null && this.paginationLimit.equals(rhs.paginationLimit)) && (this.authType == rhs.authType || this.authType != null && this.authType.equals(rhs.authType)) && (this.projectName == rhs.projectName || this.projectName != null && this.projectName.equals(rhs.projectName)) && (this.ingestDomains == rhs.ingestDomains || this.ingestDomains != null && this.ingestDomains.equals(rhs.ingestDomains)) && (this.includeHiddenDatasources == rhs.includeHiddenDatasources || this.includeHiddenDatasources != null && this.includeHiddenDatasources.equals(rhs.includeHiddenDatasources));
    }

    public static enum AlationType {
        ALATION("Alation");

        private final String value;
        private static final Map<String, AlationType> CONSTANTS;

        private AlationType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static AlationType fromValue(String value) {
            AlationType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, AlationType>();
            for (AlationType c : AlationType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

