/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.services.connections.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.annotations.ExposedField;
import org.openmetadata.annotations.MaskedField;
import org.openmetadata.schema.security.ssl.VerifySSL;
import org.openmetadata.schema.services.connections.database.ConnectionArguments;
import org.openmetadata.schema.services.connections.database.ConnectionOptions;
import org.openmetadata.schema.services.connections.metadata.DatasourceLinks;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "hostPort", "authType", "projectName", "paginationLimit", "datasourceLinks", "verifySSL", "sslConfig", "connectionOptions", "connectionArguments", "supportsMetadataExtraction"})
public class AlationSinkConnection {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Service type.")
    private AlationSinkType type = AlationSinkType.fromValue("AlationSink");
    @JsonProperty(value="hostPort")
    @JsonPropertyDescription(value="Host and port of the Alation service.")
    @ExposedField
    @NotNull
    private URI hostPort;
    @JsonProperty(value="authType")
    @JsonPropertyDescription(value="Types of methods used to authenticate to the alation instance")
    @MaskedField
    @NotNull
    private Object authType;
    @JsonProperty(value="projectName")
    @JsonPropertyDescription(value="Project name to create the refreshToken. Can be anything")
    private String projectName = "AlationAPI";
    @JsonProperty(value="paginationLimit")
    @JsonPropertyDescription(value="Pagination limit used for Alation APIs pagination")
    private Integer paginationLimit = 10;
    @JsonProperty(value="datasourceLinks")
    @JsonPropertyDescription(value="Add the links between alation datasources and OpenMetadata Database services")
    @Valid
    private DatasourceLinks datasourceLinks;
    @JsonProperty(value="verifySSL")
    @JsonPropertyDescription(value="Client SSL verification. Make sure to configure the SSLConfig if enabled.")
    private VerifySSL verifySSL = VerifySSL.fromValue("no-ssl");
    @JsonProperty(value="sslConfig")
    @JsonPropertyDescription(value="Client SSL configuration")
    @MaskedField
    private Object sslConfig;
    @JsonProperty(value="connectionOptions")
    @JsonPropertyDescription(value="Additional connection options to build the URL that can be sent to service during the connection.")
    @Valid
    private ConnectionOptions connectionOptions;
    @JsonProperty(value="connectionArguments")
    @JsonPropertyDescription(value="Additional connection arguments such as security or protocol configs that can be sent to service during connection.")
    @Valid
    private ConnectionArguments connectionArguments;
    @JsonProperty(value="supportsMetadataExtraction")
    @JsonPropertyDescription(value="Supports Metadata Extraction.")
    private Boolean supportsMetadataExtraction = true;

    @JsonProperty(value="type")
    public AlationSinkType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(AlationSinkType type) {
        this.type = type;
    }

    public AlationSinkConnection withType(AlationSinkType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="hostPort")
    @ExposedField
    public URI getHostPort() {
        return this.hostPort;
    }

    @JsonProperty(value="hostPort")
    @ExposedField
    public void setHostPort(URI hostPort) {
        this.hostPort = hostPort;
    }

    public AlationSinkConnection withHostPort(URI hostPort) {
        this.hostPort = hostPort;
        return this;
    }

    @JsonProperty(value="authType")
    @MaskedField
    public Object getAuthType() {
        return this.authType;
    }

    @JsonProperty(value="authType")
    @MaskedField
    public void setAuthType(Object authType) {
        this.authType = authType;
    }

    public AlationSinkConnection withAuthType(Object authType) {
        this.authType = authType;
        return this;
    }

    @JsonProperty(value="projectName")
    public String getProjectName() {
        return this.projectName;
    }

    @JsonProperty(value="projectName")
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public AlationSinkConnection withProjectName(String projectName) {
        this.projectName = projectName;
        return this;
    }

    @JsonProperty(value="paginationLimit")
    public Integer getPaginationLimit() {
        return this.paginationLimit;
    }

    @JsonProperty(value="paginationLimit")
    public void setPaginationLimit(Integer paginationLimit) {
        this.paginationLimit = paginationLimit;
    }

    public AlationSinkConnection withPaginationLimit(Integer paginationLimit) {
        this.paginationLimit = paginationLimit;
        return this;
    }

    @JsonProperty(value="datasourceLinks")
    public DatasourceLinks getDatasourceLinks() {
        return this.datasourceLinks;
    }

    @JsonProperty(value="datasourceLinks")
    public void setDatasourceLinks(DatasourceLinks datasourceLinks) {
        this.datasourceLinks = datasourceLinks;
    }

    public AlationSinkConnection withDatasourceLinks(DatasourceLinks datasourceLinks) {
        this.datasourceLinks = datasourceLinks;
        return this;
    }

    @JsonProperty(value="verifySSL")
    public VerifySSL getVerifySSL() {
        return this.verifySSL;
    }

    @JsonProperty(value="verifySSL")
    public void setVerifySSL(VerifySSL verifySSL) {
        this.verifySSL = verifySSL;
    }

    public AlationSinkConnection withVerifySSL(VerifySSL verifySSL) {
        this.verifySSL = verifySSL;
        return this;
    }

    @JsonProperty(value="sslConfig")
    @MaskedField
    public Object getSslConfig() {
        return this.sslConfig;
    }

    @JsonProperty(value="sslConfig")
    @MaskedField
    public void setSslConfig(Object sslConfig) {
        this.sslConfig = sslConfig;
    }

    public AlationSinkConnection withSslConfig(Object sslConfig) {
        this.sslConfig = sslConfig;
        return this;
    }

    @JsonProperty(value="connectionOptions")
    public ConnectionOptions getConnectionOptions() {
        return this.connectionOptions;
    }

    @JsonProperty(value="connectionOptions")
    public void setConnectionOptions(ConnectionOptions connectionOptions) {
        this.connectionOptions = connectionOptions;
    }

    public AlationSinkConnection withConnectionOptions(ConnectionOptions connectionOptions) {
        this.connectionOptions = connectionOptions;
        return this;
    }

    @JsonProperty(value="connectionArguments")
    public ConnectionArguments getConnectionArguments() {
        return this.connectionArguments;
    }

    @JsonProperty(value="connectionArguments")
    public void setConnectionArguments(ConnectionArguments connectionArguments) {
        this.connectionArguments = connectionArguments;
    }

    public AlationSinkConnection withConnectionArguments(ConnectionArguments connectionArguments) {
        this.connectionArguments = connectionArguments;
        return this;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public Boolean getSupportsMetadataExtraction() {
        return this.supportsMetadataExtraction;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public void setSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
    }

    public AlationSinkConnection withSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(AlationSinkConnection.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("hostPort");
        sb.append('=');
        sb.append(this.hostPort == null ? "<null>" : this.hostPort);
        sb.append(',');
        sb.append("authType");
        sb.append('=');
        sb.append(this.authType == null ? "<null>" : this.authType);
        sb.append(',');
        sb.append("projectName");
        sb.append('=');
        sb.append(this.projectName == null ? "<null>" : this.projectName);
        sb.append(',');
        sb.append("paginationLimit");
        sb.append('=');
        sb.append(this.paginationLimit == null ? "<null>" : this.paginationLimit);
        sb.append(',');
        sb.append("datasourceLinks");
        sb.append('=');
        sb.append(this.datasourceLinks == null ? "<null>" : this.datasourceLinks);
        sb.append(',');
        sb.append("verifySSL");
        sb.append('=');
        sb.append(this.verifySSL == null ? "<null>" : this.verifySSL);
        sb.append(',');
        sb.append("sslConfig");
        sb.append('=');
        sb.append(this.sslConfig == null ? "<null>" : this.sslConfig);
        sb.append(',');
        sb.append("connectionOptions");
        sb.append('=');
        sb.append(this.connectionOptions == null ? "<null>" : this.connectionOptions);
        sb.append(',');
        sb.append("connectionArguments");
        sb.append('=');
        sb.append(this.connectionArguments == null ? "<null>" : this.connectionArguments);
        sb.append(',');
        sb.append("supportsMetadataExtraction");
        sb.append('=');
        sb.append(this.supportsMetadataExtraction == null ? "<null>" : this.supportsMetadataExtraction);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.supportsMetadataExtraction == null ? 0 : this.supportsMetadataExtraction.hashCode());
        result = result * 31 + (this.sslConfig == null ? 0 : this.sslConfig.hashCode());
        result = result * 31 + (this.datasourceLinks == null ? 0 : this.datasourceLinks.hashCode());
        result = result * 31 + (this.connectionOptions == null ? 0 : this.connectionOptions.hashCode());
        result = result * 31 + (this.verifySSL == null ? 0 : this.verifySSL.hashCode());
        result = result * 31 + (this.hostPort == null ? 0 : this.hostPort.hashCode());
        result = result * 31 + (this.paginationLimit == null ? 0 : this.paginationLimit.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.authType == null ? 0 : this.authType.hashCode());
        result = result * 31 + (this.projectName == null ? 0 : this.projectName.hashCode());
        result = result * 31 + (this.connectionArguments == null ? 0 : this.connectionArguments.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof AlationSinkConnection)) {
            return false;
        }
        AlationSinkConnection rhs = (AlationSinkConnection)other;
        return (this.supportsMetadataExtraction == rhs.supportsMetadataExtraction || this.supportsMetadataExtraction != null && this.supportsMetadataExtraction.equals(rhs.supportsMetadataExtraction)) && (this.sslConfig == rhs.sslConfig || this.sslConfig != null && this.sslConfig.equals(rhs.sslConfig)) && (this.datasourceLinks == rhs.datasourceLinks || this.datasourceLinks != null && this.datasourceLinks.equals(rhs.datasourceLinks)) && (this.connectionOptions == rhs.connectionOptions || this.connectionOptions != null && this.connectionOptions.equals(rhs.connectionOptions)) && (this.verifySSL == rhs.verifySSL || this.verifySSL != null && this.verifySSL.equals((Object)rhs.verifySSL)) && (this.hostPort == rhs.hostPort || this.hostPort != null && this.hostPort.equals(rhs.hostPort)) && (this.paginationLimit == rhs.paginationLimit || this.paginationLimit != null && this.paginationLimit.equals(rhs.paginationLimit)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.authType == rhs.authType || this.authType != null && this.authType.equals(rhs.authType)) && (this.projectName == rhs.projectName || this.projectName != null && this.projectName.equals(rhs.projectName)) && (this.connectionArguments == rhs.connectionArguments || this.connectionArguments != null && this.connectionArguments.equals(rhs.connectionArguments));
    }

    public static enum AlationSinkType {
        ALATION_SINK("AlationSink");

        private final String value;
        private static final Map<String, AlationSinkType> CONSTANTS;

        private AlationSinkType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static AlationSinkType fromValue(String value) {
            AlationSinkType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, AlationSinkType>();
            for (AlationSinkType c : AlationSinkType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

