/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.services.connections.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.openmetadata.annotations.ExposedField;
import org.openmetadata.annotations.PasswordField;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "username", "password", "hostPort", "maxConnectionLifeTime", "validateSSL", "encrypted", "supportsMetadataExtraction"})
public class AmundsenConnection {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Amundsen service type")
    private AmundsenType type = AmundsenType.fromValue("Amundsen");
    @JsonProperty(value="username")
    @JsonPropertyDescription(value="username to connect to the Amundsen Neo4j Connection.")
    @NotNull
    private String username;
    @JsonProperty(value="password")
    @JsonPropertyDescription(value="password to connect to the Amundsen Neo4j Connection.")
    @PasswordField
    @NotNull
    private String password;
    @JsonProperty(value="hostPort")
    @JsonPropertyDescription(value="Host and port of the Amundsen Neo4j Connection. This expect a URI format like: bolt://localhost:7687.")
    @ExposedField
    @NotNull
    private URI hostPort;
    @JsonProperty(value="maxConnectionLifeTime")
    @JsonPropertyDescription(value="Maximum connection lifetime for the Amundsen Neo4j Connection.")
    private Integer maxConnectionLifeTime = 50;
    @JsonProperty(value="validateSSL")
    @JsonPropertyDescription(value="Enable SSL validation for the Amundsen Neo4j Connection.")
    private Boolean validateSSL = false;
    @JsonProperty(value="encrypted")
    @JsonPropertyDescription(value="Enable encryption for the Amundsen Neo4j Connection.")
    private Boolean encrypted = false;
    @JsonProperty(value="supportsMetadataExtraction")
    @JsonPropertyDescription(value="Supports Metadata Extraction.")
    private Boolean supportsMetadataExtraction = true;

    @JsonProperty(value="type")
    public AmundsenType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(AmundsenType type) {
        this.type = type;
    }

    public AmundsenConnection withType(AmundsenType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="username")
    public String getUsername() {
        return this.username;
    }

    @JsonProperty(value="username")
    public void setUsername(String username) {
        this.username = username;
    }

    public AmundsenConnection withUsername(String username) {
        this.username = username;
        return this;
    }

    @JsonProperty(value="password")
    @PasswordField
    public String getPassword() {
        return this.password;
    }

    @JsonProperty(value="password")
    @PasswordField
    public void setPassword(String password) {
        this.password = password;
    }

    public AmundsenConnection withPassword(String password) {
        this.password = password;
        return this;
    }

    @JsonProperty(value="hostPort")
    @ExposedField
    public URI getHostPort() {
        return this.hostPort;
    }

    @JsonProperty(value="hostPort")
    @ExposedField
    public void setHostPort(URI hostPort) {
        this.hostPort = hostPort;
    }

    public AmundsenConnection withHostPort(URI hostPort) {
        this.hostPort = hostPort;
        return this;
    }

    @JsonProperty(value="maxConnectionLifeTime")
    public Integer getMaxConnectionLifeTime() {
        return this.maxConnectionLifeTime;
    }

    @JsonProperty(value="maxConnectionLifeTime")
    public void setMaxConnectionLifeTime(Integer maxConnectionLifeTime) {
        this.maxConnectionLifeTime = maxConnectionLifeTime;
    }

    public AmundsenConnection withMaxConnectionLifeTime(Integer maxConnectionLifeTime) {
        this.maxConnectionLifeTime = maxConnectionLifeTime;
        return this;
    }

    @JsonProperty(value="validateSSL")
    public Boolean getValidateSSL() {
        return this.validateSSL;
    }

    @JsonProperty(value="validateSSL")
    public void setValidateSSL(Boolean validateSSL) {
        this.validateSSL = validateSSL;
    }

    public AmundsenConnection withValidateSSL(Boolean validateSSL) {
        this.validateSSL = validateSSL;
        return this;
    }

    @JsonProperty(value="encrypted")
    public Boolean getEncrypted() {
        return this.encrypted;
    }

    @JsonProperty(value="encrypted")
    public void setEncrypted(Boolean encrypted) {
        this.encrypted = encrypted;
    }

    public AmundsenConnection withEncrypted(Boolean encrypted) {
        this.encrypted = encrypted;
        return this;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public Boolean getSupportsMetadataExtraction() {
        return this.supportsMetadataExtraction;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public void setSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
    }

    public AmundsenConnection withSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(AmundsenConnection.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("username");
        sb.append('=');
        sb.append(this.username == null ? "<null>" : this.username);
        sb.append(',');
        sb.append("password");
        sb.append('=');
        sb.append(this.password == null ? "<null>" : this.password);
        sb.append(',');
        sb.append("hostPort");
        sb.append('=');
        sb.append(this.hostPort == null ? "<null>" : this.hostPort);
        sb.append(',');
        sb.append("maxConnectionLifeTime");
        sb.append('=');
        sb.append(this.maxConnectionLifeTime == null ? "<null>" : this.maxConnectionLifeTime);
        sb.append(',');
        sb.append("validateSSL");
        sb.append('=');
        sb.append(this.validateSSL == null ? "<null>" : this.validateSSL);
        sb.append(',');
        sb.append("encrypted");
        sb.append('=');
        sb.append(this.encrypted == null ? "<null>" : this.encrypted);
        sb.append(',');
        sb.append("supportsMetadataExtraction");
        sb.append('=');
        sb.append(this.supportsMetadataExtraction == null ? "<null>" : this.supportsMetadataExtraction);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.supportsMetadataExtraction == null ? 0 : this.supportsMetadataExtraction.hashCode());
        result = result * 31 + (this.password == null ? 0 : this.password.hashCode());
        result = result * 31 + (this.encrypted == null ? 0 : this.encrypted.hashCode());
        result = result * 31 + (this.validateSSL == null ? 0 : this.validateSSL.hashCode());
        result = result * 31 + (this.hostPort == null ? 0 : this.hostPort.hashCode());
        result = result * 31 + (this.maxConnectionLifeTime == null ? 0 : this.maxConnectionLifeTime.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.username == null ? 0 : this.username.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof AmundsenConnection)) {
            return false;
        }
        AmundsenConnection rhs = (AmundsenConnection)other;
        return (this.supportsMetadataExtraction == rhs.supportsMetadataExtraction || this.supportsMetadataExtraction != null && this.supportsMetadataExtraction.equals(rhs.supportsMetadataExtraction)) && (this.password == rhs.password || this.password != null && this.password.equals(rhs.password)) && (this.encrypted == rhs.encrypted || this.encrypted != null && this.encrypted.equals(rhs.encrypted)) && (this.validateSSL == rhs.validateSSL || this.validateSSL != null && this.validateSSL.equals(rhs.validateSSL)) && (this.hostPort == rhs.hostPort || this.hostPort != null && this.hostPort.equals(rhs.hostPort)) && (this.maxConnectionLifeTime == rhs.maxConnectionLifeTime || this.maxConnectionLifeTime != null && this.maxConnectionLifeTime.equals(rhs.maxConnectionLifeTime)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.username == rhs.username || this.username != null && this.username.equals(rhs.username));
    }

    public static enum AmundsenType {
        AMUNDSEN("Amundsen");

        private final String value;
        private static final Map<String, AmundsenType> CONSTANTS;

        private AmundsenType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static AmundsenType fromValue(String value) {
            AmundsenType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, AmundsenType>();
            for (AmundsenType c : AmundsenType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

