/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.services.connections.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum AuthProvider {
    BASIC("basic"),
    AZURE("azure"),
    GOOGLE("google"),
    OKTA("okta"),
    AUTH_0("auth0"),
    AWS_COGNITO("aws-cognito"),
    CUSTOM_OIDC("custom-oidc"),
    LDAP("ldap"),
    SAML("saml"),
    OPENMETADATA("openmetadata");

    private final String value;
    private static final Map<String, AuthProvider> CONSTANTS;

    private AuthProvider(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static AuthProvider fromValue(String value) {
        AuthProvider constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, AuthProvider>();
        for (AuthProvider c : AuthProvider.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

