/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.services.connections.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.validation.Valid;
import org.openmetadata.schema.api.CreateEventPublisherJob;
import org.openmetadata.schema.type.IndexMappingLanguage;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "entities", "recreateIndex", "runMode", "searchIndexMappingLanguage", "batchSize", "supportsMetadataExtraction"})
public class MetadataESConnection {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Metadata to Elastic Search type")
    private MetadataESType type = MetadataESType.fromValue("MetadataES");
    @JsonProperty(value="entities")
    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonPropertyDescription(value="List of entities that you need to reindex")
    @Valid
    private Set<String> entities = new LinkedHashSet<String>(Arrays.asList("table", "topic", "dashboard", "pipeline", "mlmodel", "user", "team", "glossaryTerm", "tag", "entityReportData", "webAnalyticEntityViewReportData", "webAnalyticUserActivityReportData", "container", "query"));
    @JsonProperty(value="recreateIndex")
    private Boolean recreateIndex = true;
    @JsonProperty(value="runMode")
    @JsonPropertyDescription(value="This schema publisher run modes.")
    private CreateEventPublisherJob.RunMode runMode;
    @JsonProperty(value="searchIndexMappingLanguage")
    @JsonPropertyDescription(value="This schema defines the language options available for search index mappings.")
    private IndexMappingLanguage searchIndexMappingLanguage = IndexMappingLanguage.fromValue("EN");
    @JsonProperty(value="batchSize")
    @JsonPropertyDescription(value="Maximum number of events sent in a batch (Default 100).")
    private Integer batchSize = 100;
    @JsonProperty(value="supportsMetadataExtraction")
    @JsonPropertyDescription(value="Supports Metadata Extraction.")
    private Boolean supportsMetadataExtraction = true;

    @JsonProperty(value="type")
    public MetadataESType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(MetadataESType type) {
        this.type = type;
    }

    public MetadataESConnection withType(MetadataESType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="entities")
    public Set<String> getEntities() {
        return this.entities;
    }

    @JsonProperty(value="entities")
    public void setEntities(Set<String> entities) {
        this.entities = entities;
    }

    public MetadataESConnection withEntities(Set<String> entities) {
        this.entities = entities;
        return this;
    }

    @JsonProperty(value="recreateIndex")
    public Boolean getRecreateIndex() {
        return this.recreateIndex;
    }

    @JsonProperty(value="recreateIndex")
    public void setRecreateIndex(Boolean recreateIndex) {
        this.recreateIndex = recreateIndex;
    }

    public MetadataESConnection withRecreateIndex(Boolean recreateIndex) {
        this.recreateIndex = recreateIndex;
        return this;
    }

    @JsonProperty(value="runMode")
    public CreateEventPublisherJob.RunMode getRunMode() {
        return this.runMode;
    }

    @JsonProperty(value="runMode")
    public void setRunMode(CreateEventPublisherJob.RunMode runMode) {
        this.runMode = runMode;
    }

    public MetadataESConnection withRunMode(CreateEventPublisherJob.RunMode runMode) {
        this.runMode = runMode;
        return this;
    }

    @JsonProperty(value="searchIndexMappingLanguage")
    public IndexMappingLanguage getSearchIndexMappingLanguage() {
        return this.searchIndexMappingLanguage;
    }

    @JsonProperty(value="searchIndexMappingLanguage")
    public void setSearchIndexMappingLanguage(IndexMappingLanguage searchIndexMappingLanguage) {
        this.searchIndexMappingLanguage = searchIndexMappingLanguage;
    }

    public MetadataESConnection withSearchIndexMappingLanguage(IndexMappingLanguage searchIndexMappingLanguage) {
        this.searchIndexMappingLanguage = searchIndexMappingLanguage;
        return this;
    }

    @JsonProperty(value="batchSize")
    public Integer getBatchSize() {
        return this.batchSize;
    }

    @JsonProperty(value="batchSize")
    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    public MetadataESConnection withBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public Boolean getSupportsMetadataExtraction() {
        return this.supportsMetadataExtraction;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public void setSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
    }

    public MetadataESConnection withSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(MetadataESConnection.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("entities");
        sb.append('=');
        sb.append(this.entities == null ? "<null>" : this.entities);
        sb.append(',');
        sb.append("recreateIndex");
        sb.append('=');
        sb.append(this.recreateIndex == null ? "<null>" : this.recreateIndex);
        sb.append(',');
        sb.append("runMode");
        sb.append('=');
        sb.append(this.runMode == null ? "<null>" : this.runMode);
        sb.append(',');
        sb.append("searchIndexMappingLanguage");
        sb.append('=');
        sb.append(this.searchIndexMappingLanguage == null ? "<null>" : this.searchIndexMappingLanguage);
        sb.append(',');
        sb.append("batchSize");
        sb.append('=');
        sb.append(this.batchSize == null ? "<null>" : this.batchSize);
        sb.append(',');
        sb.append("supportsMetadataExtraction");
        sb.append('=');
        sb.append(this.supportsMetadataExtraction == null ? "<null>" : this.supportsMetadataExtraction);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.supportsMetadataExtraction == null ? 0 : this.supportsMetadataExtraction.hashCode());
        result = result * 31 + (this.entities == null ? 0 : this.entities.hashCode());
        result = result * 31 + (this.searchIndexMappingLanguage == null ? 0 : this.searchIndexMappingLanguage.hashCode());
        result = result * 31 + (this.recreateIndex == null ? 0 : this.recreateIndex.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.batchSize == null ? 0 : this.batchSize.hashCode());
        result = result * 31 + (this.runMode == null ? 0 : this.runMode.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof MetadataESConnection)) {
            return false;
        }
        MetadataESConnection rhs = (MetadataESConnection)other;
        return (this.supportsMetadataExtraction == rhs.supportsMetadataExtraction || this.supportsMetadataExtraction != null && this.supportsMetadataExtraction.equals(rhs.supportsMetadataExtraction)) && (this.entities == rhs.entities || this.entities != null && this.entities.equals(rhs.entities)) && (this.searchIndexMappingLanguage == rhs.searchIndexMappingLanguage || this.searchIndexMappingLanguage != null && this.searchIndexMappingLanguage.equals((Object)rhs.searchIndexMappingLanguage)) && (this.recreateIndex == rhs.recreateIndex || this.recreateIndex != null && this.recreateIndex.equals(rhs.recreateIndex)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.batchSize == rhs.batchSize || this.batchSize != null && this.batchSize.equals(rhs.batchSize)) && (this.runMode == rhs.runMode || this.runMode != null && this.runMode.equals((Object)rhs.runMode));
    }

    public static enum MetadataESType {
        METADATA_ES("MetadataES");

        private final String value;
        private static final Map<String, MetadataESType> CONSTANTS;

        private MetadataESType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static MetadataESType fromValue(String value) {
            MetadataESType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, MetadataESType>();
            for (MetadataESType c : MetadataESType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

