/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.services.connections.mlmodel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "trackingUri", "registryUri", "supportsMetadataExtraction"})
public class MlflowConnection {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Service type.")
    private MlflowType type = MlflowType.fromValue("Mlflow");
    @JsonProperty(value="trackingUri")
    @JsonPropertyDescription(value="Mlflow Experiment tracking URI. E.g., http://localhost:5000")
    @NotNull
    private String trackingUri;
    @JsonProperty(value="registryUri")
    @JsonPropertyDescription(value="Mlflow Model registry backend. E.g., mysql+pymysql://mlflow:password@localhost:3307/experiments")
    @NotNull
    private String registryUri;
    @JsonProperty(value="supportsMetadataExtraction")
    @JsonPropertyDescription(value="Supports Metadata Extraction.")
    private Boolean supportsMetadataExtraction = true;

    @JsonProperty(value="type")
    public MlflowType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(MlflowType type) {
        this.type = type;
    }

    public MlflowConnection withType(MlflowType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="trackingUri")
    public String getTrackingUri() {
        return this.trackingUri;
    }

    @JsonProperty(value="trackingUri")
    public void setTrackingUri(String trackingUri) {
        this.trackingUri = trackingUri;
    }

    public MlflowConnection withTrackingUri(String trackingUri) {
        this.trackingUri = trackingUri;
        return this;
    }

    @JsonProperty(value="registryUri")
    public String getRegistryUri() {
        return this.registryUri;
    }

    @JsonProperty(value="registryUri")
    public void setRegistryUri(String registryUri) {
        this.registryUri = registryUri;
    }

    public MlflowConnection withRegistryUri(String registryUri) {
        this.registryUri = registryUri;
        return this;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public Boolean getSupportsMetadataExtraction() {
        return this.supportsMetadataExtraction;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public void setSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
    }

    public MlflowConnection withSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(MlflowConnection.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("trackingUri");
        sb.append('=');
        sb.append(this.trackingUri == null ? "<null>" : this.trackingUri);
        sb.append(',');
        sb.append("registryUri");
        sb.append('=');
        sb.append(this.registryUri == null ? "<null>" : this.registryUri);
        sb.append(',');
        sb.append("supportsMetadataExtraction");
        sb.append('=');
        sb.append(this.supportsMetadataExtraction == null ? "<null>" : this.supportsMetadataExtraction);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.trackingUri == null ? 0 : this.trackingUri.hashCode());
        result = result * 31 + (this.supportsMetadataExtraction == null ? 0 : this.supportsMetadataExtraction.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.registryUri == null ? 0 : this.registryUri.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof MlflowConnection)) {
            return false;
        }
        MlflowConnection rhs = (MlflowConnection)other;
        return (this.trackingUri == rhs.trackingUri || this.trackingUri != null && this.trackingUri.equals(rhs.trackingUri)) && (this.supportsMetadataExtraction == rhs.supportsMetadataExtraction || this.supportsMetadataExtraction != null && this.supportsMetadataExtraction.equals(rhs.supportsMetadataExtraction)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.registryUri == rhs.registryUri || this.registryUri != null && this.registryUri.equals(rhs.registryUri));
    }

    public static enum MlflowType {
        MLFLOW("Mlflow");

        private final String value;
        private static final Map<String, MlflowType> CONSTANTS;

        private MlflowType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static MlflowType fromValue(String value) {
            MlflowType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, MlflowType>();
            for (MlflowType c : MlflowType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

