/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.services.connections.mlmodel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.security.credentials.GCPCredentials;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "credentials", "location"})
public class VertexAIConnection {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Service type.")
    private VertexAIType type = VertexAIType.fromValue("VertexAI");
    @JsonProperty(value="credentials")
    @JsonPropertyDescription(value="GCP credentials configs.")
    @Valid
    @NotNull
    private GCPCredentials credentials;
    @JsonProperty(value="location")
    @JsonPropertyDescription(value="location/region of google cloud project")
    @NotNull
    private String location;

    @JsonProperty(value="type")
    public VertexAIType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(VertexAIType type) {
        this.type = type;
    }

    public VertexAIConnection withType(VertexAIType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="credentials")
    public GCPCredentials getCredentials() {
        return this.credentials;
    }

    @JsonProperty(value="credentials")
    public void setCredentials(GCPCredentials credentials) {
        this.credentials = credentials;
    }

    public VertexAIConnection withCredentials(GCPCredentials credentials) {
        this.credentials = credentials;
        return this;
    }

    @JsonProperty(value="location")
    public String getLocation() {
        return this.location;
    }

    @JsonProperty(value="location")
    public void setLocation(String location) {
        this.location = location;
    }

    public VertexAIConnection withLocation(String location) {
        this.location = location;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(VertexAIConnection.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("credentials");
        sb.append('=');
        sb.append(this.credentials == null ? "<null>" : this.credentials);
        sb.append(',');
        sb.append("location");
        sb.append('=');
        sb.append(this.location == null ? "<null>" : this.location);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.location == null ? 0 : this.location.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.credentials == null ? 0 : this.credentials.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof VertexAIConnection)) {
            return false;
        }
        VertexAIConnection rhs = (VertexAIConnection)other;
        return (this.location == rhs.location || this.location != null && this.location.equals(rhs.location)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.credentials == rhs.credentials || this.credentials != null && this.credentials.equals(rhs.credentials));
    }

    public static enum VertexAIType {
        VERTEX_AI("VertexAI");

        private final String value;
        private static final Map<String, VertexAIType> CONSTANTS;

        private VertexAIType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static VertexAIType fromValue(String value) {
            VertexAIType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, VertexAIType>();
            for (VertexAIType c : VertexAIType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

