/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.services.connections.pipeline;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.openmetadata.annotations.ExposedField;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "hostPort", "numberOfStatus", "connection", "supportsMetadataExtraction"})
public class AirflowConnection {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Service type.")
    private AirflowType type = AirflowType.fromValue("Airflow");
    @JsonProperty(value="hostPort")
    @JsonPropertyDescription(value="Pipeline Service Management/UI URI.")
    @ExposedField
    @NotNull
    private URI hostPort;
    @JsonProperty(value="numberOfStatus")
    @JsonPropertyDescription(value="Pipeline Service Number Of Status")
    private Integer numberOfStatus = 10;
    @JsonProperty(value="connection")
    @JsonPropertyDescription(value="Underlying database connection. See https://airflow.apache.org/docs/apache-airflow/stable/howto/set-up-database.html for supported backends.")
    @NotNull
    private Object connection;
    @JsonProperty(value="supportsMetadataExtraction")
    @JsonPropertyDescription(value="Supports Metadata Extraction.")
    private Boolean supportsMetadataExtraction = true;

    @JsonProperty(value="type")
    public AirflowType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(AirflowType type) {
        this.type = type;
    }

    public AirflowConnection withType(AirflowType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="hostPort")
    @ExposedField
    public URI getHostPort() {
        return this.hostPort;
    }

    @JsonProperty(value="hostPort")
    @ExposedField
    public void setHostPort(URI hostPort) {
        this.hostPort = hostPort;
    }

    public AirflowConnection withHostPort(URI hostPort) {
        this.hostPort = hostPort;
        return this;
    }

    @JsonProperty(value="numberOfStatus")
    public Integer getNumberOfStatus() {
        return this.numberOfStatus;
    }

    @JsonProperty(value="numberOfStatus")
    public void setNumberOfStatus(Integer numberOfStatus) {
        this.numberOfStatus = numberOfStatus;
    }

    public AirflowConnection withNumberOfStatus(Integer numberOfStatus) {
        this.numberOfStatus = numberOfStatus;
        return this;
    }

    @JsonProperty(value="connection")
    public Object getConnection() {
        return this.connection;
    }

    @JsonProperty(value="connection")
    public void setConnection(Object connection) {
        this.connection = connection;
    }

    public AirflowConnection withConnection(Object connection) {
        this.connection = connection;
        return this;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public Boolean getSupportsMetadataExtraction() {
        return this.supportsMetadataExtraction;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public void setSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
    }

    public AirflowConnection withSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(AirflowConnection.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("hostPort");
        sb.append('=');
        sb.append(this.hostPort == null ? "<null>" : this.hostPort);
        sb.append(',');
        sb.append("numberOfStatus");
        sb.append('=');
        sb.append(this.numberOfStatus == null ? "<null>" : this.numberOfStatus);
        sb.append(',');
        sb.append("connection");
        sb.append('=');
        sb.append(this.connection == null ? "<null>" : this.connection);
        sb.append(',');
        sb.append("supportsMetadataExtraction");
        sb.append('=');
        sb.append(this.supportsMetadataExtraction == null ? "<null>" : this.supportsMetadataExtraction);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.supportsMetadataExtraction == null ? 0 : this.supportsMetadataExtraction.hashCode());
        result = result * 31 + (this.hostPort == null ? 0 : this.hostPort.hashCode());
        result = result * 31 + (this.connection == null ? 0 : this.connection.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.numberOfStatus == null ? 0 : this.numberOfStatus.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof AirflowConnection)) {
            return false;
        }
        AirflowConnection rhs = (AirflowConnection)other;
        return (this.supportsMetadataExtraction == rhs.supportsMetadataExtraction || this.supportsMetadataExtraction != null && this.supportsMetadataExtraction.equals(rhs.supportsMetadataExtraction)) && (this.hostPort == rhs.hostPort || this.hostPort != null && this.hostPort.equals(rhs.hostPort)) && (this.connection == rhs.connection || this.connection != null && this.connection.equals(rhs.connection)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.numberOfStatus == rhs.numberOfStatus || this.numberOfStatus != null && this.numberOfStatus.equals(rhs.numberOfStatus));
    }

    public static enum AirflowType {
        AIRFLOW("Airflow");

        private final String value;
        private static final Map<String, AirflowType> CONSTANTS;

        private AirflowType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static AirflowType fromValue(String value) {
            AirflowType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, AirflowType>();
            for (AirflowType c : AirflowType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

