/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.services.connections.pipeline;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type"})
public class BackendConnection {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Service type.")
    private BackendType type = BackendType.fromValue("Backend");

    @JsonProperty(value="type")
    public BackendType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(BackendType type) {
        this.type = type;
    }

    public BackendConnection withType(BackendType type) {
        this.type = type;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(BackendConnection.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof BackendConnection)) {
            return false;
        }
        BackendConnection rhs = (BackendConnection)other;
        return this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type);
    }

    public static enum BackendType {
        BACKEND("Backend");

        private final String value;
        private static final Map<String, BackendType> CONSTANTS;

        private BackendType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static BackendType fromValue(String value) {
            BackendType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, BackendType>();
            for (BackendType c : BackendType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

