/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.services.connections.pipeline;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.openmetadata.annotations.ExposedField;
import org.openmetadata.annotations.PasswordField;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "host", "discoveryAPI", "accountId", "jobId", "token"})
public class DBTCloudConnection {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Service type.")
    private DBTCloudType type = DBTCloudType.fromValue("DBTCloud");
    @JsonProperty(value="host")
    @JsonPropertyDescription(value="DBT cloud Access URL.")
    @ExposedField
    @NotNull
    private URI host;
    @JsonProperty(value="discoveryAPI")
    @JsonPropertyDescription(value="DBT cloud Metadata API URL.")
    @ExposedField
    @NotNull
    private URI discoveryAPI;
    @JsonProperty(value="accountId")
    @JsonPropertyDescription(value="ID of your DBT cloud account")
    @NotNull
    private String accountId;
    @JsonProperty(value="jobId")
    @JsonPropertyDescription(value="ID of your DBT cloud job")
    private String jobId = null;
    @JsonProperty(value="token")
    @JsonPropertyDescription(value="Generated Token to connect to DBTCloud.")
    @PasswordField
    @NotNull
    private String token;

    @JsonProperty(value="type")
    public DBTCloudType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(DBTCloudType type) {
        this.type = type;
    }

    public DBTCloudConnection withType(DBTCloudType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="host")
    @ExposedField
    public URI getHost() {
        return this.host;
    }

    @JsonProperty(value="host")
    @ExposedField
    public void setHost(URI host) {
        this.host = host;
    }

    public DBTCloudConnection withHost(URI host) {
        this.host = host;
        return this;
    }

    @JsonProperty(value="discoveryAPI")
    @ExposedField
    public URI getDiscoveryAPI() {
        return this.discoveryAPI;
    }

    @JsonProperty(value="discoveryAPI")
    @ExposedField
    public void setDiscoveryAPI(URI discoveryAPI) {
        this.discoveryAPI = discoveryAPI;
    }

    public DBTCloudConnection withDiscoveryAPI(URI discoveryAPI) {
        this.discoveryAPI = discoveryAPI;
        return this;
    }

    @JsonProperty(value="accountId")
    public String getAccountId() {
        return this.accountId;
    }

    @JsonProperty(value="accountId")
    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public DBTCloudConnection withAccountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @JsonProperty(value="jobId")
    public String getJobId() {
        return this.jobId;
    }

    @JsonProperty(value="jobId")
    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public DBTCloudConnection withJobId(String jobId) {
        this.jobId = jobId;
        return this;
    }

    @JsonProperty(value="token")
    @PasswordField
    public String getToken() {
        return this.token;
    }

    @JsonProperty(value="token")
    @PasswordField
    public void setToken(String token) {
        this.token = token;
    }

    public DBTCloudConnection withToken(String token) {
        this.token = token;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DBTCloudConnection.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("host");
        sb.append('=');
        sb.append(this.host == null ? "<null>" : this.host);
        sb.append(',');
        sb.append("discoveryAPI");
        sb.append('=');
        sb.append(this.discoveryAPI == null ? "<null>" : this.discoveryAPI);
        sb.append(',');
        sb.append("accountId");
        sb.append('=');
        sb.append(this.accountId == null ? "<null>" : this.accountId);
        sb.append(',');
        sb.append("jobId");
        sb.append('=');
        sb.append(this.jobId == null ? "<null>" : this.jobId);
        sb.append(',');
        sb.append("token");
        sb.append('=');
        sb.append(this.token == null ? "<null>" : this.token);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.accountId == null ? 0 : this.accountId.hashCode());
        result = result * 31 + (this.jobId == null ? 0 : this.jobId.hashCode());
        result = result * 31 + (this.host == null ? 0 : this.host.hashCode());
        result = result * 31 + (this.discoveryAPI == null ? 0 : this.discoveryAPI.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.token == null ? 0 : this.token.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof DBTCloudConnection)) {
            return false;
        }
        DBTCloudConnection rhs = (DBTCloudConnection)other;
        return (this.accountId == rhs.accountId || this.accountId != null && this.accountId.equals(rhs.accountId)) && (this.jobId == rhs.jobId || this.jobId != null && this.jobId.equals(rhs.jobId)) && (this.host == rhs.host || this.host != null && this.host.equals(rhs.host)) && (this.discoveryAPI == rhs.discoveryAPI || this.discoveryAPI != null && this.discoveryAPI.equals(rhs.discoveryAPI)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.token == rhs.token || this.token != null && this.token.equals(rhs.token));
    }

    public static enum DBTCloudType {
        DBT_CLOUD("DBTCloud");

        private final String value;
        private static final Map<String, DBTCloudType> CONSTANTS;

        private DBTCloudType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static DBTCloudType fromValue(String value) {
            DBTCloudType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, DBTCloudType>();
            for (DBTCloudType c : DBTCloudType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

