/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.services.connections.pipeline;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.annotations.ExposedField;
import org.openmetadata.schema.services.connections.pipeline.BasicAuthentication;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "hostPort", "KafkaConnectConfig", "verifySSL", "messagingServiceName"})
public class KafkaConnectConnection {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Service type.")
    private KafkaConnectType type = KafkaConnectType.fromValue("KafkaConnect");
    @JsonProperty(value="hostPort")
    @JsonPropertyDescription(value="KafkaConnect Service Management/UI URI.")
    @ExposedField
    @NotNull
    private URI hostPort;
    @JsonProperty(value="KafkaConnectConfig")
    @JsonPropertyDescription(value="username/password auth")
    @Valid
    private BasicAuthentication kafkaConnectConfig;
    @JsonProperty(value="verifySSL")
    @JsonPropertyDescription(value="Boolean marking if we need to verify the SSL certs for KafkaConnect REST API. True by default.")
    private Boolean verifySSL = true;
    @JsonProperty(value="messagingServiceName")
    @JsonPropertyDescription(value="Name of the Kafka Messaging Service associated with this KafkaConnect Pipeline Service. e.g. local_kafka")
    private String messagingServiceName;

    @JsonProperty(value="type")
    public KafkaConnectType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(KafkaConnectType type) {
        this.type = type;
    }

    public KafkaConnectConnection withType(KafkaConnectType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="hostPort")
    @ExposedField
    public URI getHostPort() {
        return this.hostPort;
    }

    @JsonProperty(value="hostPort")
    @ExposedField
    public void setHostPort(URI hostPort) {
        this.hostPort = hostPort;
    }

    public KafkaConnectConnection withHostPort(URI hostPort) {
        this.hostPort = hostPort;
        return this;
    }

    @JsonProperty(value="KafkaConnectConfig")
    public BasicAuthentication getKafkaConnectConfig() {
        return this.kafkaConnectConfig;
    }

    @JsonProperty(value="KafkaConnectConfig")
    public void setKafkaConnectConfig(BasicAuthentication kafkaConnectConfig) {
        this.kafkaConnectConfig = kafkaConnectConfig;
    }

    public KafkaConnectConnection withKafkaConnectConfig(BasicAuthentication kafkaConnectConfig) {
        this.kafkaConnectConfig = kafkaConnectConfig;
        return this;
    }

    @JsonProperty(value="verifySSL")
    public Boolean getVerifySSL() {
        return this.verifySSL;
    }

    @JsonProperty(value="verifySSL")
    public void setVerifySSL(Boolean verifySSL) {
        this.verifySSL = verifySSL;
    }

    public KafkaConnectConnection withVerifySSL(Boolean verifySSL) {
        this.verifySSL = verifySSL;
        return this;
    }

    @JsonProperty(value="messagingServiceName")
    public String getMessagingServiceName() {
        return this.messagingServiceName;
    }

    @JsonProperty(value="messagingServiceName")
    public void setMessagingServiceName(String messagingServiceName) {
        this.messagingServiceName = messagingServiceName;
    }

    public KafkaConnectConnection withMessagingServiceName(String messagingServiceName) {
        this.messagingServiceName = messagingServiceName;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(KafkaConnectConnection.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("hostPort");
        sb.append('=');
        sb.append(this.hostPort == null ? "<null>" : this.hostPort);
        sb.append(',');
        sb.append("kafkaConnectConfig");
        sb.append('=');
        sb.append(this.kafkaConnectConfig == null ? "<null>" : this.kafkaConnectConfig);
        sb.append(',');
        sb.append("verifySSL");
        sb.append('=');
        sb.append(this.verifySSL == null ? "<null>" : this.verifySSL);
        sb.append(',');
        sb.append("messagingServiceName");
        sb.append('=');
        sb.append(this.messagingServiceName == null ? "<null>" : this.messagingServiceName);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.verifySSL == null ? 0 : this.verifySSL.hashCode());
        result = result * 31 + (this.hostPort == null ? 0 : this.hostPort.hashCode());
        result = result * 31 + (this.kafkaConnectConfig == null ? 0 : this.kafkaConnectConfig.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.messagingServiceName == null ? 0 : this.messagingServiceName.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof KafkaConnectConnection)) {
            return false;
        }
        KafkaConnectConnection rhs = (KafkaConnectConnection)other;
        return (this.verifySSL == rhs.verifySSL || this.verifySSL != null && this.verifySSL.equals(rhs.verifySSL)) && (this.hostPort == rhs.hostPort || this.hostPort != null && this.hostPort.equals(rhs.hostPort)) && (this.kafkaConnectConfig == rhs.kafkaConnectConfig || this.kafkaConnectConfig != null && this.kafkaConnectConfig.equals(rhs.kafkaConnectConfig)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.messagingServiceName == rhs.messagingServiceName || this.messagingServiceName != null && this.messagingServiceName.equals(rhs.messagingServiceName));
    }

    public static enum KafkaConnectType {
        KAFKA_CONNECT("KafkaConnect");

        private final String value;
        private static final Map<String, KafkaConnectType> CONSTANTS;

        private KafkaConnectType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static KafkaConnectType fromValue(String value) {
            KafkaConnectType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, KafkaConnectType>();
            for (KafkaConnectType c : KafkaConnectType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

