/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.services.connections.pipeline;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import org.openmetadata.annotations.MaskedField;
import org.openmetadata.schema.security.sasl.SASLClientConfig;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "brokersUrl", "topicName", "consumerGroupName", "consumerOffsets", "poolTimeout", "sessionTimeout", "securityProtocol", "sslConfig", "saslConfig", "supportsMetadataExtraction"})
public class OpenLineageConnection {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Service type.")
    private OpenLineageType type = OpenLineageType.fromValue("OpenLineage");
    @JsonProperty(value="brokersUrl")
    @JsonPropertyDescription(value="service type of the messaging source")
    private String brokersUrl;
    @JsonProperty(value="topicName")
    @JsonPropertyDescription(value="topic from where Open lineage events will be pulled ")
    private String topicName;
    @JsonProperty(value="consumerGroupName")
    @JsonPropertyDescription(value="consumer group name ")
    private String consumerGroupName;
    @JsonProperty(value="consumerOffsets")
    @JsonPropertyDescription(value="initial Kafka consumer offset")
    private ConsumerOffsets consumerOffsets = ConsumerOffsets.fromValue("earliest");
    @JsonProperty(value="poolTimeout")
    @JsonPropertyDescription(value="max allowed wait time")
    private Double poolTimeout = 1.0;
    @JsonProperty(value="sessionTimeout")
    @JsonPropertyDescription(value="max allowed inactivity time")
    private Integer sessionTimeout = 30;
    @JsonProperty(value="securityProtocol")
    @JsonPropertyDescription(value="Kafka security protocol config")
    private SecurityProtocol securityProtocol = SecurityProtocol.fromValue("PLAINTEXT");
    @JsonProperty(value="sslConfig")
    @JsonPropertyDescription(value="Client SSL configuration")
    @MaskedField
    private Object sslConfig;
    @JsonProperty(value="saslConfig")
    @JsonPropertyDescription(value="SASL client configuration.")
    @Valid
    private SASLClientConfig saslConfig;
    @JsonProperty(value="supportsMetadataExtraction")
    @JsonPropertyDescription(value="Supports Metadata Extraction.")
    private Boolean supportsMetadataExtraction = true;

    @JsonProperty(value="type")
    public OpenLineageType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(OpenLineageType type) {
        this.type = type;
    }

    public OpenLineageConnection withType(OpenLineageType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="brokersUrl")
    public String getBrokersUrl() {
        return this.brokersUrl;
    }

    @JsonProperty(value="brokersUrl")
    public void setBrokersUrl(String brokersUrl) {
        this.brokersUrl = brokersUrl;
    }

    public OpenLineageConnection withBrokersUrl(String brokersUrl) {
        this.brokersUrl = brokersUrl;
        return this;
    }

    @JsonProperty(value="topicName")
    public String getTopicName() {
        return this.topicName;
    }

    @JsonProperty(value="topicName")
    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    public OpenLineageConnection withTopicName(String topicName) {
        this.topicName = topicName;
        return this;
    }

    @JsonProperty(value="consumerGroupName")
    public String getConsumerGroupName() {
        return this.consumerGroupName;
    }

    @JsonProperty(value="consumerGroupName")
    public void setConsumerGroupName(String consumerGroupName) {
        this.consumerGroupName = consumerGroupName;
    }

    public OpenLineageConnection withConsumerGroupName(String consumerGroupName) {
        this.consumerGroupName = consumerGroupName;
        return this;
    }

    @JsonProperty(value="consumerOffsets")
    public ConsumerOffsets getConsumerOffsets() {
        return this.consumerOffsets;
    }

    @JsonProperty(value="consumerOffsets")
    public void setConsumerOffsets(ConsumerOffsets consumerOffsets) {
        this.consumerOffsets = consumerOffsets;
    }

    public OpenLineageConnection withConsumerOffsets(ConsumerOffsets consumerOffsets) {
        this.consumerOffsets = consumerOffsets;
        return this;
    }

    @JsonProperty(value="poolTimeout")
    public Double getPoolTimeout() {
        return this.poolTimeout;
    }

    @JsonProperty(value="poolTimeout")
    public void setPoolTimeout(Double poolTimeout) {
        this.poolTimeout = poolTimeout;
    }

    public OpenLineageConnection withPoolTimeout(Double poolTimeout) {
        this.poolTimeout = poolTimeout;
        return this;
    }

    @JsonProperty(value="sessionTimeout")
    public Integer getSessionTimeout() {
        return this.sessionTimeout;
    }

    @JsonProperty(value="sessionTimeout")
    public void setSessionTimeout(Integer sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public OpenLineageConnection withSessionTimeout(Integer sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
        return this;
    }

    @JsonProperty(value="securityProtocol")
    public SecurityProtocol getSecurityProtocol() {
        return this.securityProtocol;
    }

    @JsonProperty(value="securityProtocol")
    public void setSecurityProtocol(SecurityProtocol securityProtocol) {
        this.securityProtocol = securityProtocol;
    }

    public OpenLineageConnection withSecurityProtocol(SecurityProtocol securityProtocol) {
        this.securityProtocol = securityProtocol;
        return this;
    }

    @JsonProperty(value="sslConfig")
    @MaskedField
    public Object getSslConfig() {
        return this.sslConfig;
    }

    @JsonProperty(value="sslConfig")
    @MaskedField
    public void setSslConfig(Object sslConfig) {
        this.sslConfig = sslConfig;
    }

    public OpenLineageConnection withSslConfig(Object sslConfig) {
        this.sslConfig = sslConfig;
        return this;
    }

    @JsonProperty(value="saslConfig")
    public SASLClientConfig getSaslConfig() {
        return this.saslConfig;
    }

    @JsonProperty(value="saslConfig")
    public void setSaslConfig(SASLClientConfig saslConfig) {
        this.saslConfig = saslConfig;
    }

    public OpenLineageConnection withSaslConfig(SASLClientConfig saslConfig) {
        this.saslConfig = saslConfig;
        return this;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public Boolean getSupportsMetadataExtraction() {
        return this.supportsMetadataExtraction;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public void setSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
    }

    public OpenLineageConnection withSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OpenLineageConnection.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("brokersUrl");
        sb.append('=');
        sb.append(this.brokersUrl == null ? "<null>" : this.brokersUrl);
        sb.append(',');
        sb.append("topicName");
        sb.append('=');
        sb.append(this.topicName == null ? "<null>" : this.topicName);
        sb.append(',');
        sb.append("consumerGroupName");
        sb.append('=');
        sb.append(this.consumerGroupName == null ? "<null>" : this.consumerGroupName);
        sb.append(',');
        sb.append("consumerOffsets");
        sb.append('=');
        sb.append(this.consumerOffsets == null ? "<null>" : this.consumerOffsets);
        sb.append(',');
        sb.append("poolTimeout");
        sb.append('=');
        sb.append(this.poolTimeout == null ? "<null>" : this.poolTimeout);
        sb.append(',');
        sb.append("sessionTimeout");
        sb.append('=');
        sb.append(this.sessionTimeout == null ? "<null>" : this.sessionTimeout);
        sb.append(',');
        sb.append("securityProtocol");
        sb.append('=');
        sb.append(this.securityProtocol == null ? "<null>" : this.securityProtocol);
        sb.append(',');
        sb.append("sslConfig");
        sb.append('=');
        sb.append(this.sslConfig == null ? "<null>" : this.sslConfig);
        sb.append(',');
        sb.append("saslConfig");
        sb.append('=');
        sb.append(this.saslConfig == null ? "<null>" : this.saslConfig);
        sb.append(',');
        sb.append("supportsMetadataExtraction");
        sb.append('=');
        sb.append(this.supportsMetadataExtraction == null ? "<null>" : this.supportsMetadataExtraction);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.saslConfig == null ? 0 : this.saslConfig.hashCode());
        result = result * 31 + (this.supportsMetadataExtraction == null ? 0 : this.supportsMetadataExtraction.hashCode());
        result = result * 31 + (this.securityProtocol == null ? 0 : this.securityProtocol.hashCode());
        result = result * 31 + (this.sslConfig == null ? 0 : this.sslConfig.hashCode());
        result = result * 31 + (this.consumerOffsets == null ? 0 : this.consumerOffsets.hashCode());
        result = result * 31 + (this.topicName == null ? 0 : this.topicName.hashCode());
        result = result * 31 + (this.sessionTimeout == null ? 0 : this.sessionTimeout.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.brokersUrl == null ? 0 : this.brokersUrl.hashCode());
        result = result * 31 + (this.consumerGroupName == null ? 0 : this.consumerGroupName.hashCode());
        result = result * 31 + (this.poolTimeout == null ? 0 : this.poolTimeout.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof OpenLineageConnection)) {
            return false;
        }
        OpenLineageConnection rhs = (OpenLineageConnection)other;
        return (this.saslConfig == rhs.saslConfig || this.saslConfig != null && this.saslConfig.equals(rhs.saslConfig)) && (this.supportsMetadataExtraction == rhs.supportsMetadataExtraction || this.supportsMetadataExtraction != null && this.supportsMetadataExtraction.equals(rhs.supportsMetadataExtraction)) && (this.securityProtocol == rhs.securityProtocol || this.securityProtocol != null && this.securityProtocol.equals((Object)rhs.securityProtocol)) && (this.sslConfig == rhs.sslConfig || this.sslConfig != null && this.sslConfig.equals(rhs.sslConfig)) && (this.consumerOffsets == rhs.consumerOffsets || this.consumerOffsets != null && this.consumerOffsets.equals((Object)rhs.consumerOffsets)) && (this.topicName == rhs.topicName || this.topicName != null && this.topicName.equals(rhs.topicName)) && (this.sessionTimeout == rhs.sessionTimeout || this.sessionTimeout != null && this.sessionTimeout.equals(rhs.sessionTimeout)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.brokersUrl == rhs.brokersUrl || this.brokersUrl != null && this.brokersUrl.equals(rhs.brokersUrl)) && (this.consumerGroupName == rhs.consumerGroupName || this.consumerGroupName != null && this.consumerGroupName.equals(rhs.consumerGroupName)) && (this.poolTimeout == rhs.poolTimeout || this.poolTimeout != null && this.poolTimeout.equals(rhs.poolTimeout));
    }

    public static enum OpenLineageType {
        OPEN_LINEAGE("OpenLineage");

        private final String value;
        private static final Map<String, OpenLineageType> CONSTANTS;

        private OpenLineageType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static OpenLineageType fromValue(String value) {
            OpenLineageType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, OpenLineageType>();
            for (OpenLineageType c : OpenLineageType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum ConsumerOffsets {
        earliest("earliest"),
        latest("latest");

        private final String value;
        private static final Map<String, ConsumerOffsets> CONSTANTS;

        private ConsumerOffsets(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ConsumerOffsets fromValue(String value) {
            ConsumerOffsets constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, ConsumerOffsets>();
            for (ConsumerOffsets c : ConsumerOffsets.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum SecurityProtocol {
        PLAINTEXT("PLAINTEXT"),
        SSL("SSL"),
        SASL_SSL("SASL_SSL");

        private final String value;
        private static final Map<String, SecurityProtocol> CONSTANTS;

        private SecurityProtocol(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static SecurityProtocol fromValue(String value) {
            SecurityProtocol constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, SecurityProtocol>();
            for (SecurityProtocol c : SecurityProtocol.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

