/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.services.connections.pipeline;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type"})
public class SparkConnection {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Service type.")
    private SparkType type = SparkType.fromValue("Spark");

    @JsonProperty(value="type")
    public SparkType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(SparkType type) {
        this.type = type;
    }

    public SparkConnection withType(SparkType type) {
        this.type = type;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(SparkConnection.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SparkConnection)) {
            return false;
        }
        SparkConnection rhs = (SparkConnection)other;
        return this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type);
    }

    public static enum SparkType {
        SPARK("Spark");

        private final String value;
        private static final Map<String, SparkType> CONSTANTS;

        private SparkType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static SparkType fromValue(String value) {
            SparkType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, SparkType>();
            for (SparkType c : SparkType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

