/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.services.connections.pipeline;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.openmetadata.annotations.ExposedField;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "hostPort", "uiHostPort", "supportsMetadataExtraction"})
public class SplineConnection {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Service type.")
    private SplineType type = SplineType.fromValue("Spline");
    @JsonProperty(value="hostPort")
    @JsonPropertyDescription(value="Spline REST Server Host & Port.")
    @ExposedField
    @NotNull
    private URI hostPort;
    @JsonProperty(value="uiHostPort")
    @JsonPropertyDescription(value="Spline UI Host & Port.")
    @ExposedField
    private URI uiHostPort;
    @JsonProperty(value="supportsMetadataExtraction")
    @JsonPropertyDescription(value="Supports Metadata Extraction.")
    private Boolean supportsMetadataExtraction = true;

    @JsonProperty(value="type")
    public SplineType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(SplineType type) {
        this.type = type;
    }

    public SplineConnection withType(SplineType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="hostPort")
    @ExposedField
    public URI getHostPort() {
        return this.hostPort;
    }

    @JsonProperty(value="hostPort")
    @ExposedField
    public void setHostPort(URI hostPort) {
        this.hostPort = hostPort;
    }

    public SplineConnection withHostPort(URI hostPort) {
        this.hostPort = hostPort;
        return this;
    }

    @JsonProperty(value="uiHostPort")
    @ExposedField
    public URI getUiHostPort() {
        return this.uiHostPort;
    }

    @JsonProperty(value="uiHostPort")
    @ExposedField
    public void setUiHostPort(URI uiHostPort) {
        this.uiHostPort = uiHostPort;
    }

    public SplineConnection withUiHostPort(URI uiHostPort) {
        this.uiHostPort = uiHostPort;
        return this;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public Boolean getSupportsMetadataExtraction() {
        return this.supportsMetadataExtraction;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public void setSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
    }

    public SplineConnection withSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(SplineConnection.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("hostPort");
        sb.append('=');
        sb.append(this.hostPort == null ? "<null>" : this.hostPort);
        sb.append(',');
        sb.append("uiHostPort");
        sb.append('=');
        sb.append(this.uiHostPort == null ? "<null>" : this.uiHostPort);
        sb.append(',');
        sb.append("supportsMetadataExtraction");
        sb.append('=');
        sb.append(this.supportsMetadataExtraction == null ? "<null>" : this.supportsMetadataExtraction);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.supportsMetadataExtraction == null ? 0 : this.supportsMetadataExtraction.hashCode());
        result = result * 31 + (this.hostPort == null ? 0 : this.hostPort.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.uiHostPort == null ? 0 : this.uiHostPort.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SplineConnection)) {
            return false;
        }
        SplineConnection rhs = (SplineConnection)other;
        return (this.supportsMetadataExtraction == rhs.supportsMetadataExtraction || this.supportsMetadataExtraction != null && this.supportsMetadataExtraction.equals(rhs.supportsMetadataExtraction)) && (this.hostPort == rhs.hostPort || this.hostPort != null && this.hostPort.equals(rhs.hostPort)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.uiHostPort == rhs.uiHostPort || this.uiHostPort != null && this.uiHostPort.equals(rhs.uiHostPort));
    }

    public static enum SplineType {
        SPLINE("Spline");

        private final String value;
        private static final Map<String, SplineType> CONSTANTS;

        private SplineType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static SplineType fromValue(String value) {
            SplineType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, SplineType>();
            for (SplineType c : SplineType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

