/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.services.connections.search;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import org.openmetadata.schema.services.common.SSLConfig;
import org.openmetadata.schema.services.connections.database.ConnectionArguments;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "hostPort", "authType", "sslConfig", "connectionTimeoutSecs", "connectionArguments", "supportsMetadataExtraction"})
public class ElasticSearchConnection {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="ElasticSearch service type")
    private ElasticSearchType type = ElasticSearchType.fromValue("ElasticSearch");
    @JsonProperty(value="hostPort")
    @JsonPropertyDescription(value="Host and port of the ElasticSearch service.")
    private URI hostPort;
    @JsonProperty(value="authType")
    @JsonPropertyDescription(value="Choose Auth Config Type.")
    private Object authType;
    @JsonProperty(value="sslConfig")
    @JsonPropertyDescription(value="SSL Config")
    @Valid
    private SSLConfig sslConfig;
    @JsonProperty(value="connectionTimeoutSecs")
    @JsonPropertyDescription(value="Connection Timeout in Seconds")
    private Integer connectionTimeoutSecs = 30;
    @JsonProperty(value="connectionArguments")
    @JsonPropertyDescription(value="Additional connection arguments such as security or protocol configs that can be sent to service during connection.")
    @Valid
    private ConnectionArguments connectionArguments;
    @JsonProperty(value="supportsMetadataExtraction")
    @JsonPropertyDescription(value="Supports Metadata Extraction.")
    private Boolean supportsMetadataExtraction = true;

    @JsonProperty(value="type")
    public ElasticSearchType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(ElasticSearchType type) {
        this.type = type;
    }

    public ElasticSearchConnection withType(ElasticSearchType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="hostPort")
    public URI getHostPort() {
        return this.hostPort;
    }

    @JsonProperty(value="hostPort")
    public void setHostPort(URI hostPort) {
        this.hostPort = hostPort;
    }

    public ElasticSearchConnection withHostPort(URI hostPort) {
        this.hostPort = hostPort;
        return this;
    }

    @JsonProperty(value="authType")
    public Object getAuthType() {
        return this.authType;
    }

    @JsonProperty(value="authType")
    public void setAuthType(Object authType) {
        this.authType = authType;
    }

    public ElasticSearchConnection withAuthType(Object authType) {
        this.authType = authType;
        return this;
    }

    @JsonProperty(value="sslConfig")
    public SSLConfig getSslConfig() {
        return this.sslConfig;
    }

    @JsonProperty(value="sslConfig")
    public void setSslConfig(SSLConfig sslConfig) {
        this.sslConfig = sslConfig;
    }

    public ElasticSearchConnection withSslConfig(SSLConfig sslConfig) {
        this.sslConfig = sslConfig;
        return this;
    }

    @JsonProperty(value="connectionTimeoutSecs")
    public Integer getConnectionTimeoutSecs() {
        return this.connectionTimeoutSecs;
    }

    @JsonProperty(value="connectionTimeoutSecs")
    public void setConnectionTimeoutSecs(Integer connectionTimeoutSecs) {
        this.connectionTimeoutSecs = connectionTimeoutSecs;
    }

    public ElasticSearchConnection withConnectionTimeoutSecs(Integer connectionTimeoutSecs) {
        this.connectionTimeoutSecs = connectionTimeoutSecs;
        return this;
    }

    @JsonProperty(value="connectionArguments")
    public ConnectionArguments getConnectionArguments() {
        return this.connectionArguments;
    }

    @JsonProperty(value="connectionArguments")
    public void setConnectionArguments(ConnectionArguments connectionArguments) {
        this.connectionArguments = connectionArguments;
    }

    public ElasticSearchConnection withConnectionArguments(ConnectionArguments connectionArguments) {
        this.connectionArguments = connectionArguments;
        return this;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public Boolean getSupportsMetadataExtraction() {
        return this.supportsMetadataExtraction;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public void setSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
    }

    public ElasticSearchConnection withSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ElasticSearchConnection.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("hostPort");
        sb.append('=');
        sb.append(this.hostPort == null ? "<null>" : this.hostPort);
        sb.append(',');
        sb.append("authType");
        sb.append('=');
        sb.append(this.authType == null ? "<null>" : this.authType);
        sb.append(',');
        sb.append("sslConfig");
        sb.append('=');
        sb.append(this.sslConfig == null ? "<null>" : this.sslConfig);
        sb.append(',');
        sb.append("connectionTimeoutSecs");
        sb.append('=');
        sb.append(this.connectionTimeoutSecs == null ? "<null>" : this.connectionTimeoutSecs);
        sb.append(',');
        sb.append("connectionArguments");
        sb.append('=');
        sb.append(this.connectionArguments == null ? "<null>" : this.connectionArguments);
        sb.append(',');
        sb.append("supportsMetadataExtraction");
        sb.append('=');
        sb.append(this.supportsMetadataExtraction == null ? "<null>" : this.supportsMetadataExtraction);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.supportsMetadataExtraction == null ? 0 : this.supportsMetadataExtraction.hashCode());
        result = result * 31 + (this.connectionTimeoutSecs == null ? 0 : this.connectionTimeoutSecs.hashCode());
        result = result * 31 + (this.sslConfig == null ? 0 : this.sslConfig.hashCode());
        result = result * 31 + (this.hostPort == null ? 0 : this.hostPort.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.authType == null ? 0 : this.authType.hashCode());
        result = result * 31 + (this.connectionArguments == null ? 0 : this.connectionArguments.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ElasticSearchConnection)) {
            return false;
        }
        ElasticSearchConnection rhs = (ElasticSearchConnection)other;
        return (this.supportsMetadataExtraction == rhs.supportsMetadataExtraction || this.supportsMetadataExtraction != null && this.supportsMetadataExtraction.equals(rhs.supportsMetadataExtraction)) && (this.connectionTimeoutSecs == rhs.connectionTimeoutSecs || this.connectionTimeoutSecs != null && this.connectionTimeoutSecs.equals(rhs.connectionTimeoutSecs)) && (this.sslConfig == rhs.sslConfig || this.sslConfig != null && this.sslConfig.equals(rhs.sslConfig)) && (this.hostPort == rhs.hostPort || this.hostPort != null && this.hostPort.equals(rhs.hostPort)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.authType == rhs.authType || this.authType != null && this.authType.equals(rhs.authType)) && (this.connectionArguments == rhs.connectionArguments || this.connectionArguments != null && this.connectionArguments.equals(rhs.connectionArguments));
    }

    public static enum ElasticSearchType {
        ELASTIC_SEARCH("ElasticSearch");

        private final String value;
        private static final Map<String, ElasticSearchType> CONSTANTS;

        private ElasticSearchType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ElasticSearchType fromValue(String value) {
            ElasticSearchType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, ElasticSearchType>();
            for (ElasticSearchType c : ElasticSearchType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

