/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.services.connections.search;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.services.connections.database.ConnectionArguments;
import org.openmetadata.schema.services.connections.database.ConnectionOptions;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "hostPort", "scheme", "username", "password", "truststorePath", "truststorePassword", "connectionTimeoutSecs", "socketTimeoutSecs", "keepAliveTimeoutSecs", "connectionOptions", "connectionArguments", "supportsMetadataExtraction"})
public class OpenSearchConnection {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="OpenSearch service type")
    private OpenSearchType type = OpenSearchType.fromValue("OpenSearch");
    @JsonProperty(value="hostPort")
    @JsonPropertyDescription(value="Host and port of the OpenSearch service.")
    @NotNull
    private String hostPort;
    @JsonProperty(value="scheme")
    @JsonPropertyDescription(value="Http/Https connection scheme")
    private String scheme;
    @JsonProperty(value="username")
    @JsonPropertyDescription(value="OpenSearch Username for Login")
    private String username;
    @JsonProperty(value="password")
    @JsonPropertyDescription(value="OpenSearch Password for Login")
    private String password;
    @JsonProperty(value="truststorePath")
    @JsonPropertyDescription(value="Truststore Path")
    private String truststorePath;
    @JsonProperty(value="truststorePassword")
    @JsonPropertyDescription(value="Truststore Password")
    private String truststorePassword;
    @JsonProperty(value="connectionTimeoutSecs")
    @JsonPropertyDescription(value="Connection Timeout in Seconds")
    private Integer connectionTimeoutSecs = 5;
    @JsonProperty(value="socketTimeoutSecs")
    @JsonPropertyDescription(value="Socket Timeout in Seconds")
    private Integer socketTimeoutSecs = 60;
    @JsonProperty(value="keepAliveTimeoutSecs")
    @JsonPropertyDescription(value="Keep Alive Timeout in Seconds")
    private Integer keepAliveTimeoutSecs;
    @JsonProperty(value="connectionOptions")
    @JsonPropertyDescription(value="Additional connection options to build the URL that can be sent to service during the connection.")
    @Valid
    private ConnectionOptions connectionOptions;
    @JsonProperty(value="connectionArguments")
    @JsonPropertyDescription(value="Additional connection arguments such as security or protocol configs that can be sent to service during connection.")
    @Valid
    private ConnectionArguments connectionArguments;
    @JsonProperty(value="supportsMetadataExtraction")
    @JsonPropertyDescription(value="Supports Metadata Extraction.")
    private Boolean supportsMetadataExtraction = true;

    @JsonProperty(value="type")
    public OpenSearchType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(OpenSearchType type) {
        this.type = type;
    }

    public OpenSearchConnection withType(OpenSearchType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="hostPort")
    public String getHostPort() {
        return this.hostPort;
    }

    @JsonProperty(value="hostPort")
    public void setHostPort(String hostPort) {
        this.hostPort = hostPort;
    }

    public OpenSearchConnection withHostPort(String hostPort) {
        this.hostPort = hostPort;
        return this;
    }

    @JsonProperty(value="scheme")
    public String getScheme() {
        return this.scheme;
    }

    @JsonProperty(value="scheme")
    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public OpenSearchConnection withScheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    @JsonProperty(value="username")
    public String getUsername() {
        return this.username;
    }

    @JsonProperty(value="username")
    public void setUsername(String username) {
        this.username = username;
    }

    public OpenSearchConnection withUsername(String username) {
        this.username = username;
        return this;
    }

    @JsonProperty(value="password")
    public String getPassword() {
        return this.password;
    }

    @JsonProperty(value="password")
    public void setPassword(String password) {
        this.password = password;
    }

    public OpenSearchConnection withPassword(String password) {
        this.password = password;
        return this;
    }

    @JsonProperty(value="truststorePath")
    public String getTruststorePath() {
        return this.truststorePath;
    }

    @JsonProperty(value="truststorePath")
    public void setTruststorePath(String truststorePath) {
        this.truststorePath = truststorePath;
    }

    public OpenSearchConnection withTruststorePath(String truststorePath) {
        this.truststorePath = truststorePath;
        return this;
    }

    @JsonProperty(value="truststorePassword")
    public String getTruststorePassword() {
        return this.truststorePassword;
    }

    @JsonProperty(value="truststorePassword")
    public void setTruststorePassword(String truststorePassword) {
        this.truststorePassword = truststorePassword;
    }

    public OpenSearchConnection withTruststorePassword(String truststorePassword) {
        this.truststorePassword = truststorePassword;
        return this;
    }

    @JsonProperty(value="connectionTimeoutSecs")
    public Integer getConnectionTimeoutSecs() {
        return this.connectionTimeoutSecs;
    }

    @JsonProperty(value="connectionTimeoutSecs")
    public void setConnectionTimeoutSecs(Integer connectionTimeoutSecs) {
        this.connectionTimeoutSecs = connectionTimeoutSecs;
    }

    public OpenSearchConnection withConnectionTimeoutSecs(Integer connectionTimeoutSecs) {
        this.connectionTimeoutSecs = connectionTimeoutSecs;
        return this;
    }

    @JsonProperty(value="socketTimeoutSecs")
    public Integer getSocketTimeoutSecs() {
        return this.socketTimeoutSecs;
    }

    @JsonProperty(value="socketTimeoutSecs")
    public void setSocketTimeoutSecs(Integer socketTimeoutSecs) {
        this.socketTimeoutSecs = socketTimeoutSecs;
    }

    public OpenSearchConnection withSocketTimeoutSecs(Integer socketTimeoutSecs) {
        this.socketTimeoutSecs = socketTimeoutSecs;
        return this;
    }

    @JsonProperty(value="keepAliveTimeoutSecs")
    public Integer getKeepAliveTimeoutSecs() {
        return this.keepAliveTimeoutSecs;
    }

    @JsonProperty(value="keepAliveTimeoutSecs")
    public void setKeepAliveTimeoutSecs(Integer keepAliveTimeoutSecs) {
        this.keepAliveTimeoutSecs = keepAliveTimeoutSecs;
    }

    public OpenSearchConnection withKeepAliveTimeoutSecs(Integer keepAliveTimeoutSecs) {
        this.keepAliveTimeoutSecs = keepAliveTimeoutSecs;
        return this;
    }

    @JsonProperty(value="connectionOptions")
    public ConnectionOptions getConnectionOptions() {
        return this.connectionOptions;
    }

    @JsonProperty(value="connectionOptions")
    public void setConnectionOptions(ConnectionOptions connectionOptions) {
        this.connectionOptions = connectionOptions;
    }

    public OpenSearchConnection withConnectionOptions(ConnectionOptions connectionOptions) {
        this.connectionOptions = connectionOptions;
        return this;
    }

    @JsonProperty(value="connectionArguments")
    public ConnectionArguments getConnectionArguments() {
        return this.connectionArguments;
    }

    @JsonProperty(value="connectionArguments")
    public void setConnectionArguments(ConnectionArguments connectionArguments) {
        this.connectionArguments = connectionArguments;
    }

    public OpenSearchConnection withConnectionArguments(ConnectionArguments connectionArguments) {
        this.connectionArguments = connectionArguments;
        return this;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public Boolean getSupportsMetadataExtraction() {
        return this.supportsMetadataExtraction;
    }

    @JsonProperty(value="supportsMetadataExtraction")
    public void setSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
    }

    public OpenSearchConnection withSupportsMetadataExtraction(Boolean supportsMetadataExtraction) {
        this.supportsMetadataExtraction = supportsMetadataExtraction;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OpenSearchConnection.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("hostPort");
        sb.append('=');
        sb.append(this.hostPort == null ? "<null>" : this.hostPort);
        sb.append(',');
        sb.append("scheme");
        sb.append('=');
        sb.append(this.scheme == null ? "<null>" : this.scheme);
        sb.append(',');
        sb.append("username");
        sb.append('=');
        sb.append(this.username == null ? "<null>" : this.username);
        sb.append(',');
        sb.append("password");
        sb.append('=');
        sb.append(this.password == null ? "<null>" : this.password);
        sb.append(',');
        sb.append("truststorePath");
        sb.append('=');
        sb.append(this.truststorePath == null ? "<null>" : this.truststorePath);
        sb.append(',');
        sb.append("truststorePassword");
        sb.append('=');
        sb.append(this.truststorePassword == null ? "<null>" : this.truststorePassword);
        sb.append(',');
        sb.append("connectionTimeoutSecs");
        sb.append('=');
        sb.append(this.connectionTimeoutSecs == null ? "<null>" : this.connectionTimeoutSecs);
        sb.append(',');
        sb.append("socketTimeoutSecs");
        sb.append('=');
        sb.append(this.socketTimeoutSecs == null ? "<null>" : this.socketTimeoutSecs);
        sb.append(',');
        sb.append("keepAliveTimeoutSecs");
        sb.append('=');
        sb.append(this.keepAliveTimeoutSecs == null ? "<null>" : this.keepAliveTimeoutSecs);
        sb.append(',');
        sb.append("connectionOptions");
        sb.append('=');
        sb.append(this.connectionOptions == null ? "<null>" : this.connectionOptions);
        sb.append(',');
        sb.append("connectionArguments");
        sb.append('=');
        sb.append(this.connectionArguments == null ? "<null>" : this.connectionArguments);
        sb.append(',');
        sb.append("supportsMetadataExtraction");
        sb.append('=');
        sb.append(this.supportsMetadataExtraction == null ? "<null>" : this.supportsMetadataExtraction);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.supportsMetadataExtraction == null ? 0 : this.supportsMetadataExtraction.hashCode());
        result = result * 31 + (this.scheme == null ? 0 : this.scheme.hashCode());
        result = result * 31 + (this.socketTimeoutSecs == null ? 0 : this.socketTimeoutSecs.hashCode());
        result = result * 31 + (this.keepAliveTimeoutSecs == null ? 0 : this.keepAliveTimeoutSecs.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.truststorePath == null ? 0 : this.truststorePath.hashCode());
        result = result * 31 + (this.connectionArguments == null ? 0 : this.connectionArguments.hashCode());
        result = result * 31 + (this.password == null ? 0 : this.password.hashCode());
        result = result * 31 + (this.truststorePassword == null ? 0 : this.truststorePassword.hashCode());
        result = result * 31 + (this.connectionTimeoutSecs == null ? 0 : this.connectionTimeoutSecs.hashCode());
        result = result * 31 + (this.connectionOptions == null ? 0 : this.connectionOptions.hashCode());
        result = result * 31 + (this.hostPort == null ? 0 : this.hostPort.hashCode());
        result = result * 31 + (this.username == null ? 0 : this.username.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof OpenSearchConnection)) {
            return false;
        }
        OpenSearchConnection rhs = (OpenSearchConnection)other;
        return (this.supportsMetadataExtraction == rhs.supportsMetadataExtraction || this.supportsMetadataExtraction != null && this.supportsMetadataExtraction.equals(rhs.supportsMetadataExtraction)) && (this.scheme == rhs.scheme || this.scheme != null && this.scheme.equals(rhs.scheme)) && (this.socketTimeoutSecs == rhs.socketTimeoutSecs || this.socketTimeoutSecs != null && this.socketTimeoutSecs.equals(rhs.socketTimeoutSecs)) && (this.keepAliveTimeoutSecs == rhs.keepAliveTimeoutSecs || this.keepAliveTimeoutSecs != null && this.keepAliveTimeoutSecs.equals(rhs.keepAliveTimeoutSecs)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.truststorePath == rhs.truststorePath || this.truststorePath != null && this.truststorePath.equals(rhs.truststorePath)) && (this.connectionArguments == rhs.connectionArguments || this.connectionArguments != null && this.connectionArguments.equals(rhs.connectionArguments)) && (this.password == rhs.password || this.password != null && this.password.equals(rhs.password)) && (this.truststorePassword == rhs.truststorePassword || this.truststorePassword != null && this.truststorePassword.equals(rhs.truststorePassword)) && (this.connectionTimeoutSecs == rhs.connectionTimeoutSecs || this.connectionTimeoutSecs != null && this.connectionTimeoutSecs.equals(rhs.connectionTimeoutSecs)) && (this.connectionOptions == rhs.connectionOptions || this.connectionOptions != null && this.connectionOptions.equals(rhs.connectionOptions)) && (this.hostPort == rhs.hostPort || this.hostPort != null && this.hostPort.equals(rhs.hostPort)) && (this.username == rhs.username || this.username != null && this.username.equals(rhs.username));
    }

    public static enum OpenSearchType {
        OPEN_SEARCH("OpenSearch");

        private final String value;
        private static final Map<String, OpenSearchType> CONSTANTS;

        private OpenSearchType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static OpenSearchType fromValue(String value) {
            OpenSearchType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, OpenSearchType>();
            for (OpenSearchType c : OpenSearchType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

