/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.system;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.system.IndexingError;
import org.openmetadata.schema.system.Stats;
import org.openmetadata.schema.type.IndexMappingLanguage;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "timestamp", "status", "failure", "stats", "entities", "recreateIndex", "batchSize", "payLoadSize", "producerThreads", "consumerThreads", "queueSize", "maxConcurrentRequests", "maxRetries", "initialBackoff", "maxBackoff", "searchIndexMappingLanguage", "afterCursor"})
public class EventPublisherJob {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name of the result")
    private String name;
    @JsonProperty(value="timestamp")
    @JsonPropertyDescription(value="Timestamp in Unix epoch time milliseconds.")
    @NotNull
    private Long timestamp;
    @JsonProperty(value="status")
    @JsonPropertyDescription(value="This schema publisher run job status.")
    @NotNull
    private Status status;
    @JsonProperty(value="failure")
    @JsonPropertyDescription(value="This schema defines Event Publisher Job Error Schema.")
    @Valid
    private IndexingError failure;
    @JsonProperty(value="stats")
    @Valid
    private Stats stats;
    @JsonProperty(value="entities")
    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonPropertyDescription(value="List of Entities to Reindex")
    @Valid
    private Set<String> entities = new LinkedHashSet<String>();
    @JsonProperty(value="recreateIndex")
    @JsonPropertyDescription(value="This schema publisher run modes.")
    private Boolean recreateIndex;
    @JsonProperty(value="batchSize")
    @JsonPropertyDescription(value="Maximum number of events sent in a batch (Default 10).")
    private Integer batchSize = 100;
    @JsonProperty(value="payLoadSize")
    @JsonPropertyDescription(value="Payload size in bytes depending on config.")
    private Long payLoadSize = 0x6400000L;
    @JsonProperty(value="producerThreads")
    @JsonPropertyDescription(value="Number of producer threads to use for reindexing")
    private Integer producerThreads = 1;
    @JsonProperty(value="consumerThreads")
    @JsonPropertyDescription(value="Number of consumer threads to use for reindexing")
    private Integer consumerThreads = 1;
    @JsonProperty(value="queueSize")
    @JsonPropertyDescription(value="Queue Size to user internally for reindexing.")
    private Integer queueSize = 100;
    @JsonProperty(value="maxConcurrentRequests")
    @JsonPropertyDescription(value="Maximum number of concurrent requests to the search index")
    private Integer maxConcurrentRequests = 100;
    @JsonProperty(value="maxRetries")
    @JsonPropertyDescription(value="Maximum number of retries for a failed request")
    private Integer maxRetries = 5;
    @JsonProperty(value="initialBackoff")
    @JsonPropertyDescription(value="Initial backoff time in milliseconds")
    private Integer initialBackoff = 1000;
    @JsonProperty(value="maxBackoff")
    @JsonPropertyDescription(value="Maximum backoff time in milliseconds")
    private Integer maxBackoff = 10000;
    @JsonProperty(value="searchIndexMappingLanguage")
    @JsonPropertyDescription(value="This schema defines the language options available for search index mappings.")
    private IndexMappingLanguage searchIndexMappingLanguage = IndexMappingLanguage.fromValue("EN");
    @JsonProperty(value="afterCursor")
    @JsonPropertyDescription(value="Provide After in case of failure to start reindexing after the issue is solved")
    private String afterCursor;

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public EventPublisherJob withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="timestamp")
    public Long getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="timestamp")
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public EventPublisherJob withTimestamp(Long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @JsonProperty(value="status")
    public Status getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    public void setStatus(Status status) {
        this.status = status;
    }

    public EventPublisherJob withStatus(Status status) {
        this.status = status;
        return this;
    }

    @JsonProperty(value="failure")
    public IndexingError getFailure() {
        return this.failure;
    }

    @JsonProperty(value="failure")
    public void setFailure(IndexingError failure) {
        this.failure = failure;
    }

    public EventPublisherJob withFailure(IndexingError failure) {
        this.failure = failure;
        return this;
    }

    @JsonProperty(value="stats")
    public Stats getStats() {
        return this.stats;
    }

    @JsonProperty(value="stats")
    public void setStats(Stats stats) {
        this.stats = stats;
    }

    public EventPublisherJob withStats(Stats stats) {
        this.stats = stats;
        return this;
    }

    @JsonProperty(value="entities")
    public Set<String> getEntities() {
        return this.entities;
    }

    @JsonProperty(value="entities")
    public void setEntities(Set<String> entities) {
        this.entities = entities;
    }

    public EventPublisherJob withEntities(Set<String> entities) {
        this.entities = entities;
        return this;
    }

    @JsonProperty(value="recreateIndex")
    public Boolean getRecreateIndex() {
        return this.recreateIndex;
    }

    @JsonProperty(value="recreateIndex")
    public void setRecreateIndex(Boolean recreateIndex) {
        this.recreateIndex = recreateIndex;
    }

    public EventPublisherJob withRecreateIndex(Boolean recreateIndex) {
        this.recreateIndex = recreateIndex;
        return this;
    }

    @JsonProperty(value="batchSize")
    public Integer getBatchSize() {
        return this.batchSize;
    }

    @JsonProperty(value="batchSize")
    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    public EventPublisherJob withBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    @JsonProperty(value="payLoadSize")
    public Long getPayLoadSize() {
        return this.payLoadSize;
    }

    @JsonProperty(value="payLoadSize")
    public void setPayLoadSize(Long payLoadSize) {
        this.payLoadSize = payLoadSize;
    }

    public EventPublisherJob withPayLoadSize(Long payLoadSize) {
        this.payLoadSize = payLoadSize;
        return this;
    }

    @JsonProperty(value="producerThreads")
    public Integer getProducerThreads() {
        return this.producerThreads;
    }

    @JsonProperty(value="producerThreads")
    public void setProducerThreads(Integer producerThreads) {
        this.producerThreads = producerThreads;
    }

    public EventPublisherJob withProducerThreads(Integer producerThreads) {
        this.producerThreads = producerThreads;
        return this;
    }

    @JsonProperty(value="consumerThreads")
    public Integer getConsumerThreads() {
        return this.consumerThreads;
    }

    @JsonProperty(value="consumerThreads")
    public void setConsumerThreads(Integer consumerThreads) {
        this.consumerThreads = consumerThreads;
    }

    public EventPublisherJob withConsumerThreads(Integer consumerThreads) {
        this.consumerThreads = consumerThreads;
        return this;
    }

    @JsonProperty(value="queueSize")
    public Integer getQueueSize() {
        return this.queueSize;
    }

    @JsonProperty(value="queueSize")
    public void setQueueSize(Integer queueSize) {
        this.queueSize = queueSize;
    }

    public EventPublisherJob withQueueSize(Integer queueSize) {
        this.queueSize = queueSize;
        return this;
    }

    @JsonProperty(value="maxConcurrentRequests")
    public Integer getMaxConcurrentRequests() {
        return this.maxConcurrentRequests;
    }

    @JsonProperty(value="maxConcurrentRequests")
    public void setMaxConcurrentRequests(Integer maxConcurrentRequests) {
        this.maxConcurrentRequests = maxConcurrentRequests;
    }

    public EventPublisherJob withMaxConcurrentRequests(Integer maxConcurrentRequests) {
        this.maxConcurrentRequests = maxConcurrentRequests;
        return this;
    }

    @JsonProperty(value="maxRetries")
    public Integer getMaxRetries() {
        return this.maxRetries;
    }

    @JsonProperty(value="maxRetries")
    public void setMaxRetries(Integer maxRetries) {
        this.maxRetries = maxRetries;
    }

    public EventPublisherJob withMaxRetries(Integer maxRetries) {
        this.maxRetries = maxRetries;
        return this;
    }

    @JsonProperty(value="initialBackoff")
    public Integer getInitialBackoff() {
        return this.initialBackoff;
    }

    @JsonProperty(value="initialBackoff")
    public void setInitialBackoff(Integer initialBackoff) {
        this.initialBackoff = initialBackoff;
    }

    public EventPublisherJob withInitialBackoff(Integer initialBackoff) {
        this.initialBackoff = initialBackoff;
        return this;
    }

    @JsonProperty(value="maxBackoff")
    public Integer getMaxBackoff() {
        return this.maxBackoff;
    }

    @JsonProperty(value="maxBackoff")
    public void setMaxBackoff(Integer maxBackoff) {
        this.maxBackoff = maxBackoff;
    }

    public EventPublisherJob withMaxBackoff(Integer maxBackoff) {
        this.maxBackoff = maxBackoff;
        return this;
    }

    @JsonProperty(value="searchIndexMappingLanguage")
    public IndexMappingLanguage getSearchIndexMappingLanguage() {
        return this.searchIndexMappingLanguage;
    }

    @JsonProperty(value="searchIndexMappingLanguage")
    public void setSearchIndexMappingLanguage(IndexMappingLanguage searchIndexMappingLanguage) {
        this.searchIndexMappingLanguage = searchIndexMappingLanguage;
    }

    public EventPublisherJob withSearchIndexMappingLanguage(IndexMappingLanguage searchIndexMappingLanguage) {
        this.searchIndexMappingLanguage = searchIndexMappingLanguage;
        return this;
    }

    @JsonProperty(value="afterCursor")
    public String getAfterCursor() {
        return this.afterCursor;
    }

    @JsonProperty(value="afterCursor")
    public void setAfterCursor(String afterCursor) {
        this.afterCursor = afterCursor;
    }

    public EventPublisherJob withAfterCursor(String afterCursor) {
        this.afterCursor = afterCursor;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(EventPublisherJob.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("timestamp");
        sb.append('=');
        sb.append(this.timestamp == null ? "<null>" : this.timestamp);
        sb.append(',');
        sb.append("status");
        sb.append('=');
        sb.append(this.status == null ? "<null>" : this.status);
        sb.append(',');
        sb.append("failure");
        sb.append('=');
        sb.append(this.failure == null ? "<null>" : this.failure);
        sb.append(',');
        sb.append("stats");
        sb.append('=');
        sb.append(this.stats == null ? "<null>" : this.stats);
        sb.append(',');
        sb.append("entities");
        sb.append('=');
        sb.append(this.entities == null ? "<null>" : this.entities);
        sb.append(',');
        sb.append("recreateIndex");
        sb.append('=');
        sb.append(this.recreateIndex == null ? "<null>" : this.recreateIndex);
        sb.append(',');
        sb.append("batchSize");
        sb.append('=');
        sb.append(this.batchSize == null ? "<null>" : this.batchSize);
        sb.append(',');
        sb.append("payLoadSize");
        sb.append('=');
        sb.append(this.payLoadSize == null ? "<null>" : this.payLoadSize);
        sb.append(',');
        sb.append("producerThreads");
        sb.append('=');
        sb.append(this.producerThreads == null ? "<null>" : this.producerThreads);
        sb.append(',');
        sb.append("consumerThreads");
        sb.append('=');
        sb.append(this.consumerThreads == null ? "<null>" : this.consumerThreads);
        sb.append(',');
        sb.append("queueSize");
        sb.append('=');
        sb.append(this.queueSize == null ? "<null>" : this.queueSize);
        sb.append(',');
        sb.append("maxConcurrentRequests");
        sb.append('=');
        sb.append(this.maxConcurrentRequests == null ? "<null>" : this.maxConcurrentRequests);
        sb.append(',');
        sb.append("maxRetries");
        sb.append('=');
        sb.append(this.maxRetries == null ? "<null>" : this.maxRetries);
        sb.append(',');
        sb.append("initialBackoff");
        sb.append('=');
        sb.append(this.initialBackoff == null ? "<null>" : this.initialBackoff);
        sb.append(',');
        sb.append("maxBackoff");
        sb.append('=');
        sb.append(this.maxBackoff == null ? "<null>" : this.maxBackoff);
        sb.append(',');
        sb.append("searchIndexMappingLanguage");
        sb.append('=');
        sb.append(this.searchIndexMappingLanguage == null ? "<null>" : this.searchIndexMappingLanguage);
        sb.append(',');
        sb.append("afterCursor");
        sb.append('=');
        sb.append(this.afterCursor == null ? "<null>" : this.afterCursor);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.queueSize == null ? 0 : this.queueSize.hashCode());
        result = result * 31 + (this.maxBackoff == null ? 0 : this.maxBackoff.hashCode());
        result = result * 31 + (this.searchIndexMappingLanguage == null ? 0 : this.searchIndexMappingLanguage.hashCode());
        result = result * 31 + (this.recreateIndex == null ? 0 : this.recreateIndex.hashCode());
        result = result * 31 + (this.maxConcurrentRequests == null ? 0 : this.maxConcurrentRequests.hashCode());
        result = result * 31 + (this.initialBackoff == null ? 0 : this.initialBackoff.hashCode());
        result = result * 31 + (this.maxRetries == null ? 0 : this.maxRetries.hashCode());
        result = result * 31 + (this.stats == null ? 0 : this.stats.hashCode());
        result = result * 31 + (this.entities == null ? 0 : this.entities.hashCode());
        result = result * 31 + (this.producerThreads == null ? 0 : this.producerThreads.hashCode());
        result = result * 31 + (this.failure == null ? 0 : this.failure.hashCode());
        result = result * 31 + (this.afterCursor == null ? 0 : this.afterCursor.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.payLoadSize == null ? 0 : this.payLoadSize.hashCode());
        result = result * 31 + (this.consumerThreads == null ? 0 : this.consumerThreads.hashCode());
        result = result * 31 + (this.batchSize == null ? 0 : this.batchSize.hashCode());
        result = result * 31 + (this.timestamp == null ? 0 : this.timestamp.hashCode());
        result = result * 31 + (this.status == null ? 0 : this.status.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof EventPublisherJob)) {
            return false;
        }
        EventPublisherJob rhs = (EventPublisherJob)other;
        return (this.queueSize == rhs.queueSize || this.queueSize != null && this.queueSize.equals(rhs.queueSize)) && (this.maxBackoff == rhs.maxBackoff || this.maxBackoff != null && this.maxBackoff.equals(rhs.maxBackoff)) && (this.searchIndexMappingLanguage == rhs.searchIndexMappingLanguage || this.searchIndexMappingLanguage != null && this.searchIndexMappingLanguage.equals((Object)rhs.searchIndexMappingLanguage)) && (this.recreateIndex == rhs.recreateIndex || this.recreateIndex != null && this.recreateIndex.equals(rhs.recreateIndex)) && (this.maxConcurrentRequests == rhs.maxConcurrentRequests || this.maxConcurrentRequests != null && this.maxConcurrentRequests.equals(rhs.maxConcurrentRequests)) && (this.initialBackoff == rhs.initialBackoff || this.initialBackoff != null && this.initialBackoff.equals(rhs.initialBackoff)) && (this.maxRetries == rhs.maxRetries || this.maxRetries != null && this.maxRetries.equals(rhs.maxRetries)) && (this.stats == rhs.stats || this.stats != null && this.stats.equals(rhs.stats)) && (this.entities == rhs.entities || this.entities != null && this.entities.equals(rhs.entities)) && (this.producerThreads == rhs.producerThreads || this.producerThreads != null && this.producerThreads.equals(rhs.producerThreads)) && (this.failure == rhs.failure || this.failure != null && this.failure.equals(rhs.failure)) && (this.afterCursor == rhs.afterCursor || this.afterCursor != null && this.afterCursor.equals(rhs.afterCursor)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.payLoadSize == rhs.payLoadSize || this.payLoadSize != null && this.payLoadSize.equals(rhs.payLoadSize)) && (this.consumerThreads == rhs.consumerThreads || this.consumerThreads != null && this.consumerThreads.equals(rhs.consumerThreads)) && (this.batchSize == rhs.batchSize || this.batchSize != null && this.batchSize.equals(rhs.batchSize)) && (this.timestamp == rhs.timestamp || this.timestamp != null && this.timestamp.equals(rhs.timestamp)) && (this.status == rhs.status || this.status != null && this.status.equals((Object)rhs.status));
    }

    public static enum Status {
        STARTED("started"),
        RUNNING("running"),
        COMPLETED("completed"),
        FAILED("failed"),
        ACTIVE("active"),
        ACTIVE_ERROR("activeError"),
        STOPPED("stopped"),
        SUCCESS("success");

        private final String value;
        private static final Map<String, Status> CONSTANTS;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Status fromValue(String value) {
            Status constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Status>();
            for (Status c : Status.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

