/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.system;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.openmetadata.schema.system.EntityError;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"errorSource", "lastFailedCursor", "message", "failedEntities", "reason", "stackTrace", "submittedCount", "successCount", "failedCount"})
public class IndexingError {
    @JsonProperty(value="errorSource")
    private ErrorSource errorSource;
    @JsonProperty(value="lastFailedCursor")
    private String lastFailedCursor;
    @JsonProperty(value="message")
    private String message;
    @JsonProperty(value="failedEntities")
    @Valid
    private List<EntityError> failedEntities = new ArrayList<EntityError>();
    @JsonProperty(value="reason")
    private String reason;
    @JsonProperty(value="stackTrace")
    private String stackTrace;
    @JsonProperty(value="submittedCount")
    private Integer submittedCount;
    @JsonProperty(value="successCount")
    private Integer successCount;
    @JsonProperty(value="failedCount")
    private Integer failedCount;

    @JsonProperty(value="errorSource")
    public ErrorSource getErrorSource() {
        return this.errorSource;
    }

    @JsonProperty(value="errorSource")
    public void setErrorSource(ErrorSource errorSource) {
        this.errorSource = errorSource;
    }

    public IndexingError withErrorSource(ErrorSource errorSource) {
        this.errorSource = errorSource;
        return this;
    }

    @JsonProperty(value="lastFailedCursor")
    public String getLastFailedCursor() {
        return this.lastFailedCursor;
    }

    @JsonProperty(value="lastFailedCursor")
    public void setLastFailedCursor(String lastFailedCursor) {
        this.lastFailedCursor = lastFailedCursor;
    }

    public IndexingError withLastFailedCursor(String lastFailedCursor) {
        this.lastFailedCursor = lastFailedCursor;
        return this;
    }

    @JsonProperty(value="message")
    public String getMessage() {
        return this.message;
    }

    @JsonProperty(value="message")
    public void setMessage(String message) {
        this.message = message;
    }

    public IndexingError withMessage(String message) {
        this.message = message;
        return this;
    }

    @JsonProperty(value="failedEntities")
    public List<EntityError> getFailedEntities() {
        return this.failedEntities;
    }

    @JsonProperty(value="failedEntities")
    public void setFailedEntities(List<EntityError> failedEntities) {
        this.failedEntities = failedEntities;
    }

    public IndexingError withFailedEntities(List<EntityError> failedEntities) {
        this.failedEntities = failedEntities;
        return this;
    }

    @JsonProperty(value="reason")
    public String getReason() {
        return this.reason;
    }

    @JsonProperty(value="reason")
    public void setReason(String reason) {
        this.reason = reason;
    }

    public IndexingError withReason(String reason) {
        this.reason = reason;
        return this;
    }

    @JsonProperty(value="stackTrace")
    public String getStackTrace() {
        return this.stackTrace;
    }

    @JsonProperty(value="stackTrace")
    public void setStackTrace(String stackTrace) {
        this.stackTrace = stackTrace;
    }

    public IndexingError withStackTrace(String stackTrace) {
        this.stackTrace = stackTrace;
        return this;
    }

    @JsonProperty(value="submittedCount")
    public Integer getSubmittedCount() {
        return this.submittedCount;
    }

    @JsonProperty(value="submittedCount")
    public void setSubmittedCount(Integer submittedCount) {
        this.submittedCount = submittedCount;
    }

    public IndexingError withSubmittedCount(Integer submittedCount) {
        this.submittedCount = submittedCount;
        return this;
    }

    @JsonProperty(value="successCount")
    public Integer getSuccessCount() {
        return this.successCount;
    }

    @JsonProperty(value="successCount")
    public void setSuccessCount(Integer successCount) {
        this.successCount = successCount;
    }

    public IndexingError withSuccessCount(Integer successCount) {
        this.successCount = successCount;
        return this;
    }

    @JsonProperty(value="failedCount")
    public Integer getFailedCount() {
        return this.failedCount;
    }

    @JsonProperty(value="failedCount")
    public void setFailedCount(Integer failedCount) {
        this.failedCount = failedCount;
    }

    public IndexingError withFailedCount(Integer failedCount) {
        this.failedCount = failedCount;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(IndexingError.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("errorSource");
        sb.append('=');
        sb.append(this.errorSource == null ? "<null>" : this.errorSource);
        sb.append(',');
        sb.append("lastFailedCursor");
        sb.append('=');
        sb.append(this.lastFailedCursor == null ? "<null>" : this.lastFailedCursor);
        sb.append(',');
        sb.append("message");
        sb.append('=');
        sb.append(this.message == null ? "<null>" : this.message);
        sb.append(',');
        sb.append("failedEntities");
        sb.append('=');
        sb.append(this.failedEntities == null ? "<null>" : this.failedEntities);
        sb.append(',');
        sb.append("reason");
        sb.append('=');
        sb.append(this.reason == null ? "<null>" : this.reason);
        sb.append(',');
        sb.append("stackTrace");
        sb.append('=');
        sb.append(this.stackTrace == null ? "<null>" : this.stackTrace);
        sb.append(',');
        sb.append("submittedCount");
        sb.append('=');
        sb.append(this.submittedCount == null ? "<null>" : this.submittedCount);
        sb.append(',');
        sb.append("successCount");
        sb.append('=');
        sb.append(this.successCount == null ? "<null>" : this.successCount);
        sb.append(',');
        sb.append("failedCount");
        sb.append('=');
        sb.append(this.failedCount == null ? "<null>" : this.failedCount);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.failedEntities == null ? 0 : this.failedEntities.hashCode());
        result = result * 31 + (this.reason == null ? 0 : this.reason.hashCode());
        result = result * 31 + (this.failedCount == null ? 0 : this.failedCount.hashCode());
        result = result * 31 + (this.errorSource == null ? 0 : this.errorSource.hashCode());
        result = result * 31 + (this.submittedCount == null ? 0 : this.submittedCount.hashCode());
        result = result * 31 + (this.successCount == null ? 0 : this.successCount.hashCode());
        result = result * 31 + (this.stackTrace == null ? 0 : this.stackTrace.hashCode());
        result = result * 31 + (this.message == null ? 0 : this.message.hashCode());
        result = result * 31 + (this.lastFailedCursor == null ? 0 : this.lastFailedCursor.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof IndexingError)) {
            return false;
        }
        IndexingError rhs = (IndexingError)other;
        return (this.failedEntities == rhs.failedEntities || this.failedEntities != null && this.failedEntities.equals(rhs.failedEntities)) && (this.reason == rhs.reason || this.reason != null && this.reason.equals(rhs.reason)) && (this.failedCount == rhs.failedCount || this.failedCount != null && this.failedCount.equals(rhs.failedCount)) && (this.errorSource == rhs.errorSource || this.errorSource != null && this.errorSource.equals((Object)rhs.errorSource)) && (this.submittedCount == rhs.submittedCount || this.submittedCount != null && this.submittedCount.equals(rhs.submittedCount)) && (this.successCount == rhs.successCount || this.successCount != null && this.successCount.equals(rhs.successCount)) && (this.stackTrace == rhs.stackTrace || this.stackTrace != null && this.stackTrace.equals(rhs.stackTrace)) && (this.message == rhs.message || this.message != null && this.message.equals(rhs.message)) && (this.lastFailedCursor == rhs.lastFailedCursor || this.lastFailedCursor != null && this.lastFailedCursor.equals(rhs.lastFailedCursor));
    }

    public static enum ErrorSource {
        JOB("Job"),
        READER("Reader"),
        PROCESSOR("Processor"),
        SINK("Sink");

        private final String value;
        private static final Map<String, ErrorSource> CONSTANTS;

        private ErrorSource(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ErrorSource fromValue(String value) {
            ErrorSource constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, ErrorSource>();
            for (ErrorSource c : ErrorSource.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

